/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.prof;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.value.Value;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.query.value.map.Map;
import org.basex.util.InputInfo;
import org.basex.util.Performance;
import org.basex.util.options.BooleanOption;
import org.basex.util.options.Options;

public final class ProfTrack
extends StandardFunc {
    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        TrackOptions opts = this.toOptions(1, new TrackOptions(), qc);
        Performance perf = null;
        long min = -1L;
        if (opts.get(TrackOptions.MEMORY).booleanValue()) {
            Performance.gc(4);
            min = Performance.memory();
        }
        if (opts.get(TrackOptions.TIME).booleanValue()) {
            perf = new Performance();
        }
        Value value = null;
        if (opts.get(TrackOptions.VALUE).booleanValue()) {
            value = this.exprs[0].value(qc);
        } else {
            Iter iter = this.exprs[0].iter(qc);
            if (iter.value() == null) {
                while (qc.next(iter) != null) {
                }
            }
        }
        Map map = Map.EMPTY;
        if (perf != null) {
            long time = perf.ns();
            map = map.put(Str.get(TrackOptions.TIME.name()), Dbl.get(Performance.ms(time, 1)), this.info);
        }
        if (min != -1L) {
            Performance.gc(2);
            long mem = Math.max(0L, Performance.memory() - min);
            map = map.put(Str.get(TrackOptions.MEMORY.name()), Int.get(mem), this.info);
        }
        if (value != null) {
            map = map.put(Str.get(TrackOptions.VALUE.name()), value, this.info);
        }
        return map;
    }

    @Override
    protected Expr opt(CompileContext cc) {
        return this.adoptType(this.exprs[0]);
    }

    public static final class TrackOptions
    extends Options {
        public static final BooleanOption VALUE = new BooleanOption("value", true);
        public static final BooleanOption TIME = new BooleanOption("time", true);
        public static final BooleanOption MEMORY = new BooleanOption("memory", true);
    }
}

