/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.proc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.basex.core.jobs.JobException;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.StandardFunc;
import org.basex.query.func.proc.ProcOptions;
import org.basex.query.func.proc.ProcResult;
import org.basex.query.iter.Iter;
import org.basex.query.value.item.Item;
import org.basex.util.Performance;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.list.TokenList;

abstract class ProcFn
extends StandardFunc {
    static final String RESULT = "result";
    static final String OUTPUT = "output";
    static final String ERROR = "error";
    static final String CODE = "code";

    ProcFn() {
    }

    final ProcResult exec(QueryContext qc, boolean fork) throws QueryException {
        Process proc;
        Charset cs;
        this.checkAdmin(qc);
        TokenList tl = new TokenList();
        tl.add(this.toToken(this.exprs[0], qc));
        if (this.exprs.length > 1) {
            Item item;
            Iter iter = this.exprs[1].iter(qc);
            while ((item = qc.next(iter)) != null) {
                tl.add(this.toToken(item));
            }
        }
        String[] args = tl.toStringArray();
        ProcOptions opts = this.toOptions(2, new ProcOptions(), qc);
        String enc = opts.get(ProcOptions.ENCODING);
        try {
            cs = Charset.forName(enc);
        }
        catch (Exception ex) {
            Util.debug(ex);
            throw QueryError.PROC_ENCODING_X.get(this.info, enc);
        }
        long seconds = opts.get(ProcOptions.TIMEOUT).intValue();
        String dir = opts.get(ProcOptions.DIR);
        String input = opts.get(ProcOptions.INPUT);
        ProcResult result = new ProcResult();
        ProcessBuilder pb = new ProcessBuilder(args);
        if (dir != null) {
            pb.directory(this.toPath(Token.token(dir)).toFile());
        }
        try {
            proc = pb.start();
        }
        catch (IOException ex) {
            result.exception(ex);
            return result;
        }
        if (fork) {
            return null;
        }
        Thread outt = this.reader(proc.getInputStream(), result.output, cs, result);
        Thread errt = this.reader(proc.getErrorStream(), result.error, cs, result);
        outt.start();
        errt.start();
        Thread thread = new Thread(() -> {
            try {
                if (input != null) {
                    Throwable throwable = null;
                    Object var6_9 = null;
                    try (OutputStream os = proc.getOutputStream();){
                        os.write(Token.token(input));
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                proc.waitFor();
                outt.join();
                errt.join();
            }
            catch (IOException ex) {
                result.exception(ex);
            }
            catch (InterruptedException ex) {
                procResult.error.add(Util.message(ex));
            }
        });
        thread.start();
        Performance perf = new Performance();
        try {
            while (thread.isAlive()) {
                qc.checkStop();
                if (seconds > 0L && (System.nanoTime() - perf.start()) / 1000000000L >= seconds) {
                    thread.interrupt();
                    throw QueryError.PROC_TIMEOUT.get(this.info, new Object[0]);
                }
                Performance.sleep(10L);
            }
            result.code = proc.exitValue();
            return result;
        }
        catch (JobException ex) {
            thread.interrupt();
            throw ex;
        }
    }

    private Thread reader(InputStream in, TokenBuilder tb, Charset cs, ProcResult pr) {
        InputStreamReader isr = new InputStreamReader(in, cs);
        BufferedReader br = new BufferedReader(isr);
        return new Thread(() -> {
            try {
                int b;
                while ((b = br.read()) != -1) {
                    tb.add(b);
                }
            }
            catch (IOException ex) {
                procResult.exception = ex;
            }
        });
    }
}

