/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.inspect;

import org.basex.io.IO;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.func.StaticFunc;
import org.basex.query.func.inspect.Inspect;
import org.basex.query.scope.LibraryModule;
import org.basex.query.scope.StaticScope;
import org.basex.query.util.list.AnnList;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.StaticVar;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.hash.TokenObjMap;
import org.basex.util.list.TokenList;

final class PlainDoc
extends Inspect {
    PlainDoc(QueryContext qc, InputInfo info) {
        super(qc, info);
    }

    FElem context() throws QueryException {
        FElem root = this.elem("context", null);
        for (StaticVar sv : this.qc.vars) {
            this.variable(sv, root);
        }
        StaticFunc[] staticFuncArray = this.qc.funcs.funcs();
        int n = staticFuncArray.length;
        int n2 = 0;
        while (n2 < n) {
            StaticFunc sf = staticFuncArray[n2];
            this.function(sf.name, sf, sf.funcType(), sf.anns, root);
            ++n2;
        }
        return root;
    }

    @Override
    public FElem parse(IO io) throws QueryException {
        TokenObjMap<TokenList> doc;
        this.parseQuery(io);
        FElem root = this.elem("module", null);
        if (this.module instanceof LibraryModule) {
            QNm name = ((LibraryModule)this.module).name;
            root.add("prefix", name.string());
            root.add("uri", name.uri());
        }
        if ((doc = this.module.doc()) != null) {
            this.comment(doc, root);
        }
        for (StaticVar sv : this.module.vars().values()) {
            this.variable(sv, root);
        }
        for (StaticFunc sf : this.module.funcs().values()) {
            this.function(sf.name, sf, sf.funcType(), sf.anns, root);
        }
        return root;
    }

    private FElem variable(StaticVar sv, FElem parent) throws QueryException {
        FElem variable = this.elem("variable", parent);
        variable.add("name", sv.name.string());
        if (sv.name.uri().length != 0) {
            variable.add("uri", sv.name.uri());
        }
        PlainDoc.type(sv.seqType(), variable);
        variable.add("external", Boolean.toString(sv.external));
        this.comment(sv, variable);
        this.annotation(sv.anns, variable, true);
        return variable;
    }

    FElem function(QNm fname, StaticFunc sf, FuncType ft, AnnList anns, FElem parent) throws QueryException {
        TokenList returns;
        Object uri;
        FElem function = this.elem("function", parent);
        if (fname != null) {
            function.add("name", fname.string());
            if (fname.uri().length != 0) {
                function.add("uri", fname.uri());
            }
        }
        function.add("external", Boolean.toString(sf != null && sf.expr == null));
        TokenObjMap<TokenList> doc = sf != null ? sf.doc() : null;
        int al = ft.argTypes.length;
        QNm[] names = null;
        if (sf != null) {
            names = new QNm[al];
            int n = 0;
            while (n < al) {
                names[n] = sf.params[n].name;
                ++n;
            }
        }
        int a = 0;
        while (a < al) {
            FElem argument = this.elem("argument", function);
            if (names != null) {
                byte[] name = names[a].string();
                uri = names[a].uri();
                byte[] pdoc = PlainDoc.doc(doc, name);
                argument.add("name", name);
                if (((byte[])uri).length != 0) {
                    argument.add("uri", (byte[])uri);
                }
                if (pdoc != null) {
                    PlainDoc.add(pdoc, argument);
                }
            }
            PlainDoc.type(ft.argTypes[a], argument);
            ++a;
        }
        this.annotation(anns, function, true);
        if (doc != null) {
            for (byte[] key : doc) {
                if (Token.eq(key, DOC_PARAM, DOC_RETURN)) continue;
                uri = doc.get(key).iterator();
                while (uri.hasNext()) {
                    byte[] value = (byte[])uri.next();
                    FElem elem = Token.eq(key, DOC_TAGS) ? this.elem(Token.string(key), function) : this.elem("tag", function).add("name", key);
                    PlainDoc.add(value, elem);
                }
            }
        }
        SeqType st = sf != null ? sf.seqType() : ft.declType;
        FElem ret = this.elem("return", function);
        PlainDoc.type(st, ret);
        TokenList tokenList = returns = doc != null ? doc.get(DOC_RETURN) : null;
        if (returns != null) {
            for (byte[] val : returns) {
                PlainDoc.add(val, ret);
            }
        }
        return function;
    }

    @Override
    protected FElem elem(String name, FElem parent) {
        FElem elem = new FElem(name);
        if (parent != null) {
            parent.add(elem);
        }
        return elem;
    }

    private void comment(StaticScope scope, FElem parent) {
        TokenObjMap<TokenList> tags = scope.doc();
        if (tags != null) {
            this.comment(tags, parent);
        }
    }

    @Override
    protected FElem elem(byte[] tag, FElem parent) {
        String string = Token.string(tag);
        return this.elem(Token.eq(tag, DOC_TAGS) ? string : String.valueOf(string) + "_tag", parent);
    }

    private static void type(SeqType st, FElem elem) {
        if (st != null) {
            elem.add("type", st.typeString());
            String occ = st.occ.toString();
            if (!occ.isEmpty()) {
                elem.add("occurrence", occ);
            }
        }
    }
}

