/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.query.value.type.SeqType;
import org.basex.util.InputInfo;
import org.basex.util.TokenBuilder;
import org.basex.util.XMLToken;

public final class FnCodepointsToString
extends StandardFunc {
    private boolean singleInt;

    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        Item item;
        if (this.singleInt) {
            return FnCodepointsToString.toStr(this.exprs[0].item(qc, this.info).itr(ii), this.info);
        }
        Iter iter = this.exprs[0].atomIter(qc, this.info);
        long size = iter.size();
        if (size == 1L) {
            return FnCodepointsToString.toStr(this.toLong(iter.next()), this.info);
        }
        TokenBuilder tb = new TokenBuilder(Math.max(8, (int)size));
        while ((item = qc.next(iter)) != null) {
            tb.add(FnCodepointsToString.check(this.toLong(item), this.info));
        }
        return Str.get(tb.finish());
    }

    @Override
    protected Expr opt(CompileContext cc) {
        this.singleInt = this.exprs[0].seqType().instanceOf(SeqType.ITR_O);
        return this;
    }

    private static Str toStr(long value, InputInfo info) throws QueryException {
        byte[] byArray;
        int cp = FnCodepointsToString.check(value, info);
        if (cp <= 127) {
            byte[] byArray2 = new byte[1];
            byArray = byArray2;
            byArray2[0] = (byte)cp;
        } else {
            byArray = new TokenBuilder(4).add(FnCodepointsToString.check(cp, info)).finish();
        }
        return Str.get(byArray);
    }

    private static int check(long value, InputInfo info) throws QueryException {
        int cp;
        if (value >= 0L && value <= Integer.MAX_VALUE && XMLToken.valid(cp = (int)value)) {
            return cp;
        }
        throw QueryError.INVCODE_X.get(info, Long.toHexString(value));
    }
}

