/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.archive;

import java.io.IOException;
import java.util.Locale;
import org.basex.io.IOFile;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.archive.ArchOptions;
import org.basex.query.func.archive.ArchiveCreate;
import org.basex.query.func.archive.ArchiveOut;
import org.basex.query.iter.BasicIter;
import org.basex.query.value.item.B64;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.StrSeq;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.list.TokenList;

public class ArchiveCreateFrom
extends ArchiveCreate {
    @Override
    public B64 item(QueryContext qc, InputInfo ii) throws QueryException {
        BasicIter<Item> entries;
        this.checkCreate(qc);
        IOFile root = new IOFile(this.toPath(0, qc).toString());
        ArchOptions opts = this.toOptions(1, new ArchOptions(), qc);
        if (this.exprs.length > 2) {
            entries = this.exprs[2].iter(qc);
        } else {
            TokenList tl = new TokenList();
            for (String file : root.descendants()) {
                tl.add(file);
            }
            entries = StrSeq.get(tl).iter();
        }
        String format = opts.get(ArchOptions.FORMAT);
        int level = this.level(opts);
        if (!root.isDir()) {
            throw QueryError.FILE_NO_DIR_X.get(this.info, root);
        }
        Object object = null;
        Object var9_11 = null;
        try (ArchiveOut out = ArchiveOut.get(format.toLowerCase(Locale.ENGLISH), this.info);){
            out.level(level);
            try {
                Item en;
                while ((en = qc.next(entries)) != null) {
                    IOFile file = new IOFile(root, Token.string((en = this.checkElemToken(en)).string(this.info)));
                    if (!file.exists()) {
                        throw QueryError.FILE_NOT_FOUND_X.get(this.info, file);
                    }
                    if (file.isDir()) {
                        throw QueryError.FILE_IS_DIR_X.get(this.info, file);
                    }
                    this.add(en, B64.get(file.read()), out, level, qc);
                }
            }
            catch (IOException ex) {
                throw QueryError.ARCHIVE_ERROR_X.get(this.info, ex);
            }
            return B64.get(out.finish());
        }
        catch (Throwable throwable) {
            if (object == null) {
                object = throwable;
            } else if (object != throwable) {
                ((Throwable)object).addSuppressed(throwable);
            }
            throw object;
        }
    }
}

