/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.StaticContext;
import org.basex.query.ann.Annotation;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.func.FuncCall;
import org.basex.query.func.StaticFunc;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.value.Value;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.FElem;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.TokenBuilder;
import org.basex.util.hash.IntObjMap;

public final class StaticFuncCall
extends FuncCall {
    private final StaticContext sc;
    final QNm name;
    StaticFunc func;

    public StaticFuncCall(QNm name, Expr[] args, StaticContext sc, InputInfo info) {
        this(name, args, sc, null, info);
    }

    private StaticFuncCall(QNm name, Expr[] args, StaticContext sc, StaticFunc func, InputInfo info) {
        super(info, args);
        this.sc = sc;
        this.name = name;
        this.func = func;
    }

    @Override
    public Expr compile(CompileContext cc) throws QueryException {
        super.compile(cc);
        this.checkVisible();
        this.func.comp(cc);
        Expr inl = this.func.inlineExpr(this.exprs, cc, this.info);
        if (inl != null) {
            return inl;
        }
        this.exprType.assign(this.func.seqType());
        return this;
    }

    @Override
    public StaticFuncCall optimize(CompileContext cc) {
        return this;
    }

    @Override
    public StaticFuncCall copy(CompileContext cc, IntObjMap<Var> vm) {
        return this.copyType(new StaticFuncCall(this.name, Arr.copyAll((CompileContext)cc, vm, (Expr[])this.exprs), this.sc, this.func, this.info));
    }

    public StaticFuncCall init(StaticFunc sf) throws QueryException {
        this.func = sf;
        this.checkVisible();
        return this;
    }

    private void checkVisible() throws QueryException {
        if (this.func.anns.contains(Annotation.PRIVATE) && !this.func.sc.baseURI().eq(this.sc.baseURI())) {
            throw QueryError.FUNCPRIVATE_X.get(this.info, new Object[]{this.name.string()});
        }
    }

    public StaticFunc func() {
        return this.func;
    }

    @Override
    public boolean isVacuous() {
        return this.func.isVacuousBody();
    }

    @Override
    public boolean has(Flag ... flags) {
        if (super.has(flags)) {
            return true;
        }
        if (Flag.POS.in(flags) || Flag.CTX.in(flags)) {
            return false;
        }
        if (Flag.UPD.in(flags) && this.func.updating()) {
            return true;
        }
        Flag[] flgs = Flag.UPD.remove(flags);
        return flgs.length != 0 && this.func.has(flgs);
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return visitor.staticFuncCall(this) && super.accept(visitor);
    }

    @Override
    public StaticFunc evalFunc(QueryContext qc) {
        return this.func;
    }

    @Override
    Value[] evalArgs(QueryContext qc) throws QueryException {
        int al = this.exprs.length;
        Value[] args = new Value[al];
        int a = 0;
        while (a < al) {
            args[a] = this.exprs[a].value(qc);
            ++a;
        }
        return args;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StaticFuncCall)) {
            return false;
        }
        StaticFuncCall s = (StaticFuncCall)obj;
        return this.name.eq(s.name) && this.func == s.func && super.equals(obj);
    }

    @Override
    public void plan(FElem plan) {
        StaticFuncCall.addPlan(plan, this.planElem("name", this.name.string(), "tailCall", this.tailCall), this.exprs);
    }

    @Override
    public String description() {
        return "function";
    }

    @Override
    public String toString() {
        return new TokenBuilder(this.name.prefixId()).add(this.toString(", ")).toString();
    }
}

