/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.util.Arrays;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.func.FuncCall;
import org.basex.query.func.XQFunctionExpr;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.util.list.ExprList;
import org.basex.query.value.Value;
import org.basex.query.value.array.Array;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.FuncItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.map.Map;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.MapType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.TokenBuilder;
import org.basex.util.hash.IntObjMap;

public final class DynFuncCall
extends FuncCall {
    private final StaticContext sc;
    private final boolean updating;
    private boolean ndt;
    private int[] inlinedFrom;

    public DynFuncCall(InputInfo info, StaticContext sc, Expr expr, Expr ... arg) {
        this(info, sc, false, false, expr, arg);
    }

    public DynFuncCall(InputInfo info, StaticContext sc, boolean updating, boolean ndt, Expr expr, Expr ... arg) {
        super(info, ExprList.concat(arg, expr));
        this.sc = sc;
        this.updating = updating;
        this.ndt = ndt;
        sc.dynFuncCall = true;
    }

    @Override
    public Expr compile(CompileContext cc) throws QueryException {
        if (this.body().has(Flag.NDT)) {
            this.ndt = true;
        }
        return super.compile(cc);
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        Expr func = this.body();
        Type type = func.seqType().type;
        int nargs = this.exprs.length - 1;
        if (type instanceof FuncType) {
            FuncType ft = (FuncType)type;
            if (ft.argTypes != null && ft.argTypes.length != nargs) {
                throw QueryError.INVARITY_X_X_X.get(this.info, QueryError.arguments(nargs), ft.argTypes.length, func.toErrorString());
            }
            SeqType dt = ft.declType;
            if (type instanceof MapType) {
                dt = dt.with(dt.occ.union(Occ.ZERO));
            }
            this.exprType.assign(dt);
        }
        if ((func instanceof Map || func instanceof Array) && this.allAreValues(false)) {
            return cc.preEval(this);
        }
        if (func instanceof XQFunctionExpr) {
            XQFunctionExpr fe = (XQFunctionExpr)((Object)func);
            if (!(func instanceof FuncItem) || !this.comesFrom((FuncItem)func)) {
                this.checkUp(fe, this.updating, this.sc);
                Expr[] args = Arrays.copyOf(this.exprs, nargs);
                Expr in = fe.inlineExpr(args, cc, this.info);
                if (in != null) {
                    return in;
                }
            }
        } else if (func instanceof Item) {
            throw QueryError.INVFUNCITEM_X_X.get(this.info, ((Item)func).type, func);
        }
        return this;
    }

    @Override
    public void checkUp() throws QueryException {
        this.checkNoneUp(Arrays.copyOf(this.exprs, this.exprs.length - 1));
        this.body().checkUp();
    }

    public void markInlined(FuncItem item) {
        int[] nArray;
        int hash = item.hashCode();
        if (this.inlinedFrom == null) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = hash;
        } else {
            nArray = org.basex.util.Array.add(this.inlinedFrom, hash);
        }
        this.inlinedFrom = nArray;
    }

    private boolean comesFrom(FuncItem item) {
        if (this.inlinedFrom != null) {
            int hash = item.hashCode();
            int[] nArray = this.inlinedFrom;
            int n = this.inlinedFrom.length;
            int n2 = 0;
            while (n2 < n) {
                int h = nArray[n2];
                if (hash == h) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private Expr body() {
        return this.exprs[this.exprs.length - 1];
    }

    @Override
    public Expr copy(CompileContext cc, IntObjMap<Var> vm) {
        Expr[] copy = DynFuncCall.copyAll((CompileContext)cc, vm, (Expr[])this.exprs);
        int last = copy.length - 1;
        Expr[] args = Arrays.copyOf(copy, last);
        DynFuncCall call = new DynFuncCall(this.info, this.sc, this.updating, this.ndt, copy[last], args);
        if (this.inlinedFrom != null) {
            call.inlinedFrom = (int[])this.inlinedFrom.clone();
        }
        return this.copyType(call);
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return visitor.dynFuncCall(this) && DynFuncCall.visitAll(visitor, this.exprs);
    }

    @Override
    public void plan(FElem plan) {
        FElem elem = this.planElem("tailCall", this.tailCall);
        DynFuncCall.addPlan(plan, elem, this.body());
        int last = this.exprs.length - 1;
        int e = 0;
        while (e < last) {
            this.exprs[e].plan(elem);
            ++e;
        }
    }

    @Override
    public String description() {
        return String.valueOf(this.body().description()) + "(...)";
    }

    @Override
    FItem evalFunc(QueryContext qc) throws QueryException {
        Item item = this.toItem(this.body(), qc);
        if (!(item instanceof FItem)) {
            throw QueryError.INVFUNCITEM_X_X.get(this.info, item.type, item);
        }
        FItem func = this.checkUp((FItem)item, this.updating, this.sc);
        int nargs = this.exprs.length - 1;
        if (func.arity() != nargs) {
            throw QueryError.INVARITY_X_X_X.get(this.info, QueryError.arguments(nargs), func.arity(), func.toErrorString());
        }
        return func;
    }

    @Override
    Value[] evalArgs(QueryContext qc) throws QueryException {
        int last = this.exprs.length - 1;
        Value[] args = new Value[last];
        int a = 0;
        while (a < last) {
            args[a] = this.exprs[a].value(qc);
            ++a;
        }
        return args;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof DynFuncCall && this.updating == ((DynFuncCall)obj).updating && super.equals(obj);
    }

    @Override
    public boolean has(Flag ... flags) {
        if (Flag.UPD.in(flags) && this.updating) {
            return true;
        }
        if (Flag.NDT.in(flags) && this.ndt) {
            return true;
        }
        Flag[] flgs = Flag.NDT.remove(Flag.UPD.remove(flags));
        return flgs.length != 0 && super.has(flgs);
    }

    @Override
    public String toString() {
        TokenBuilder tb = new TokenBuilder(this.body().toString()).add(40);
        int last = this.exprs.length - 1;
        int e = 0;
        while (e < last) {
            tb.add(this.exprs[e].toString());
            if (e < last - 1) {
                tb.add(", ");
            }
            ++e;
        }
        return tb.add(41).toString();
    }
}

