/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.gflwor;

import java.util.Objects;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Single;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.collation.Collation;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.TokenBuilder;
import org.basex.util.hash.IntObjMap;

public final class GroupSpec
extends Single {
    public final Var var;
    public boolean occluded;
    final Collation coll;

    public GroupSpec(InputInfo info, Var var, Expr expr, Collation coll) {
        super(info, expr, SeqType.ITEM_ZM);
        this.var = var;
        this.coll = coll;
    }

    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        return this.expr.item(qc, this.info);
    }

    @Override
    public Expr copy(CompileContext cc, IntObjMap<Var> vm) {
        GroupSpec spec = this.copyType(new GroupSpec(this.info, cc.copy(this.var, vm), this.expr.copy(cc, vm), this.coll));
        spec.occluded = this.occluded;
        return spec;
    }

    @Override
    public Expr compile(CompileContext cc) throws QueryException {
        return super.compile(cc).optimize(cc);
    }

    @Override
    public GroupSpec optimize(CompileContext cc) throws QueryException {
        this.adoptType(this.expr);
        AtomType type = this.expr.seqType().type.atomic();
        if (type != null) {
            this.var.refineType(this.seqType().with(type), cc);
        }
        return this;
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return this.expr.accept(visitor) && visitor.declared(this.var);
    }

    @Override
    public int exprSize() {
        return this.expr.exprSize();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GroupSpec)) {
            return false;
        }
        GroupSpec s = (GroupSpec)obj;
        return this.var.equals(s.var) && this.occluded == s.occluded && Objects.equals(this.coll, s.coll) && super.equals(obj);
    }

    @Override
    public void plan(FElem plan) {
        FElem elem = this.planElem(new Object[0]);
        this.var.plan(elem);
        this.expr.plan(elem);
        plan.add(elem);
    }

    @Override
    public String toString() {
        TokenBuilder tb = new TokenBuilder();
        tb.addExt(this.var, new Object[0]).add(32).add(":=").add(32).addExt(this.expr, new Object[0]);
        if (this.coll != null) {
            tb.add(32).add("collation").add(" \"").add(this.coll.uri()).add(34);
        }
        return tb.toString();
    }
}

