/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.ft;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ft.FTExpr;
import org.basex.query.expr.ft.FTFilter;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.util.ft.FTMatch;
import org.basex.query.util.ft.FTStringMatch;
import org.basex.query.value.node.FElem;
import org.basex.query.var.Var;
import org.basex.query.var.VarUsage;
import org.basex.util.InputInfo;
import org.basex.util.ft.FTLexer;
import org.basex.util.ft.FTUnit;
import org.basex.util.hash.IntObjMap;

public final class FTDistance
extends FTFilter {
    private Expr min;
    private Expr max;

    public FTDistance(InputInfo info, FTExpr expr, Expr min, Expr max, FTUnit unit) {
        super(info, expr, unit);
        this.min = min;
        this.max = max;
    }

    @Override
    public void checkUp() throws QueryException {
        this.checkNoneUp(this.min, this.max);
        super.checkUp();
    }

    @Override
    public FTExpr compile(CompileContext cc) throws QueryException {
        this.min = this.min.compile(cc);
        this.max = this.max.compile(cc);
        return super.compile(cc);
    }

    @Override
    protected boolean filter(QueryContext qc, FTMatch match, FTLexer lexer) throws QueryException {
        long mn = this.toLong(this.min, qc);
        long mx = this.toLong(this.max, qc);
        match.sort();
        FTMatch ftm = new FTMatch();
        FTStringMatch first = null;
        FTStringMatch last = null;
        for (FTStringMatch sm : match) {
            if (sm.exclude) {
                ftm.add(sm);
                continue;
            }
            if (first == null) {
                first = sm;
            } else {
                int d = this.pos(sm.start, lexer) - this.pos(last.end, lexer) - 1;
                if ((long)d < mn || (long)d > mx) {
                    return false;
                }
            }
            last = sm;
        }
        if (first == null) {
            return false;
        }
        first.end = last.end;
        match.reset();
        match.add(first);
        match.add(ftm);
        return true;
    }

    @Override
    public boolean has(Flag ... flags) {
        return this.min.has(flags) || this.max.has(flags) || super.has(flags);
    }

    @Override
    public boolean removable(Var var) {
        return this.min.removable(var) || this.max.removable(var) && super.removable(var);
    }

    @Override
    public VarUsage count(Var var) {
        return super.count(var).plus(VarUsage.sum(var, this.min, this.max));
    }

    @Override
    public FTExpr inline(Var var, Expr ex, CompileContext cc) throws QueryException {
        Expr mn = this.min.inline(var, ex, cc);
        Expr mx = this.max.inline(var, ex, cc);
        if (mn != null) {
            this.min = mn;
        }
        if (mx != null) {
            this.max = mx;
        }
        return FTDistance.inlineAll(this.exprs, var, ex, cc) || mn != null || mx != null ? this.optimize(cc) : null;
    }

    @Override
    public FTExpr copy(CompileContext cc, IntObjMap<Var> vm) {
        return new FTDistance(this.info, (FTExpr)this.exprs[0].copy(cc, (IntObjMap)vm), this.min.copy(cc, vm), this.max.copy(cc, vm), this.unit);
    }

    @Override
    public void plan(FElem plan) {
        FTDistance.addPlan(plan, this.planElem("distance", this.min + "-" + this.max + ' ' + (Object)((Object)this.unit)), this.exprs);
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + "distance" + "(" + this.min + '-' + this.max + ' ' + (Object)((Object)this.unit) + ")";
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return super.accept(visitor) && FTDistance.visitAll(visitor, this.min, this.max);
    }

    @Override
    public int exprSize() {
        int size = 1;
        FTExpr[] fTExprArray = this.exprs;
        int n = this.exprs.length;
        int n2 = 0;
        while (n2 < n) {
            FTExpr expr = fTExprArray[n2];
            size += expr.exprSize();
            ++n2;
        }
        return this.min.exprSize() + this.max.exprSize() + size;
    }
}

