/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.ft;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ft.FTExpr;
import org.basex.query.expr.ft.FTNot;
import org.basex.query.expr.ft.FTOr;
import org.basex.query.iter.FTIter;
import org.basex.query.util.IndexCosts;
import org.basex.query.util.IndexInfo;
import org.basex.query.util.ft.FTMatch;
import org.basex.query.util.ft.FTMatches;
import org.basex.query.value.node.FTNode;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.ft.Scoring;
import org.basex.util.hash.IntObjMap;

public final class FTAnd
extends FTExpr {
    public FTAnd(InputInfo info, FTExpr[] exprs) {
        super(info, exprs);
    }

    @Override
    public FTExpr compile(CompileContext cc) throws QueryException {
        super.compile(cc);
        boolean not = true;
        FTExpr[] fTExprArray = this.exprs;
        int n = this.exprs.length;
        int n2 = 0;
        while (n2 < n) {
            FTExpr expr = fTExprArray[n2];
            not &= expr instanceof FTNot;
            ++n2;
        }
        if (not) {
            int es = this.exprs.length;
            int e = 0;
            while (e < es) {
                this.exprs[e] = this.exprs[e].exprs[0];
                ++e;
            }
            return (FTExpr)cc.replaceWith(this, new FTNot(this.info, (FTExpr)new FTOr(this.info, this.exprs)));
        }
        return this;
    }

    @Override
    public FTNode item(QueryContext qc, InputInfo ii) throws QueryException {
        FTNode item = this.exprs[0].item(qc, this.info);
        int es = this.exprs.length;
        int e = 1;
        while (e < es) {
            FTAnd.and(item, this.exprs[e].item(qc, this.info));
            ++e;
        }
        return item;
    }

    @Override
    public FTIter iter(QueryContext qc) throws QueryException {
        int es = this.exprs.length;
        final FTIter[] iters = new FTIter[es];
        final FTNode[] nodes = new FTNode[es];
        int e = 0;
        while (e < es) {
            iters[e] = this.exprs[e].iter(qc);
            nodes[e] = iters[e].next();
            ++e;
        }
        return new FTIter(){

            @Override
            public FTNode next() throws QueryException {
                int il = nodes.length;
                int i = 0;
                while (i < il) {
                    if (nodes[i] == null) {
                        return null;
                    }
                    int d = nodes[0].pre() - nodes[i].pre();
                    if (d != 0) {
                        if (d < 0) {
                            i = 0;
                        }
                        nodes[i] = iters[i].next();
                        i = -1;
                    }
                    ++i;
                }
                FTNode item = nodes[0];
                int i2 = 1;
                while (i2 < il) {
                    FTAnd.and(item, nodes[i2]);
                    nodes[i2] = iters[i2].next();
                    ++i2;
                }
                nodes[0] = iters[0].next();
                return item;
            }
        };
    }

    private static void and(FTNode node1, FTNode node2) {
        FTMatches all = new FTMatches((byte)Math.max(node1.matches().pos, node2.matches().pos));
        for (FTMatch match1 : node1.matches()) {
            for (FTMatch match2 : node2.matches()) {
                all.add(new FTMatch(match1.size() + match2.size()).add(match1).add(match2));
            }
        }
        node1.score(Scoring.avg(node1.score() + node2.score(), 2));
        node1.matches(all);
    }

    @Override
    public boolean indexAccessible(IndexInfo ii) throws QueryException {
        IndexCosts costs = IndexCosts.ZERO;
        FTExpr[] fTExprArray = this.exprs;
        int n = this.exprs.length;
        int n2 = 0;
        while (n2 < n) {
            FTExpr expr = fTExprArray[n2];
            if (!expr.indexAccessible(ii)) {
                return false;
            }
            costs = IndexCosts.add(costs, ii.costs);
            ++n2;
        }
        ii.costs = costs;
        return true;
    }

    @Override
    public FTExpr copy(CompileContext cc, IntObjMap<Var> vm) {
        return new FTAnd(this.info, (FTExpr[])Arr.copyAll((CompileContext)cc, vm, (Expr[])this.exprs));
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof FTAnd && super.equals(obj);
    }

    @Override
    public String toString() {
        return "(" + this.toString(" ftand ") + ")";
    }
}

