/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.constr;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.expr.constr.CNode;
import org.basex.query.iter.BasicIter;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.var.Var;
import org.basex.query.var.VarUsage;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.XMLToken;

abstract class CName
extends CNode {
    private final String desc;
    Expr name;

    CName(String desc, StaticContext sc, InputInfo info, SeqType seqType, Expr name, Expr ... cont) {
        super(sc, info, seqType, cont);
        this.name = name;
        this.desc = desc;
    }

    @Override
    public final void checkUp() throws QueryException {
        this.checkNoUp(this.name);
        super.checkUp();
    }

    @Override
    public Expr compile(CompileContext cc) throws QueryException {
        this.name = this.name.compile(cc);
        return super.compile(cc);
    }

    final byte[] atomValue(QueryContext qc) throws QueryException {
        TokenBuilder tb = new TokenBuilder();
        Expr[] exprArray = this.exprs;
        int n = this.exprs.length;
        int n2 = 0;
        while (n2 < n) {
            Item item;
            Expr expr = exprArray[n2];
            Value value = expr.value(qc);
            boolean more = false;
            BasicIter<Item> iter = value.atomValue(qc, this.info).iter();
            while ((item = qc.next(iter)) != null) {
                if (more) {
                    tb.add(32);
                }
                tb.add(item.string(this.info));
                more = true;
            }
            ++n2;
        }
        return tb.finish();
    }

    final QNm qname(QueryContext qc, boolean elem) throws QueryException {
        Item item = this.checkNoEmpty(this.name.atomItem(qc, this.info), AtomType.QNM);
        Type type = item.type;
        if (type == AtomType.QNM) {
            return (QNm)item;
        }
        if (!type.isStringOrUntyped() || type == AtomType.URI) {
            throw QueryError.STRQNM_X_X.get(this.info, type, item);
        }
        byte[] str = item.string(this.info);
        if (XMLToken.isQName(str)) {
            return elem || Token.contains(str, 58) ? new QNm(str, this.sc) : new QNm(str);
        }
        throw QueryError.INVNAME_X.get(this.info, new Object[]{str});
    }

    @Override
    public boolean removable(Var var) {
        return this.name.removable(var) && super.removable(var);
    }

    @Override
    public final boolean has(Flag ... flags) {
        return this.name.has(flags) || super.has(flags);
    }

    @Override
    public final boolean accept(ASTVisitor visitor) {
        return this.name.accept(visitor) && CName.visitAll(visitor, this.exprs);
    }

    @Override
    public final VarUsage count(Var var) {
        return this.name.count(var).plus(super.count(var));
    }

    @Override
    public Expr inline(Var var, Expr ex, CompileContext cc) throws QueryException {
        boolean changed = CName.inlineAll(this.exprs, var, ex, cc);
        Expr sub = this.name.inline(var, ex, cc);
        if (sub != null) {
            this.name = sub;
            changed = true;
        }
        return changed ? this.optimize(cc) : null;
    }

    @Override
    public final int exprSize() {
        int size = 1;
        Expr[] exprArray = this.exprs;
        int n = this.exprs.length;
        int n2 = 0;
        while (n2 < n) {
            Expr expr = exprArray[n2];
            size += expr.exprSize();
            ++n2;
        }
        return size + this.name.exprSize();
    }

    @Override
    public final void plan(FElem plan) {
        CName.addPlan(plan, this.planElem(new Object[0]), new Object[]{this.name, this.exprs});
    }

    @Override
    public final String description() {
        return CName.info(this.desc);
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof CName && this.name.equals(((CName)obj).name) && super.equals(obj);
    }

    @Override
    public final String toString() {
        return this.toString(String.valueOf(this.desc) + (this.name.seqType().eq(SeqType.QNM_O) ? " " + this.name : " { " + this.name + " }"));
    }
}

