/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Single;
import org.basex.query.iter.Iter;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public final class Cast
extends Single {
    private final StaticContext sc;

    public Cast(StaticContext sc, InputInfo info, Expr expr, SeqType seqType) {
        super(info, expr, seqType);
        this.sc = sc;
    }

    @Override
    public Expr compile(CompileContext cc) throws QueryException {
        return super.compile(cc).optimize(cc);
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        SeqType st = this.expr.seqType();
        if (st.oneNoArray()) {
            this.exprType.assign(Occ.ONE);
        }
        if (this.expr instanceof Value) {
            return cc.preEval(this);
        }
        Type type = this.seqType().type;
        if ((type == AtomType.BLN || type == AtomType.FLT || type == AtomType.DBL || type == AtomType.QNM || type == AtomType.URI) && this.seqType().eq(this.expr.seqType())) {
            return cc.replaceWith(this, this.expr);
        }
        return this;
    }

    @Override
    public Iter iter(QueryContext qc) throws QueryException {
        return this.value(qc).iter();
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        Value value = this.expr.atomValue(qc, this.info);
        SeqType st = this.seqType();
        if (!st.occ.check(value.size())) {
            throw QueryError.INVTYPE_X_X_X.get(this.info, value.seqType(), st, value);
        }
        return value instanceof Item ? st.cast((Item)value, qc, this.sc, this.info, true) : value;
    }

    @Override
    public Cast copy(CompileContext cc, IntObjMap<Var> vs) {
        return this.copyType(new Cast(this.sc, this.info, this.expr.copy(cc, vs), this.seqType()));
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof Cast && this.seqType().eq(((Cast)obj).seqType()) && super.equals(obj);
    }

    @Override
    public void plan(FElem plan) {
        Cast.addPlan(plan, this.planElem("as", this.seqType()), this.expr);
    }

    @Override
    public String toString() {
        return this.expr + " " + "cast" + ' ' + "as" + ' ' + this.seqType();
    }
}

