/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query;

import java.io.Closeable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import org.basex.build.json.JsonOptions;
import org.basex.build.json.JsonParserOptions;
import org.basex.core.BaseXException;
import org.basex.core.Context;
import org.basex.core.MainOptions;
import org.basex.core.Text;
import org.basex.core.jobs.Job;
import org.basex.core.locks.LockList;
import org.basex.core.locks.Locks;
import org.basex.core.users.Perm;
import org.basex.data.Data;
import org.basex.io.parse.json.JsonConverter;
import org.basex.io.serial.SerializerOptions;
import org.basex.query.CompileContext;
import org.basex.query.QueryCompiler;
import org.basex.query.QueryDateTime;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryFocus;
import org.basex.query.QueryIOException;
import org.basex.query.QueryInfo;
import org.basex.query.QueryParser;
import org.basex.query.QueryProcessor;
import org.basex.query.QueryResources;
import org.basex.query.StaticContext;
import org.basex.query.func.JavaFunction;
import org.basex.query.func.StaticFuncs;
import org.basex.query.func.XQFunction;
import org.basex.query.iter.BasicIter;
import org.basex.query.iter.Iter;
import org.basex.query.scope.LibraryModule;
import org.basex.query.scope.MainModule;
import org.basex.query.scope.Module;
import org.basex.query.scope.StaticScope;
import org.basex.query.up.Updates;
import org.basex.query.util.Flag;
import org.basex.query.util.collation.Collation;
import org.basex.query.util.ft.FTPosData;
import org.basex.query.util.list.ItemList;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.node.FElem;
import org.basex.query.value.seq.DBNodes;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.ListType;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Type;
import org.basex.query.var.QueryStack;
import org.basex.query.var.Var;
import org.basex.query.var.VarScope;
import org.basex.query.var.Variables;
import org.basex.util.Prop;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.ft.FTLexer;
import org.basex.util.ft.FTOpt;
import org.basex.util.hash.TokenMap;
import org.basex.util.hash.TokenObjMap;
import org.basex.util.list.IntList;
import org.basex.util.list.StringList;
import org.basex.util.list.TokenList;
import org.basex.util.options.Option;

public final class QueryContext
extends Job
implements Closeable {
    public final QueryStack stack = new QueryStack();
    public final Variables vars = new Variables();
    public final StaticFuncs funcs = new StaticFuncs();
    private final HashMap<QNm, Value> bindings = new HashMap();
    public final QueryContext parent;
    public final QueryInfo info;
    public final Context context;
    public QueryResources resources;
    public Object http;
    public Updates updates;
    final HashMap<Option<?>, Object> staticOpts = new HashMap();
    final StringList tempOpts = new StringList();
    public QueryFocus focus = new QueryFocus();
    public QueryDateTime dateTime;
    public FTPosData ftPosData = Prop.gui ? new FTPosData() : null;
    public FTLexer ftLexer;
    private FTOpt ftOpt;
    public int ftPos;
    public boolean scoring;
    public TokenObjMap<Collation> collations;
    public final LockList readLocks = new LockList();
    public final LockList writeLocks = new LockList();
    public int tailCalls;
    public int maxCalls;
    private XQFunction tailFunc;
    private Value[] args;
    public int varIDs;
    public final TokenMap modParsed = new TokenMap();
    final TokenMap modDeclared = new TokenMap();
    final TokenList modStack = new TokenList();
    public MainModule ctxItem;
    public MainModule root;
    private SerializerOptions serParams;
    private boolean defaultOutput;
    private boolean compiled;
    private boolean closed;

    public QueryContext(QueryContext parent) {
        this(parent.context, parent, parent.info);
        parent.pushJob(this);
        this.resources = parent.resources;
        this.http = parent.http;
        this.updates = parent.updates;
    }

    public QueryContext(Context context) {
        this(context, null, null);
        this.resources = new QueryResources(this);
    }

    private QueryContext(Context context, QueryContext parent, QueryInfo info) {
        this.context = context;
        this.parent = parent;
        this.info = info != null ? info : new QueryInfo(this);
    }

    public Module parse(String query, String uri, StaticContext sc) throws QueryException {
        return this.parse(query, QueryProcessor.isLibrary(query), uri, sc);
    }

    public Module parse(String query, boolean library, String uri, StaticContext sc) throws QueryException {
        return library ? this.parseLibrary(query, uri, sc) : this.parseMain(query, uri, sc);
    }

    public MainModule parseMain(String query, String uri, StaticContext sc) throws QueryException {
        this.info.query = query;
        QueryParser qp = new QueryParser(query, uri, this, sc);
        this.root = qp.parseMain();
        if (this.updating) {
            this.updating = qp.sc.mixUpdates && qp.sc.dynFuncCall || this.root.expr.has(Flag.UPD);
        }
        return this.root;
    }

    public LibraryModule parseLibrary(String query, String uri, StaticContext sc) throws QueryException {
        this.info.query = query;
        try {
            LibraryModule libraryModule = new QueryParser(query, uri, this, sc).parseLibrary(true);
            return libraryModule;
        }
        finally {
            this.updating = false;
        }
    }

    public void mainModule(MainModule rt) {
        this.root = rt;
        this.updating = rt.expr.has(Flag.UPD);
    }

    public void compile() throws QueryException {
        this.checkStop();
        if (this.compiled) {
            return;
        }
        this.info.runtime = false;
        CompileContext cc = new CompileContext(this);
        try {
            StringList opts = this.tempOpts;
            int os = opts.size();
            int o = 0;
            while (o < os) {
                String key = (String)opts.get(o);
                String val = (String)opts.get(o + 1);
                try {
                    this.context.options.assign(key.toUpperCase(Locale.ENGLISH), val);
                }
                catch (BaseXException ex) {
                    Util.debug(ex);
                    throw QueryError.BASEX_OPTIONS_X_X.get(null, key, val);
                }
                o += 2;
            }
            this.maxCalls = this.context.options.get(MainOptions.TAILCALLS);
            this.vars.bindExternal(this, this.bindings);
            if (this.ctxItem != null) {
                try {
                    this.ctxItem.comp(cc);
                    this.focus.value = this.ctxItem.cache(this).value();
                }
                catch (QueryException ex) {
                    throw ex.error() == QueryError.NOCTX_X ? QueryError.CIRCCTX.get(this.ctxItem.info, new Object[0]) : ex;
                }
            } else {
                DBNodes nodes = this.context.current();
                if (nodes != null) {
                    String name = nodes.data().meta.name;
                    if (!this.context.perm(Perm.READ, name)) {
                        throw QueryError.BASEX_PERMISSION_X_X.get(null, new Object[]{Perm.READ, name});
                    }
                    this.focus.value = this.resources.compile(nodes);
                }
            }
            if (this.focus.value != null && this.root.sc.contextType != null) {
                this.focus.value = this.root.sc.contextType.promote(this.focus.value, null, this, this.root.sc, null, true);
            }
            try {
                if (this.root != null) {
                    QueryCompiler.compile(cc, this.root);
                } else {
                    this.funcs.compile(cc);
                }
            }
            catch (StackOverflowError ex) {
                Util.debug(ex);
                throw QueryError.BASEX_OVERFLOW.get(null, ex);
            }
        }
        finally {
            this.info.runtime = true;
            this.compiled = true;
        }
    }

    public Iter iter() throws QueryException {
        this.compile();
        try {
            if (!this.updating) {
                return this.root.iter(this);
            }
            ItemList items = this.root.cache(this);
            if (this.updates != null && this.parent == null) {
                ItemList items2 = this.updates.items;
                HashSet<Data> datas = this.updates.prepare(this);
                StringList dbs = this.updates.databases();
                this.check(items, datas, dbs);
                this.check(items2, datas, dbs);
                if (this.context.data() != null) {
                    this.context.invalidate();
                }
                this.updates.apply(this);
                if (!items2.isEmpty()) {
                    if (items.isEmpty()) {
                        items = items2;
                    } else {
                        for (Item item : items2) {
                            items.add(item);
                        }
                    }
                }
            }
            return items.iter();
        }
        catch (StackOverflowError ex) {
            Util.debug(ex);
            throw QueryError.BASEX_OVERFLOW.get(null, new Object[0]);
        }
    }

    private void check(ItemList items, HashSet<Data> datas, StringList dbs) throws QueryException {
        long is = items.size();
        int i = 0;
        while ((long)i < is) {
            Item item = (Item)items.get(i);
            if (item instanceof FItem) {
                throw QueryError.BASEX_FUNCTION_X.get(null, item);
            }
            Data data = item.data();
            if (data != null && (datas.contains(data) || !data.inMemory() && dbs.contains(data.meta.name))) {
                items.set(i, ((DBNode)item).dbNodeCopy(this.context.options, this));
            }
            ++i;
        }
    }

    public Item next(Iter iter) throws QueryException {
        this.checkStop();
        return iter.next();
    }

    public synchronized Updates updates() {
        if (this.updates == null) {
            this.updates = new Updates(false);
        }
        return this.updates;
    }

    @Override
    public void addLocks() {
        Locks locks = this.jc().locks;
        LockList read = locks.reads;
        LockList write = locks.writes;
        read.add(this.readLocks);
        write.add(this.writeLocks);
        if (this.root == null || !this.root.databases(locks, this) || this.ctxItem != null && !this.ctxItem.databases(locks, this)) {
            (this.updating ? write : read).addGlobal();
        }
    }

    public void http(Object value) {
        this.http = value;
    }

    public void context(Object value, String type, StaticContext sc) throws QueryException {
        this.context(this.cast(value, type), sc);
    }

    public void context(Value value, StaticContext sc) {
        this.ctxItem = MainModule.get(new VarScope(sc), value, null, null, null);
    }

    public void bind(String name, Object value, String type, StaticContext sc) throws QueryException {
        this.bind(name, this.cast(value, type), sc);
    }

    public void bind(String name, Value value, StaticContext sc) throws QueryException {
        byte[] nm = Token.token(name);
        this.bindings.put(QNm.resolve(Token.indexOf(nm, 36) == 0 ? Token.substring(nm, 1) : nm, sc), value);
    }

    public void evalInfo(String string) {
        QueryContext qc = this;
        while (qc.parent != null) {
            qc = qc.parent;
        }
        qc.info.evalInfo(string);
    }

    public String info() {
        return this.info.toString(this);
    }

    public SerializerOptions serParams() {
        if (this.serParams == null) {
            this.serParams = new SerializerOptions(this.context.options.get(MainOptions.SERIALIZER));
            this.defaultOutput = this.root != null;
        }
        return this.serParams;
    }

    public FTOpt ftOpt() {
        if (this.ftOpt == null) {
            this.ftOpt = new FTOpt();
        }
        return this.ftOpt;
    }

    public void ftOpt(FTOpt opt) {
        this.ftOpt = opt;
    }

    public FElem plan() {
        FElem elem = new FElem("QueryPlan");
        elem.add("compiled", Token.token(this.compiled));
        elem.add("updating", Token.token(this.updating));
        if (this.root != null) {
            for (StaticScope staticScope : QueryCompiler.usedDecls(this.root)) {
                staticScope.plan(elem);
            }
            this.root.plan(elem);
        } else {
            this.funcs.plan(elem);
            this.vars.plan(elem);
        }
        return elem;
    }

    public void updating() {
        this.updating = true;
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.parent == null) {
            this.resources.close();
        } else {
            this.parent.updates = this.updates;
            this.parent.popJob();
        }
        this.staticOpts.forEach(this.context.options::put);
    }

    @Override
    public String shortInfo() {
        return Text.SAVE;
    }

    Value cache(int max) throws QueryException {
        ItemList items;
        Item item;
        int mx = max >= 0 ? max : Integer.MAX_VALUE;
        Iter iter = this.iter();
        Data data = this.resources.globalData();
        if (this.defaultOutput && data != null) {
            IntList pres = new IntList();
            while ((item = this.next(iter)) != null && item.data() == data && pres.size() < mx) {
                pres.add(((DBNode)item).pre());
            }
            int ps = pres.size();
            if (item == null || ps == mx) {
                return ps == 0 ? Empty.SEQ : new DBNodes(data, pres.finish()).ftpos(this.ftPosData);
            }
            items = new ItemList();
            int p = 0;
            while (p < ps) {
                items.add(new DBNode(data, pres.get(p)));
                ++p;
            }
            items.add(item);
        } else {
            items = new ItemList();
        }
        while ((item = this.next(iter)) != null && items.size() < mx) {
            item.materialize(null);
            items.add(item);
        }
        return items.value();
    }

    private Value cast(Object value, String type) throws QueryException {
        Type tp;
        StaticContext sc = this.root != null ? this.root.sc : new StaticContext(this);
        E[] object = value;
        if (object instanceof String) {
            String string = (String)object;
            StringList strings = new StringList(1);
            if (string.indexOf(1) == -1) {
                strings.add(string);
            } else {
                strings.add(string.split("\u0001"));
                object = strings.toArray();
            }
            if (string.indexOf(2) != -1) {
                ValueBuilder vb = new ValueBuilder(this);
                for (String str : strings) {
                    int i = str.indexOf(2);
                    String val = i == -1 ? str : str.substring(0, i);
                    String tp2 = i == -1 ? type : str.substring(i + 1);
                    vb.add(this.cast(val, tp2));
                }
                return vb.value();
            }
        }
        if (type == null || type.isEmpty()) {
            return object instanceof Value ? (Value)object : JavaFunction.toValue(object, this, sc);
        }
        if (type.equalsIgnoreCase(MainOptions.MainParser.JSON.name())) {
            try {
                JsonParserOptions jp = new JsonParserOptions();
                jp.set(JsonOptions.FORMAT, JsonOptions.JsonFormat.XQUERY);
                return JsonConverter.get(jp).convert(Token.token(object.toString()), null);
            }
            catch (QueryIOException ex) {
                throw ex.getCause();
            }
        }
        if (type.equals("empty-sequence()")) {
            return Empty.SEQ;
        }
        QNm nm = new QNm(Token.token(type.replaceAll("\\(.*?\\)$", "")), sc);
        if (!nm.hasURI() && nm.hasPrefix()) {
            throw QueryError.NOURI_X.get(null, new Object[]{nm.string()});
        }
        if (type.endsWith(")")) {
            Type type2 = tp = nm.eq(AtomType.ITEM.name) ? AtomType.ITEM : NodeType.find(nm);
            if (tp == null) {
                tp = FuncType.find(nm);
            }
        } else {
            tp = ListType.find(nm);
            if (tp == null) {
                tp = AtomType.find(nm, false);
            }
        }
        if (tp == null) {
            throw QueryError.WHICHTYPE_X.get(null, type);
        }
        if (object instanceof Value) {
            Item item;
            if (object instanceof Item) {
                return tp.cast((Item)object, this, sc, null);
            }
            Value vl = (Value)object;
            ValueBuilder vb = new ValueBuilder(this);
            BasicIter<Item> iter = vl.iter();
            while ((item = iter.next()) != null) {
                vb.add(tp.cast(item, this, sc, null));
            }
            return vb.value();
        }
        if (object instanceof String[]) {
            ValueBuilder vb = new ValueBuilder(this);
            String[] stringArray = (String[])object;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                vb.add(tp.cast(string, this, sc, null));
                ++n2;
            }
            return vb.value();
        }
        return tp.cast(object, this, sc, null);
    }

    public Value get(Var var) {
        return this.stack.get(var);
    }

    public void set(Var var, Value val) throws QueryException {
        this.stack.set(var, val, this);
    }

    public void registerTailCall(XQFunction fn, Value[] arg) {
        this.tailFunc = fn;
        this.args = arg;
    }

    public XQFunction pollTailCall() {
        XQFunction fn = this.tailFunc;
        this.tailFunc = null;
        return fn;
    }

    public Value[] pollTailArgs() {
        Value[] as = this.args;
        this.args = null;
        return as;
    }

    public QueryDateTime dateTime() throws QueryException {
        if (this.dateTime == null) {
            this.dateTime = new QueryDateTime();
        }
        return this.dateTime;
    }

    public String toString() {
        return this.root != null ? QueryInfo.usedDecls(this.root) : this.info.query;
    }
}

