/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.serial.json;

import java.io.IOException;
import java.io.OutputStream;
import org.basex.io.serial.SerializerOptions;
import org.basex.io.serial.json.JsonSerializer;
import org.basex.query.QueryError;
import org.basex.query.util.ft.FTPos;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;

public final class JsonMLSerializer
extends JsonSerializer {
    private boolean att;

    public JsonMLSerializer(OutputStream os, SerializerOptions opts) throws IOException {
        super(os, opts);
    }

    @Override
    protected void startOpen(QNm name) throws IOException {
        if (this.level != 0) {
            this.out.print(44);
            this.indent();
        }
        this.out.print("[\"");
        byte[] byArray = name.local();
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            byte ch = byArray[n2];
            this.printChar(ch);
            ++n2;
        }
        this.out.print(34);
        this.att = false;
    }

    @Override
    protected void attribute(byte[] name, byte[] value, boolean standalone) throws IOException {
        byte ch;
        this.out.print(",");
        this.out.print(32);
        if (!this.att) {
            this.out.print("{");
            this.att = true;
        }
        this.out.print(34);
        byte[] byArray = name;
        int n = name.length;
        int n2 = 0;
        while (n2 < n) {
            ch = byArray[n2];
            this.printChar(ch);
            ++n2;
        }
        this.out.print("\":\"");
        byArray = this.norm(value);
        n = byArray.length;
        n2 = 0;
        while (n2 < n) {
            ch = byArray[n2];
            this.printChar(ch);
            ++n2;
        }
        this.out.print("\"");
    }

    @Override
    protected void finishOpen() throws IOException {
        if (this.att) {
            this.out.print("}");
        }
    }

    @Override
    protected void text(byte[] value, FTPos ftp) throws IOException {
        this.out.print(44);
        this.indent();
        this.out.print(34);
        byte[] byArray = value;
        int n = value.length;
        int n2 = 0;
        while (n2 < n) {
            byte ch = byArray[n2];
            this.printChar(ch);
            ++n2;
        }
        this.out.print(34);
    }

    @Override
    protected void finishEmpty() throws IOException {
        this.finishOpen();
        this.out.print(93);
    }

    @Override
    protected void finishClose() throws IOException {
        this.out.print(93);
    }

    @Override
    protected void atomic(Item value) throws IOException {
        throw QueryError.JSON_SERIALIZE_X.getIO("Atomic values cannot be serialized");
    }
}

