/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.serial;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.basex.data.DataText;
import org.basex.io.serial.HTMLSerializer;
import org.basex.io.serial.SerializerOptions;
import org.basex.io.serial.StandardSerializer;
import org.basex.io.serial.XHTMLSerializer;
import org.basex.io.serial.XMLSerializer;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryIOException;
import org.basex.query.util.ft.FTPos;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.ANode;
import org.basex.query.value.type.NodeType;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.ft.FTLexer;
import org.basex.util.ft.FTSpan;
import org.basex.util.http.MediaType;
import org.basex.util.options.Options;
import org.basex.util.options.StringOption;

abstract class MarkupSerializer
extends StandardSerializer {
    String docsys;
    String docpub;
    int ct;
    boolean script;
    final boolean html5;
    final boolean escuri;
    final boolean saomit;
    final boolean content;
    private final boolean undecl;
    private final String media;
    private ArrayList<QNm> cdata;
    private ArrayList<QNm> suppress;

    protected MarkupSerializer(OutputStream os, SerializerOptions sopts, String ... versions) throws IOException {
        super(os, sopts);
        boolean xml;
        String ver = MarkupSerializer.supported(SerializerOptions.VERSION, sopts, versions);
        String htmlver = MarkupSerializer.supported(SerializerOptions.HTML_VERSION, sopts, "4.0", "4.01", "5.0");
        this.html5 = htmlver.equals("5.0") || ver.equals("5.0");
        boolean omitDecl = sopts.yes(SerializerOptions.OMIT_XML_DECLARATION);
        Options.YesNoOmit sa = sopts.get(SerializerOptions.STANDALONE);
        this.saomit = sa == Options.YesNoOmit.OMIT;
        this.docsys = sopts.get(SerializerOptions.DOCTYPE_SYSTEM);
        this.docpub = sopts.get(SerializerOptions.DOCTYPE_PUBLIC);
        this.media = sopts.get(SerializerOptions.MEDIA_TYPE);
        this.escuri = sopts.yes(SerializerOptions.ESCAPE_URI_ATTRIBUTES);
        this.content = sopts.yes(SerializerOptions.INCLUDE_CONTENT_TYPE);
        this.undecl = sopts.yes(SerializerOptions.UNDECLARE_PREFIXES);
        if (this.docsys.isEmpty()) {
            this.docsys = null;
        }
        if (this.docpub.isEmpty()) {
            this.docpub = null;
        }
        boolean html = this instanceof HTMLSerializer;
        boolean bl = xml = this instanceof XMLSerializer || this instanceof XHTMLSerializer;
        if (xml || html) {
            if (this.undecl && ver.equals("1.0")) {
                throw QueryError.SERUNDECL.getIO(new Object[0]);
            }
            if (xml) {
                if (omitDecl) {
                    if (!this.saomit || !ver.equals("1.0") && this.docsys != null) {
                        throw QueryError.SERSTAND.getIO(new Object[0]);
                    }
                } else {
                    this.out.print(DataText.PI_O);
                    this.out.print("xml version=\"");
                    this.out.print(ver);
                    this.out.print("\" encoding=\"");
                    this.out.print(sopts.get(SerializerOptions.ENCODING));
                    if (!this.saomit) {
                        this.out.print("\" standalone=\"");
                        this.out.print(sa.toString());
                    }
                    this.out.print(DataText.ATT2);
                    this.out.print(DataText.PI_C);
                    this.out.print(10);
                }
            }
        }
    }

    @Override
    protected void namespace(byte[] prefix, byte[] uri, boolean standalone) throws IOException {
        if (this.undecl || prefix.length == 0 || uri.length != 0) {
            super.namespace(prefix, uri, standalone);
        }
    }

    @Override
    protected void attribute(byte[] name, byte[] value, boolean standalone) throws IOException {
        if (!standalone) {
            this.out.print(32);
        }
        this.out.print(name);
        this.out.print(DataText.ATT1);
        byte[] val = this.norm(value);
        int vl = val.length;
        int k = 0;
        while (k < vl) {
            int cp = Token.cp(val, k);
            if (cp == 34) {
                this.out.print(DataText.E_QUOT);
            } else if (cp == 9 || cp == 10) {
                this.printHex(cp);
            } else {
                this.printChar(cp);
            }
            k += Token.cl(val, k);
        }
        this.out.print(DataText.ATT2);
    }

    @Override
    protected void text(byte[] value, FTPos ftp) throws IOException {
        byte[] val = this.norm(value);
        if (ftp == null) {
            ArrayList<QNm> qnames = this.cdata();
            int vl = val.length;
            if (qnames.isEmpty() || this.elems.isEmpty() || !qnames.contains(this.elems.peek())) {
                int k = 0;
                while (k < vl) {
                    this.printChar(Token.cp(val, k));
                    k += Token.cl(val, k);
                }
            } else {
                this.out.print(DataText.CDATA_O);
                int c = 0;
                int k = 0;
                while (k < vl) {
                    int cp = Token.cp(val, k);
                    if (cp == 93) {
                        ++c;
                    } else {
                        if (c > 1 && cp == 62) {
                            this.out.print(DataText.CDATA_C);
                            this.out.print(DataText.CDATA_O);
                        }
                        c = 0;
                    }
                    this.out.print(cp);
                    k += Token.cl(val, k);
                }
                this.out.print(DataText.CDATA_C);
            }
        } else {
            FTLexer lexer = new FTLexer().original().init(val);
            while (lexer.hasNext()) {
                FTSpan span = lexer.next();
                if (!span.del && ftp.contains(span.pos)) {
                    this.out.print(63740);
                }
                byte[] text = span.text;
                int tl = text.length;
                int t = 0;
                while (t < tl) {
                    this.printChar(Token.cp(text, t));
                    t += Token.cl(text, t);
                }
            }
        }
        this.sep = false;
    }

    @Override
    protected void comment(byte[] value) throws IOException {
        if (this.sep) {
            this.indent();
        }
        this.out.print(DataText.COMM_O);
        this.out.print(value);
        this.out.print(DataText.COMM_C);
        this.sep = true;
    }

    @Override
    protected void pi(byte[] name, byte[] value) throws IOException {
        if (this.sep) {
            this.indent();
        }
        this.out.print(DataText.PI_O);
        this.out.print(name);
        this.out.print(32);
        this.out.print(value);
        this.out.print(DataText.PI_C);
        this.sep = true;
    }

    @Override
    protected void openDoc(byte[] name) {
        this.sep = false;
    }

    @Override
    protected void startOpen(QNm name) throws IOException {
        this.doctype(name);
        if (this.sep) {
            this.indent();
        }
        this.out.print(DataText.ELEM_O);
        this.out.print(name.string());
        this.sep = true;
    }

    @Override
    protected void finishOpen() throws IOException {
        this.out.print(DataText.ELEM_C);
    }

    @Override
    protected void finishEmpty() throws IOException {
        this.out.print(DataText.ELEM_SC);
    }

    @Override
    protected void finishClose() throws IOException {
        if (this.sep) {
            this.indent();
        }
        this.out.print(DataText.ELEM_OS);
        this.out.print(this.elem.string());
        this.out.print(DataText.ELEM_C);
        this.sep = true;
    }

    @Override
    protected void printChar(int cp) throws IOException {
        byte[] value;
        if (this.map != null && (value = (byte[])this.map.get(cp)) != null) {
            this.out.print(value);
            return;
        }
        if (cp < 32 && cp != 10 && cp != 9 || cp >= 127 && cp < 160) {
            this.printHex(cp);
        } else if (cp == 38) {
            this.out.print(DataText.E_AMP);
        } else if (cp == 62) {
            this.out.print(DataText.E_GT);
        } else if (cp == 60) {
            this.out.print(DataText.E_LT);
        } else if (cp == 8232) {
            this.out.print(DataText.E_2028);
        } else {
            try {
                this.out.print(cp);
            }
            catch (QueryIOException ex) {
                if (ex.getCause().error() == QueryError.SERENC_X_X) {
                    this.printHex(cp);
                }
                throw ex;
            }
        }
    }

    protected abstract void doctype(QNm var1) throws IOException;

    @Override
    protected boolean ignore(ANode node) {
        byte[] value;
        return this.ct > 0 && node.type == NodeType.ELM && Token.eq(node.name(), DataText.META) && (value = node.attribute(DataText.HTTPEQUIV)) != null && Token.eq(Token.trim(value), DataText.CONTENT_TYPE);
    }

    protected final void printDoctype(QNm type, String pub, String sys) throws IOException {
        if (this.level != 0) {
            return;
        }
        if (this.sep) {
            this.indent();
        }
        this.out.print("<!DOCTYPE ");
        this.out.print(type == null ? DataText.HTML : type.string());
        if (sys != null || pub != null) {
            if (pub != null) {
                this.out.print(" PUBLIC \"" + pub + '\"');
            } else {
                this.out.print(" SYSTEM");
            }
            if (sys != null) {
                this.out.print(" \"" + sys + '\"');
            }
        }
        this.out.print(DataText.ELEM_C);
        this.sep = true;
    }

    @Override
    protected void indent() throws IOException {
        if (this.atomic) {
            this.atomic = false;
        } else if (this.indent) {
            ArrayList<QNm> qnames = this.suppress();
            if (!qnames.isEmpty()) {
                for (QNm qname : this.elems) {
                    if (!qnames.contains(qname)) continue;
                    return;
                }
            }
            super.indent();
        }
    }

    protected final boolean printCT(boolean empty, boolean html) throws IOException {
        if (this.ct != 1) {
            return false;
        }
        ++this.ct;
        if (empty) {
            this.finishOpen();
        }
        ++this.level;
        this.startOpen(new QNm(DataText.META));
        this.attribute(DataText.HTTPEQUIV, DataText.CONTENT_TYPE, false);
        this.attribute(DataText.CONTENT, new TokenBuilder(this.media.isEmpty() ? MediaType.TEXT_HTML.toString() : this.media).add("; ").add(DataText.CHARSET).add(61).add(this.encoding).finish(), false);
        if (html) {
            this.out.print(DataText.ELEM_C);
        } else {
            this.out.print(32);
            this.out.print(DataText.ELEM_SC);
        }
        --this.level;
        if (empty) {
            this.finishClose();
        }
        return true;
    }

    private static String supported(StringOption option, Options opts, String ... allowed) throws QueryIOException {
        String string = opts.get(option);
        if (string.isEmpty()) {
            return allowed.length > 0 ? allowed[0] : string;
        }
        String[] stringArray = allowed;
        int n = allowed.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            if (value.equals(string)) {
                return string;
            }
            ++n2;
        }
        throw QueryError.SERNOTSUPP_X.getIO(Options.allowed(option, string, allowed));
    }

    private ArrayList<QNm> cdata() throws QueryIOException {
        ArrayList<QNm> list = this.cdata;
        if (list == null) {
            list = new ArrayList();
            boolean html = this instanceof HTMLSerializer;
            String cdse = this.sopts.get(SerializerOptions.CDATA_SECTION_ELEMENTS);
            byte[][] byArray = Token.split(Token.normalize(Token.token(cdse)), 32);
            int n = byArray.length;
            int n2 = 0;
            while (n2 < n) {
                byte[] name = byArray[n2];
                if (name.length != 0) {
                    QNm qnm = this.resolve(name);
                    if (!html || Token.contains(name, 58) && (!this.html5 || !Token.string(name).contains("html:"))) {
                        list.add(qnm);
                    }
                }
                ++n2;
            }
            this.cdata = list;
        }
        return list;
    }

    private ArrayList<QNm> suppress() throws QueryIOException {
        ArrayList<QNm> list = this.suppress;
        if (list == null) {
            list = new ArrayList();
            String supp = this.sopts.get(SerializerOptions.SUPPRESS_INDENTATION);
            byte[][] byArray = Token.split(Token.normalize(Token.token(supp)), 32);
            int n = byArray.length;
            int n2 = 0;
            while (n2 < n) {
                byte[] name = byArray[n2];
                if (name.length != 0) {
                    list.add(this.resolve(name));
                }
                ++n2;
            }
            this.suppress = list;
        }
        return list;
    }

    private QNm resolve(byte[] name) throws QueryIOException {
        try {
            return QNm.resolve(name, this.sc == null ? null : this.sc.elemNS, this.sc, null);
        }
        catch (QueryException ex) {
            throw new QueryIOException(ex);
        }
    }
}

