/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.serial;

import java.io.IOException;
import java.io.OutputStream;
import org.basex.data.DataText;
import org.basex.io.serial.MarkupSerializer;
import org.basex.io.serial.SerializerOptions;
import org.basex.query.QueryError;
import org.basex.query.value.item.QNm;
import org.basex.util.Token;
import org.basex.util.hash.TokenSet;
import org.basex.util.list.TokenList;

final class HTMLSerializer
extends MarkupSerializer {
    static final TokenList EMPTIES = new TokenList();
    static final TokenList EMPTIES5 = new TokenList();
    static final TokenSet URIS = new TokenSet();
    private static final TokenList SCRIPTS = new TokenList();
    private static final TokenSet BOOLEAN = new TokenSet();

    static {
        SCRIPTS.add("script");
        SCRIPTS.add("style");
        BOOLEAN.add("area@nohref");
        BOOLEAN.add("audio@autoplay");
        BOOLEAN.add("audio@controls");
        BOOLEAN.add("audio@loop");
        BOOLEAN.add("audio@muted");
        BOOLEAN.add("button@disabled");
        BOOLEAN.add("button@autofocus");
        BOOLEAN.add("button@formnovalidate");
        BOOLEAN.add("details@open");
        BOOLEAN.add("dialog@open");
        BOOLEAN.add("dir@compact");
        BOOLEAN.add("dl@compact");
        BOOLEAN.add("fieldset@disabled");
        BOOLEAN.add("form@novalidate");
        BOOLEAN.add("frame@noresize");
        BOOLEAN.add("hr@noshade");
        BOOLEAN.add("img@ismap");
        BOOLEAN.add("input@checked");
        BOOLEAN.add("input@disabled");
        BOOLEAN.add("input@multiple");
        BOOLEAN.add("input@readonly");
        BOOLEAN.add("input@required");
        BOOLEAN.add("input@autofocus");
        BOOLEAN.add("input@formnovalidate");
        BOOLEAN.add("iframe@seamless");
        BOOLEAN.add("keygen@autofocus");
        BOOLEAN.add("keygen@disabled");
        BOOLEAN.add("menu@compact");
        BOOLEAN.add("object@declare");
        BOOLEAN.add("object@typemustmatch");
        BOOLEAN.add("ol@compact");
        BOOLEAN.add("ol@reversed");
        BOOLEAN.add("optgroup@disabled");
        BOOLEAN.add("option@selected");
        BOOLEAN.add("option@disabled");
        BOOLEAN.add("script@defer");
        BOOLEAN.add("script@async");
        BOOLEAN.add("select@multiple");
        BOOLEAN.add("select@disabled");
        BOOLEAN.add("select@autofocus");
        BOOLEAN.add("select@required");
        BOOLEAN.add("style@scoped");
        BOOLEAN.add("td@nowrap");
        BOOLEAN.add("textarea@disabled");
        BOOLEAN.add("textarea@readonly");
        BOOLEAN.add("textarea@autofocus");
        BOOLEAN.add("textarea@required");
        BOOLEAN.add("th@nowrap");
        BOOLEAN.add("track@default");
        BOOLEAN.add("ul@compact");
        BOOLEAN.add("video@autoplay");
        BOOLEAN.add("video@controls");
        BOOLEAN.add("video@loop");
        BOOLEAN.add("video@muted");
        EMPTIES.add("area");
        EMPTIES.add("base");
        EMPTIES.add("basefont");
        EMPTIES.add("br");
        EMPTIES.add("col");
        EMPTIES.add("embed");
        EMPTIES.add("frame");
        EMPTIES.add("hr");
        EMPTIES.add("img");
        EMPTIES.add("input");
        EMPTIES.add("isindex");
        EMPTIES.add("link");
        EMPTIES.add("meta");
        EMPTIES.add("param");
        EMPTIES5.add("area");
        EMPTIES5.add("base");
        EMPTIES5.add("br");
        EMPTIES5.add("col");
        EMPTIES5.add("command");
        EMPTIES5.add("embed");
        EMPTIES5.add("hr");
        EMPTIES5.add("img");
        EMPTIES5.add("input");
        EMPTIES5.add("keygen");
        EMPTIES5.add("link");
        EMPTIES5.add("meta");
        EMPTIES5.add("param");
        EMPTIES5.add("source");
        EMPTIES5.add("track");
        EMPTIES5.add("wbr");
        URIS.add("a@href");
        URIS.add("a@name");
        URIS.add("applet@codebase");
        URIS.add("area@href");
        URIS.add("base@href");
        URIS.add("blockquote@cite");
        URIS.add("body@background");
        URIS.add("button@datasrc");
        URIS.add("del@cite");
        URIS.add("div@datasrc");
        URIS.add("form@action");
        URIS.add("frame@longdesc");
        URIS.add("frame@src");
        URIS.add("head@profile");
        URIS.add("iframe@longdesc");
        URIS.add("iframe@src");
        URIS.add("img@longdesc");
        URIS.add("img@src");
        URIS.add("img@usemap");
        URIS.add("input@datasrc");
        URIS.add("input@src");
        URIS.add("input@usemap");
        URIS.add("ins@cite");
        URIS.add("link@href");
        URIS.add("object@archive");
        URIS.add("object@classid");
        URIS.add("object@codebase");
        URIS.add("object@data");
        URIS.add("object@datasrc");
        URIS.add("object@usemap");
        URIS.add("q@cite");
        URIS.add("script@for");
        URIS.add("script@src");
        URIS.add("select@datasrc");
        URIS.add("span@datasrc");
        URIS.add("table@datasrc");
        URIS.add("textarea@datasrc");
    }

    HTMLSerializer(OutputStream os, SerializerOptions sopts) throws IOException {
        super(os, sopts, "4.0", "4.01", "5.0");
    }

    @Override
    protected void attribute(byte[] name, byte[] value, boolean standalone) throws IOException {
        if (!standalone) {
            this.out.print(32);
        }
        this.out.print(name);
        byte[] val = value;
        if (!BOOLEAN.isEmpty() || !URIS.isEmpty()) {
            byte[] nm = Token.concat(Token.lc(this.elem.string()), DataText.ATT, Token.lc(name));
            if (BOOLEAN.contains(nm) && Token.eq(name, val)) {
                return;
            }
            if (this.escuri && URIS.contains(nm)) {
                val = Token.escape(val);
            }
        }
        this.out.print(DataText.ATT1);
        int vl = val.length;
        int v = 0;
        while (v < vl) {
            int ch = Token.cp(val, v);
            if (ch == 60 || ch == 38 && val[Math.min(v + 1, vl - 1)] == 123) {
                this.out.print(ch);
            } else if (ch == 34) {
                this.out.print(DataText.E_QUOT);
            } else if (ch == 9 || ch == 10) {
                this.printHex(ch);
            } else {
                this.printChar(ch);
            }
            v += Token.cl(val, v);
        }
        this.out.print(DataText.ATT2);
    }

    @Override
    protected void comment(byte[] value) throws IOException {
        if (this.sep) {
            this.indent();
        }
        this.out.print(DataText.COMM_O);
        this.out.print(value);
        this.out.print(DataText.COMM_C);
    }

    @Override
    protected void pi(byte[] name, byte[] value) throws IOException {
        if (this.sep) {
            this.indent();
        }
        if (Token.contains(value, 62)) {
            throw QueryError.SERPI.getIO(new Object[0]);
        }
        this.out.print(DataText.PI_O);
        this.out.print(name);
        this.out.print(32);
        this.out.print(value);
        this.out.print(DataText.ELEM_C);
    }

    @Override
    protected void printChar(int cp) throws IOException {
        if (this.script) {
            this.out.print(cp);
        } else {
            if (cp > 127 && cp < 160 && !this.html5) {
                throw QueryError.SERILL_X.getIO(Integer.toHexString(cp));
            }
            if (cp == 160) {
                this.out.print(DataText.E_NBSP);
            } else {
                super.printChar(cp);
            }
        }
    }

    @Override
    protected void startOpen(QNm name) throws IOException {
        this.doctype(null);
        if (this.sep) {
            this.indent();
        }
        this.out.print(DataText.ELEM_O);
        this.out.print(name.string());
        this.sep = this.indent;
        this.script = SCRIPTS.contains(Token.lc(name.local()));
        if (this.content && Token.eq(Token.lc(this.elem.local()), DataText.HEAD)) {
            ++this.ct;
        }
    }

    @Override
    protected void finishOpen() throws IOException {
        super.finishOpen();
        this.printCT(false, true);
    }

    @Override
    protected void finishEmpty() throws IOException {
        byte[] uri;
        if (this.printCT(true, true)) {
            return;
        }
        this.out.print(DataText.ELEM_C);
        byte[] lc = Token.lc(this.elem.local());
        if (this.html5 ? EMPTIES5.contains(lc) : EMPTIES.contains(lc) && ((uri = this.nsUri(Token.EMPTY)) == null || uri.length == 0)) {
            return;
        }
        this.sep = false;
        this.finishClose();
    }

    @Override
    protected void finishClose() throws IOException {
        super.finishClose();
        this.script = this.script && !SCRIPTS.contains(Token.lc(this.elem.local()));
    }

    @Override
    protected void doctype(QNm type) throws IOException {
        boolean doc;
        boolean bl = doc = this.docpub != null || this.docsys != null;
        if (doc) {
            this.printDoctype(type, this.docpub, this.docsys);
        } else if (this.html5) {
            this.printDoctype(type, null, null);
        }
    }
}

