/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.parse.csv;

import java.io.IOException;
import org.basex.build.csv.CsvOptions;
import org.basex.build.csv.CsvParserOptions;
import org.basex.io.in.TextInput;
import org.basex.io.parse.csv.CsvConverter;
import org.basex.util.TokenBuilder;
import org.basex.util.XMLToken;

final class CsvParser {
    private final TextInput input;
    private final CsvConverter conv;
    private final boolean header;
    private final boolean backslashes;
    private final int separator;
    private final boolean quotes;
    private boolean first = true;
    private boolean data;

    private CsvParser(TextInput input, CsvParserOptions opts, CsvConverter conv) {
        this.input = input;
        this.conv = conv;
        this.header = opts.get(CsvOptions.HEADER);
        this.separator = opts.separator();
        this.quotes = opts.get(CsvOptions.QUOTES);
        this.backslashes = opts.get(CsvOptions.BACKSLASHES);
    }

    static void parse(TextInput input, CsvParserOptions opts, CsvConverter conv) throws IOException {
        new CsvParser(input, opts, conv).parse();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void parse() throws IOException {
        TokenBuilder entry = new TokenBuilder();
        boolean quoted = false;
        this.data = !this.header;
        int ch = this.input.read();
        while (ch != -1) {
            block16: {
                if (quoted) {
                    if (ch == 34) {
                        ch = this.input.read();
                        if (ch != 34) {
                            quoted = false;
                            continue;
                        }
                        if (this.backslashes) {
                            CsvParser.add(entry, 34);
                        }
                    } else if (ch == 92 && this.backslashes) {
                        ch = this.bs();
                    }
                    CsvParser.add(entry, ch);
                } else {
                    if (ch == 34) {
                        if (this.quotes && entry.isEmpty()) {
                            quoted = true;
                            break block16;
                        } else {
                            ch = this.input.read();
                            if (ch == 34 && !this.backslashes) continue;
                            CsvParser.add(entry, 34);
                            continue;
                        }
                    }
                    if (ch == this.separator) {
                        this.record(entry, true);
                        this.first = false;
                    } else if (ch == 10) {
                        this.record(entry, !entry.isEmpty());
                        this.first = true;
                        this.data = true;
                    } else {
                        if (ch == 92 && this.backslashes) {
                            ch = this.bs();
                        }
                        CsvParser.add(entry, ch);
                    }
                }
            }
            ch = this.input.read();
        }
        this.record(entry, !entry.isEmpty());
    }

    private int bs() throws IOException {
        int ch = this.input.read();
        if (ch == 114) {
            return 13;
        }
        if (ch == 110) {
            return 10;
        }
        if (ch == 116) {
            return 9;
        }
        return ch;
    }

    private static void add(TokenBuilder entry, int ch) {
        if (ch != -1) {
            entry.add(XMLToken.valid(ch) ? ch : 65533);
        }
    }

    private void record(TokenBuilder entry, boolean record) throws IOException {
        if (record && this.first && this.data) {
            this.conv.record();
        }
        if (record || !this.first) {
            if (this.data) {
                this.conv.entry(entry.next());
            } else {
                this.conv.header(entry.next());
            }
        }
    }
}

