/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.parse.csv;

import java.io.IOException;
import org.basex.build.csv.CsvOptions;
import org.basex.build.csv.CsvParserOptions;
import org.basex.core.jobs.Job;
import org.basex.io.IO;
import org.basex.io.in.NewlineInput;
import org.basex.io.parse.csv.CsvDirectConverter;
import org.basex.io.parse.csv.CsvParser;
import org.basex.io.parse.csv.CsvXQueryConverter;
import org.basex.query.value.item.Item;
import org.basex.util.Token;
import org.basex.util.list.TokenList;

public abstract class CsvConverter
extends Job {
    public static final byte[] CSV = Token.token("csv");
    public static final byte[] RECORD = Token.token("record");
    public static final byte[] ENTRY = Token.token("entry");
    public static final byte[] NAME = Token.token("name");
    protected final TokenList headers = new TokenList(1);
    protected final boolean ats;
    protected final boolean lax;
    protected int col;
    private final CsvParserOptions copts;
    protected NewlineInput nli;

    protected CsvConverter(CsvParserOptions copts) {
        this.copts = copts;
        this.lax = copts.get(CsvOptions.LAX);
        this.ats = copts.get(CsvOptions.FORMAT) == CsvOptions.CsvFormat.ATTRIBUTES;
    }

    public final Item convert(IO input) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (NewlineInput in = new NewlineInput(input);){
            this.nli = in;
            CsvParser.parse(in.encoding(this.copts.get(CsvParserOptions.ENCODING)), this.copts, this);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return this.finish();
    }

    public static CsvConverter get(CsvParserOptions copts) {
        switch (copts.get(CsvOptions.FORMAT)) {
            case XQUERY: {
                return new CsvXQueryConverter(copts);
            }
        }
        return new CsvDirectConverter(copts);
    }

    protected abstract void header(byte[] var1);

    protected abstract void record() throws IOException;

    protected abstract void entry(byte[] var1) throws IOException;

    protected abstract Item finish() throws IOException;
}

