/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.in;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.basex.io.in.TarEntry;
import org.basex.util.Util;
import org.basex.util.list.ByteList;

public final class TarInputStream
extends FilterInputStream {
    private static final int BLOCK = 512;
    private final byte[] buf = new byte[1];
    private TarEntry entry;
    private long offset;

    public TarInputStream(InputStream is) {
        super(is);
    }

    @Override
    public int read() throws IOException {
        int res = this.read(this.buf, 0, 1);
        return res == -1 ? -1 : this.buf[0] & 0xFF;
    }

    @Override
    public int read(byte[] bytes, int off, int len) throws IOException {
        if (this.entry == null) {
            return super.read(bytes, off, len);
        }
        long remain = this.entry.getSize() - this.offset;
        if (remain == 0L) {
            return -1;
        }
        int read = super.read(bytes, off, remain < (long)len ? (int)remain : len);
        if (read != -1) {
            this.offset += (long)read;
        }
        return read;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public synchronized void mark(int limit) {
        throw Util.notExpected();
    }

    @Override
    public synchronized void reset() {
        throw Util.notExpected();
    }

    public TarEntry getNextEntry() throws IOException {
        if (this.entry != null) {
            long skip = (this.entry.getSize() + 512L - 1L) / 512L * 512L - this.offset;
            this.offset = 0L;
            this.entry = null;
            while (skip > 0L) {
                skip -= this.skip(skip);
            }
        }
        byte[] header = new byte[512];
        int read = 0;
        while (read < 512) {
            int res = this.read(header, read, 512 - read);
            if (res < 0) break;
            read += res;
        }
        if (TarInputStream.eof(header)) {
            return null;
        }
        this.entry = new TarEntry(header);
        if (this.entry.isLongName()) {
            String name = this.longName();
            this.entry = this.getNextEntry();
            this.entry.setName(name);
        }
        return this.entry;
    }

    private static boolean eof(byte[] header) {
        byte[] byArray = header;
        int n = header.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            if (b != 0) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private String longName() throws IOException {
        int b;
        ByteList result = new ByteList();
        while ((b = this.read()) != -1) {
            result.add(b);
        }
        int size = result.size() - 1;
        if (size >= 0 && result.get(size) == 0) {
            result.size(size);
        }
        return TarEntry.name(result);
    }
}

