/*
 * Decompiled with CFR 0.152.
 */
package org.basex.index.ft;

import java.io.IOException;
import org.basex.core.BaseXException;
import org.basex.core.Text;
import org.basex.data.Data;
import org.basex.data.MetaData;
import org.basex.index.IndexBuilder;
import org.basex.index.IndexType;
import org.basex.index.ft.FTIndex;
import org.basex.index.ft.FTIndexTree;
import org.basex.index.ft.FTIndexTrees;
import org.basex.index.ft.FTList;
import org.basex.io.out.DataOutput;
import org.basex.util.Num;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.ft.FTCase;
import org.basex.util.ft.FTFlag;
import org.basex.util.ft.FTLexer;
import org.basex.util.ft.FTOpt;
import org.basex.util.ft.Stemmer;
import org.basex.util.ft.StopWords;
import org.basex.util.ft.Tokenizer;
import org.basex.util.list.IntList;

public final class FTBuilder
extends IndexBuilder {
    private final FTIndexTrees tree;
    private final FTLexer lexer;
    private long ntok;

    public FTBuilder(Data data) throws IOException {
        super(data, IndexType.FULLTEXT);
        MetaData meta = data.meta;
        this.tree = new FTIndexTrees(data.meta.maxlen);
        FTOpt fto = new FTOpt();
        fto.set(FTFlag.DC, meta.diacritics);
        fto.set(FTFlag.ST, meta.stemming);
        fto.cs = meta.casesens ? FTCase.SENSITIVE : FTCase.INSENSITIVE;
        fto.sw = new StopWords(data, meta.stopwords);
        fto.ln = data.meta.language;
        if (!Tokenizer.supportFor(fto.ln)) {
            throw new BaseXException(Text.NO_TOKENIZER_X, fto.ln);
        }
        if (meta.stemming && !Stemmer.supportFor(fto.ln)) {
            throw new BaseXException(Text.NO_STEMMER_X, fto.ln);
        }
        this.lexer = new FTLexer(fto);
    }

    @Override
    public FTIndex build() throws IOException {
        Util.debug(this.detailedInfo(), new Object[0]);
        try {
            this.pre = 0;
            while (this.pre < this.size) {
                if ((this.pre & 0xFFF) == 0) {
                    this.check();
                }
                if (this.indexEntry()) {
                    StopWords sw = this.lexer.ftOpt().sw;
                    this.lexer.init(this.data.text(this.pre, true));
                    int pos = -1;
                    while (this.lexer.hasNext()) {
                        byte[] tok = this.lexer.nextToken();
                        ++pos;
                        if (tok.length > this.data.meta.maxlen || !sw.isEmpty() && sw.contains(tok)) continue;
                        if ((this.ntok++ & 0xFFFFL) == 0L && this.splitRequired()) {
                            this.writeIndex(true);
                            this.clean();
                        }
                        this.tree.index(tok, this.pre, pos, this.splits);
                        ++this.count;
                    }
                }
                ++this.pre;
            }
            this.write(this.splits > 0);
            this.finishIndex();
            return new FTIndex(this.data);
        }
        catch (Throwable th) {
            this.data.meta.drop("ftx.*");
            throw th;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void write(boolean partial) throws IOException {
        this.writeIndex(partial);
        if (!partial) {
            return;
        }
        var2_2 = null;
        var3_4 = null;
        try {
            outX = new DataOutput(this.data.meta.dbfile("ftxx"));
            try {
                outY = new DataOutput(this.data.meta.dbfile("ftxy"));
                try {
                    outZ = new DataOutput(this.data.meta.dbfile("ftxz"));
                    try {
                        ind = new IntList();
                        v = new FTList[this.splits];
                        b = 0;
                        while (b < this.splits) {
                            v[b] = new FTList(this.data, b);
                            ++b;
                        }
                        il = new IntList();
                        while (FTBuilder.check(v)) {
                            il.reset();
                            m = 0;
                            il.add(m);
                            i = 0;
                            while (i < this.splits) {
                                if (m != i && v[i].tok.length != 0) {
                                    l = v[i].tok.length - v[m].tok.length;
                                    d = Token.diff(v[m].tok, v[i].tok);
                                    if (l < 0 || l == 0 && d > 0 || v[m].tok.length == 0) {
                                        m = i;
                                        il.reset();
                                        il.add(m);
                                    } else if (d == 0 && v[i].tok.length > 0) {
                                        il.add(i);
                                    }
                                }
                                ++i;
                            }
                            if (ind.isEmpty() || ind.get(ind.size() - 2) < v[m].tok.length) {
                                ind.add(v[m].tok.length);
                                ind.add((int)outY.size());
                            }
                            outY.writeBytes(v[m].tok);
                            outY.write5(outZ.size());
                            outY.write4(FTBuilder.merge(outZ, il, v));
                        }
                        FTBuilder.writeInd(outX, ind, ind.get(ind.size() - 2) + 1, (int)outY.size());
                    }
                    finally {
                        if (outZ != null) {
                            outZ.close();
                        }
                    }
                    ** if (outY == null) goto lbl-1000
                }
                catch (Throwable var3_5) {
                    if (var2_2 == null) {
                        var2_2 = var3_5;
                    } else if (var2_2 != var3_5) {
                        var2_2.addSuppressed(var3_5);
                    }
                    if (outY != null) {
                        outY.close();
                    }
                    throw var2_2;
                }
lbl-1000:
                // 1 sources

                {
                    outY.close();
                }
lbl-1000:
                // 2 sources

                {
                }
                ** if (outX == null) goto lbl-1000
            }
            catch (Throwable var3_6) {
                if (var2_2 == null) {
                    var2_2 = var3_6;
                } else if (var2_2 != var3_6) {
                    var2_2.addSuppressed(var3_6);
                }
                if (outX != null) {
                    outX.close();
                }
                throw var2_2;
            }
lbl-1000:
            // 1 sources

            {
                outX.close();
            }
lbl-1000:
            // 2 sources

            {
            }
        }
        catch (Throwable var3_7) {
            if (var2_2 == null) {
                var2_2 = var3_7;
            } else if (var2_2 != var3_7) {
                var2_2.addSuppressed(var3_7);
            }
            throw var2_2;
        }
    }

    private static void writeInd(DataOutput outX, IntList il, int ls, int lp) throws IOException {
        int is = il.size();
        outX.writeNum(is >> 1);
        int i = 0;
        while (i < is) {
            outX.writeNum(il.get(i));
            outX.write4(il.get(i + 1));
            i += 2;
        }
        outX.writeNum(ls);
        outX.write4(lp);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeIndex(boolean partial) throws IOException {
        block24: {
            String name = "ftx" + (partial ? Integer.valueOf(this.splits) : "");
            Throwable throwable = null;
            Object var4_5 = null;
            try {
                DataOutput outX = new DataOutput(this.data.meta.dbfile(String.valueOf(name) + 'x'));
                try {
                    block23: {
                        DataOutput outY = new DataOutput(this.data.meta.dbfile(String.valueOf(name) + 'y'));
                        try {
                            try (DataOutput outZ = new DataOutput(this.data.meta.dbfile(String.valueOf(name) + 'z'));){
                                IntList ind = new IntList();
                                this.tree.init();
                                long dr = 0L;
                                int tr = 0;
                                int j = 0;
                                block9: while (true) {
                                    if (!this.tree.more(this.splits)) {
                                        FTBuilder.writeInd(outX, ind, ++j, tr);
                                        break;
                                    }
                                    FTIndexTree t = this.tree.nextTree();
                                    t.next();
                                    byte[] key = t.nextTok();
                                    if (j < key.length) {
                                        j = key.length;
                                        ind.add(j);
                                        ind.add(tr);
                                    }
                                    int i = 0;
                                    while (true) {
                                        if (i >= j) {
                                            outY.write5(dr);
                                            outY.write4(t.nextNumPre());
                                            FTBuilder.writeFTData(outZ, t.nextPres(), t.nextPoss());
                                            dr = outZ.size();
                                            tr = (int)outY.size();
                                            continue block9;
                                        }
                                        outY.write1(key[i]);
                                        ++i;
                                    }
                                    break;
                                }
                            }
                            if (outY == null) break block23;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (outY == null) throw throwable;
                            outY.close();
                            throw throwable;
                        }
                        outY.close();
                    }
                    if (outX == null) break block24;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    if (outX == null) throw throwable;
                    outX.close();
                    throw throwable;
                }
                outX.close();
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                }
                if (throwable == throwable4) throw throwable;
                throwable.addSuppressed(throwable4);
                throw throwable;
            }
        }
        this.tree.initFT();
        ++this.splits;
    }

    private static int merge(DataOutput out, IntList il, FTList[] v) throws IOException {
        TokenBuilder tbp = new TokenBuilder();
        TokenBuilder tbo = new TokenBuilder();
        tbp.add(new byte[4]);
        tbo.add(new byte[4]);
        int s = 0;
        int is = il.size();
        int j = 0;
        while (j < is) {
            int p;
            int m = il.get(j);
            int[] nArray = v[m].prv;
            int n = v[m].prv.length;
            int n2 = 0;
            while (n2 < n) {
                p = nArray[n2];
                tbp.add(Num.num(p));
                ++n2;
            }
            nArray = v[m].pov;
            n = v[m].pov.length;
            n2 = 0;
            while (n2 < n) {
                p = nArray[n2];
                tbo.add(Num.num(p));
                ++n2;
            }
            s += v[m].size;
            v[m].next();
            ++j;
        }
        byte[] pr = tbp.finish();
        Num.size(pr, pr.length);
        byte[] po = tbo.finish();
        Num.size(po, po.length);
        FTBuilder.writeFTData(out, pr, po);
        return s;
    }

    private static void writeFTData(DataOutput out, byte[] vpre, byte[] vpos) throws IOException {
        int np = 4;
        int pp = 4;
        int ns = Num.size(vpre);
        while (np < ns) {
            int l = np + Num.length(vpre, np);
            while (np < l) {
                out.write(vpre[np]);
                ++np;
            }
            l = pp + Num.length(vpos, pp);
            while (pp < l) {
                out.write(vpos[pp]);
                ++pp;
            }
        }
    }

    private static boolean check(FTList[] lists) {
        FTList[] fTListArray = lists;
        int n = lists.length;
        int n2 = 0;
        while (n2 < n) {
            FTList l = fTListArray[n2];
            if (l.tok.length > 0) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

