/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view.map;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import javax.swing.SwingUtilities;
import org.basex.data.Data;
import org.basex.gui.GUIConstants;
import org.basex.gui.GUIOptions;
import org.basex.gui.layout.BaseXKeys;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXPopup;
import org.basex.gui.view.View;
import org.basex.gui.view.ViewData;
import org.basex.gui.view.ViewNotifier;
import org.basex.gui.view.map.MapDefault;
import org.basex.gui.view.map.MapLayout;
import org.basex.gui.view.map.MapList;
import org.basex.gui.view.map.MapPainter;
import org.basex.gui.view.map.MapRect;
import org.basex.gui.view.map.MapRects;
import org.basex.gui.view.map.MapRenderer;
import org.basex.query.value.seq.DBNodes;
import org.basex.util.Performance;
import org.basex.util.Token;
import org.basex.util.ft.FTLexer;
import org.basex.util.list.IntList;
import org.basex.util.list.TokenList;

public final class MapView
extends View {
    private static final int[] ZS;
    private static final int ZOOMSIZE;
    private static final int MAXZS;
    private MapRects mainRects;
    private transient MapPainter painter;
    private int[] textLen;
    private final MapRect[] rectHist = new MapRect[20];
    private int zoomStep;
    private MapRect mainRect;
    private MapRect selBox;
    private boolean zoomIn;
    private int zoomSpeed;
    private int mouseX = -1;
    private int mouseY = -1;
    private int dragTol;
    private MapRect focused;
    private BufferedImage mainMap;
    private BufferedImage zoomMap;
    MapLayout layout;

    static {
        int[] nArray = new int[31];
        nArray[4] = 20;
        nArray[5] = 80;
        nArray[6] = 180;
        nArray[7] = 320;
        nArray[8] = 540;
        nArray[9] = 840;
        nArray[10] = 1240;
        nArray[11] = 1740;
        nArray[12] = 2380;
        nArray[13] = 3120;
        nArray[14] = 4000;
        nArray[15] = 4980;
        nArray[16] = 5980;
        nArray[17] = 6860;
        nArray[18] = 7600;
        nArray[19] = 8240;
        nArray[20] = 8740;
        nArray[21] = 9140;
        nArray[22] = 9440;
        nArray[23] = 9660;
        nArray[24] = 9800;
        nArray[25] = 9900;
        nArray[26] = 9960;
        nArray[27] = 9980;
        nArray[28] = 9980;
        nArray[29] = 9980;
        nArray[30] = 10000;
        ZS = nArray;
        ZOOMSIZE = ZS.length - 1;
        MAXZS = ZS[ZOOMSIZE];
    }

    public MapView(ViewNotifier notifier) {
        super("map", notifier);
        new BaseXPopup(this, GUIConstants.POPUP);
    }

    private BufferedImage createImage() {
        return new BufferedImage(Math.max(1, this.getWidth()), Math.max(1, this.getHeight()), 4);
    }

    @Override
    public void refreshInit() {
        this.painter = null;
        this.mainRects = null;
        this.focused = null;
        this.textLen = null;
        this.zoomStep = 0;
        Data data = this.gui.context.data();
        GUIOptions gopts = this.gui.gopts;
        if (data != null && this.visible()) {
            this.painter = new MapDefault(this, gopts);
            this.mainMap = this.createImage();
            this.zoomMap = this.createImage();
            this.refreshLayout();
        }
    }

    @Override
    public void refreshFocus() {
        int f = this.gui.context.focused;
        if (f == -1) {
            this.focused = null;
        }
        if (this.mainRects == null) {
            return;
        }
        int ms = this.mainRects.size;
        int mi = 0;
        while (mi < ms) {
            MapRect rect = this.mainRects.get(mi);
            if (f == rect.pre || mi + 1 == ms || f < this.mainRects.get((int)(mi + 1)).pre) {
                this.focused = rect;
                this.repaint();
                break;
            }
            ++mi;
        }
    }

    @Override
    public void refreshMark() {
        this.drawMap(this.mainMap, this.mainRects);
        this.repaint();
    }

    @Override
    public void refreshContext(boolean more, boolean quick) {
        boolean page;
        DBNodes context = this.gui.context.current();
        int hist = this.gui.notify.hist;
        boolean bl = page = !more && this.rectHist[hist + 1] != null && this.rectHist[hist + 1].pre == 0 || more && (context.size() != 1L || this.focused == null || context.pre(0) != this.focused.pre);
        if (page) {
            this.focused = new MapRect(0, 0, this.getWidth(), 1);
        }
        this.zoom(more, quick);
    }

    @Override
    public void refreshLayout() {
        if (this.painter == null) {
            return;
        }
        DBNodes curr = this.gui.context.current();
        this.calc(new MapRect(0, 0, this.getWidth(), this.getHeight(), 0, 0), curr, this.mainMap);
        this.repaint();
    }

    @Override
    public void refreshUpdate() {
        this.textLen = null;
        this.refreshContext(false, true);
    }

    @Override
    public boolean visible() {
        return this.gui.gopts.get(GUIOptions.SHOWMAP);
    }

    @Override
    public void visible(boolean v) {
        this.gui.gopts.set(GUIOptions.SHOWMAP, v);
    }

    @Override
    protected boolean db() {
        return true;
    }

    private void zoom(boolean more, boolean quick) {
        this.gui.updating = !quick;
        this.zoomIn = more;
        int hist = this.gui.notify.hist;
        if (more) {
            this.rectHist[hist] = this.focused;
            this.mainRect = this.rectHist[hist];
        } else {
            this.mainRect = this.rectHist[hist + 1];
        }
        if (this.mainRect == null) {
            this.mainRect = new MapRect(0, 0, this.getWidth(), this.getHeight());
        }
        BufferedImage tmpMap = this.zoomMap;
        this.zoomMap = this.mainMap;
        this.mainMap = tmpMap;
        this.focused = null;
        this.refreshLayout();
        if (this.mainRect.w > 0 && this.mainRect.h > 0) {
            this.zoomSpeed = (int)(StrictMath.log(64.0 * (double)this.getWidth() / (double)this.mainRect.w) + StrictMath.log(64.0 * (double)this.getHeight() / (double)this.mainRect.h));
        }
        if (quick) {
            this.gui.updating = false;
            this.focus();
            this.repaint();
        } else {
            this.zoomStep = ZOOMSIZE;
            new Thread(() -> {
                this.focused = null;
                while (this.zoomStep > 1) {
                    Performance.sleep(this.zoomSpeed);
                    --this.zoomStep;
                    this.repaint();
                }
                while (this.gui.painting) {
                    Performance.sleep(this.zoomSpeed);
                }
                this.zoomStep = 0;
                this.gui.updating = false;
                this.focus();
                this.repaint();
            }).start();
        }
    }

    private boolean focus() {
        if (this.gui.updating || this.mainRects == null) {
            return false;
        }
        int r = this.mainRects.size;
        while (--r >= 0) {
            MapRect rect = this.mainRects.get(r);
            if (rect.contains(this.mouseX, this.mouseY)) break;
        }
        MapRect fr = r >= 0 ? this.mainRects.get(r) : null;
        boolean nf = this.focused != fr || fr != null && fr.thumb;
        this.focused = fr;
        if (nf) {
            this.gui.notify.focus(this.focused != null ? this.focused.pre : -1, this);
        }
        return nf;
    }

    private void calc(MapRect rect, DBNodes nodes, BufferedImage map) {
        this.gui.cursor(GUIConstants.CURSORWAIT);
        this.initLen();
        this.layout = new MapLayout(nodes.data(), this.textLen, this.gui.gopts);
        this.layout.makeMap(rect, new MapList((int[])nodes.pres().clone()), 0, (int)nodes.size() - 1);
        this.mainRects = this.layout.rectangles.copy();
        this.drawMap(map, this.mainRects);
        this.focus();
        this.gui.cursor(GUIConstants.CURSORARROW, true);
    }

    @Override
    public void paintComponent(Graphics g) {
        GUIOptions gopts;
        MapRect f;
        BufferedImage img2;
        Data data = this.gui.context.data();
        if (data == null) {
            return;
        }
        if (this.mainRects == null || this.mainRects.size == 0 || this.mainRects.get((int)0).w == 0) {
            super.paintComponent(g);
            if (this.mainRects == null || this.mainRects.size != 0) {
                this.refreshInit();
            }
            return;
        }
        this.gui.painting = true;
        boolean in = this.zoomStep > 0 && this.zoomIn;
        BufferedImage img1 = in ? this.zoomMap : this.mainMap;
        BufferedImage bufferedImage = img2 = in ? this.mainMap : this.zoomMap;
        if (this.zoomStep > 0) {
            this.drawImage(g, img1, -this.zoomStep);
            this.drawImage(g, img2, this.zoomStep);
        } else {
            this.drawImage(g, this.mainMap, this.zoomStep);
        }
        if (this.focused != null && this.focused.pre >= data.meta.size) {
            this.focused = null;
        }
        if ((f = this.focused) == null || this.mainRects.size == 1 && f == this.mainRects.get(0)) {
            this.gui.painting = false;
            if (f == null || !f.thumb) {
                return;
            }
        }
        if ((gopts = this.gui.gopts).get(GUIOptions.MAPOFFSETS) == 0) {
            g.setColor(GUIConstants.color(32));
            int pre = this.mainRects.size;
            int par = ViewData.parent(data, f.pre);
            while (--pre >= 0) {
                MapRect rect = this.mainRects.get(pre);
                if (rect.pre != par) continue;
                int x = rect.x;
                int y = rect.y;
                int w = rect.w;
                int h = rect.h;
                g.drawRect(x, y, w, h);
                g.drawRect(x - 1, y - 1, w + 2, h + 2);
                par = ViewData.parent(data, par);
            }
        }
        if (this.selBox != null) {
            g.setColor(GUIConstants.colormark3);
            g.drawRect(this.selBox.x, this.selBox.y, this.selBox.w, this.selBox.h);
            g.drawRect(this.selBox.x - 1, this.selBox.y - 1, this.selBox.w + 2, this.selBox.h + 2);
        } else {
            int x = f.x;
            int y = f.y;
            int w = f.w;
            int h = f.h;
            g.setColor(GUIConstants.color4);
            g.drawRect(x, y, w, h);
            g.drawRect(x + 1, y + 1, w - 2, h - 2);
            g.setFont(GUIConstants.font);
            BaseXLayout.antiAlias(g);
            if (data.kind(f.pre) == 1) {
                String tt = Token.string(ViewData.name(gopts, data, f.pre));
                if (tt.length() > 32) {
                    tt = String.valueOf(tt.substring(0, 30)) + "...";
                }
                BaseXLayout.drawTooltip(g, tt, x, y, this.getWidth(), f.level + 5);
            }
            if (f.thumb) {
                f.x += 3;
                f.w -= 3;
                byte[] text = MapPainter.text(data, f);
                int[][] info = new FTLexer().init(text).info();
                TokenList tl = MapRenderer.calculateToolTip(f, info, this.mouseX, this.mouseY, this.getWidth(), g);
                MapRect mr = new MapRect(this.getX(), this.getY(), this.getWidth(), this.getHeight());
                MapRenderer.drawToolTip(g, this.mouseX, this.mouseY, mr, tl, GUIConstants.fontSize);
                f.x -= 3;
                f.w += 3;
            }
        }
        this.gui.painting = false;
    }

    private void drawImage(Graphics g, Image img, int zi) {
        if (img == null) {
            return;
        }
        MapRect r = new MapRect(0, 0, this.getWidth(), this.getHeight());
        this.zoom(r, zi);
        g.drawImage(img, r.x, r.y, r.x + r.w, r.y + r.h, 0, 0, this.getWidth(), this.getHeight(), this);
    }

    private void zoom(MapRect r, int zs) {
        long xs = r.x;
        long ys = r.y;
        long xe = xs + (long)r.w;
        long ye = ys + (long)r.h;
        if (zs != 0) {
            MapRect zr = this.mainRect;
            int tw = this.getWidth();
            int th = this.getHeight();
            if (zs > 0) {
                long s = ZS[this.zoomIn ? zs : ZOOMSIZE - zs];
                xs = ((long)zr.x + xs * (long)zr.w / (long)tw - xs) * s / (long)MAXZS;
                ys = ((long)zr.y + ys * (long)zr.h / (long)th - ys) * s / (long)MAXZS;
                xe += ((long)zr.x + xe * (long)zr.w / (long)tw - xe) * s / (long)MAXZS;
                ye += ((long)zr.y + ye * (long)zr.h / (long)th - ye) * s / (long)MAXZS;
            } else {
                long s = 10000 - ZS[this.zoomIn ? -zs : ZOOMSIZE + zs];
                if (zr.w == 0) {
                    zr.w = 1;
                }
                if (zr.h == 0) {
                    zr.h = 1;
                }
                xs = -xe * (long)zr.x / (long)zr.w * s / (long)MAXZS;
                xe = xs + xe + xe * (xe - (long)zr.w) / (long)zr.w * s / (long)MAXZS;
                ys = -ye * (long)zr.y / (long)zr.h * s / (long)MAXZS;
                ye = ys + ye + ye * (ye - (long)zr.h) / (long)zr.h * s / (long)MAXZS;
            }
        }
        r.x = (int)xs;
        r.y = (int)ys;
        r.w = (int)(xe - xs);
        r.h = (int)(ye - ys);
    }

    private void drawMap(BufferedImage map, MapRects rects) {
        Graphics g = map.getGraphics();
        BaseXLayout.antiAlias(g);
        this.painter.drawRectangles(g, rects);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.gui.updating) {
            return;
        }
        this.mouseX = e.getX();
        this.mouseY = e.getY();
        if (this.focus()) {
            this.repaint();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.gui.updating) {
            return;
        }
        super.mousePressed(e);
        this.mouseX = e.getX();
        this.mouseY = e.getY();
        this.dragTol = 0;
        if (!this.focus() && this.gui.context.focused == -1) {
            return;
        }
        DBNodes marked = this.gui.context.marked;
        if (e.getClickCount() == 2) {
            if (this.mainRects.size != 1) {
                this.gui.notify.context(marked, false, null);
            }
        } else if (e.isShiftDown()) {
            this.gui.notify.mark(1, null);
        } else if (BaseXKeys.sc(e) && SwingUtilities.isLeftMouseButton(e)) {
            this.gui.notify.mark(2, null);
        } else if (!marked.contains(this.gui.context.focused)) {
            this.gui.notify.mark(0, null);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.gui.updating || ++this.dragTol < 8 || this.mainRects.sorted != this.mainRects.list) {
            return;
        }
        int mx = this.mouseX;
        int my = this.mouseY;
        int mw = e.getX() - mx;
        int mh = e.getY() - my;
        if (mw < 0) {
            mw = -mw;
            mx -= mw;
        }
        if (mh < 0) {
            mh = -mh;
            my -= mh;
        }
        this.selBox = new MapRect(mx, my, mw, mh);
        Data data = this.gui.context.data();
        IntList il = new IntList();
        int np = 0;
        int rl = this.mainRects.size;
        int r = 0;
        while (r < rl) {
            MapRect rect = this.mainRects.get(r);
            if (this.mainRects.get((int)r).pre >= np && this.selBox.contains(rect)) {
                il.add(rect.pre);
                np = rect.pre + ViewData.size(data, rect.pre);
            }
            ++r;
        }
        this.gui.notify.mark(new DBNodes(data, il.finish()), null);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.gui.updating) {
            return;
        }
        if (this.selBox != null) {
            this.selBox = null;
            this.repaint();
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (this.gui.updating || this.gui.context.focused == -1) {
            return;
        }
        if (e.getWheelRotation() <= 0) {
            DBNodes m;
            this.gui.context.marked = m = new DBNodes(this.gui.context.data(), this.gui.context.focused);
            this.gui.notify.context(m, false, null);
        } else {
            this.gui.notify.hist(false);
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        boolean cursor;
        super.keyPressed(e);
        if (this.gui.updating || this.mainRects == null || BaseXKeys.control(e)) {
            return;
        }
        boolean bl = cursor = BaseXKeys.PREVLINE.is(e) || BaseXKeys.NEXTLINE.is(e) || BaseXKeys.PREVCHAR.is(e) || BaseXKeys.NEXTCHAR.is(e);
        if (!cursor) {
            return;
        }
        if (this.focused == null) {
            this.focused = this.mainRects.get(0);
        }
        int fs = GUIConstants.fontSize;
        int o = fs + 4;
        boolean shift = e.isShiftDown();
        if (BaseXKeys.PREVLINE.is(e)) {
            this.mouseY = this.focused.y + (shift ? this.focused.h - fs : 0) - 1;
            if (shift) {
                this.mouseX = this.focused.x + (this.focused.w >> 1);
            }
        } else if (BaseXKeys.NEXTLINE.is(e)) {
            this.mouseY = this.focused.y + (shift ? o : this.focused.h + 1);
            if (shift) {
                this.mouseX = this.focused.x + (this.focused.w >> 1);
            }
        } else if (BaseXKeys.PREVCHAR.is(e)) {
            this.mouseX = this.focused.x + (shift ? this.focused.w - fs : 0) - 1;
            if (shift) {
                this.mouseY = this.focused.y + (this.focused.h >> 1);
            }
        } else if (BaseXKeys.NEXTCHAR.is(e)) {
            this.mouseX = this.focused.x + (shift ? o : this.focused.w + 1);
            if (shift) {
                this.mouseY = this.focused.y + (this.focused.h >> 1);
            }
        }
        o = this.mainRects.get((int)0).w == this.getWidth() ? (o >> 1) + 1 : 0;
        this.mouseX = Math.max(o, Math.min(this.getWidth() - o - 1, this.mouseX));
        this.mouseY = Math.max(o << 1, Math.min(this.getHeight() - o - 1, this.mouseY));
        if (this.focus()) {
            this.repaint();
        }
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (this.gui.updating) {
            return;
        }
        this.focused = null;
        this.mainMap = this.createImage();
        this.zoomMap = this.createImage();
        this.refreshLayout();
    }

    private void initLen() {
        Data data = this.gui.context.data();
        if (this.textLen != null || this.gui.gopts.get(GUIOptions.MAPWEIGHT) == 0) {
            return;
        }
        int size = data.meta.size;
        this.textLen = new int[size];
        IntList pars = new IntList();
        int l = 0;
        int pre = 0;
        while (pre < size) {
            int kind = data.kind(pre);
            int par = data.parent(pre, kind);
            int ll = l;
            while (l > 0 && pars.get(l - 1) > par) {
                int n = pars.get(l - 1);
                this.textLen[n] = this.textLen[n] + this.textLen[pars.get(l)];
                --l;
            }
            if (l > 0 && ll != l) {
                int n = pars.get(l - 1);
                this.textLen[n] = this.textLen[n] + this.textLen[pars.get(l)];
            }
            pars.set(l, pre);
            if (kind == 0 || kind == 1) {
                pars.set(++l, 0);
            } else {
                this.textLen[pre] = data.textLen(pre, kind != 3);
            }
            ++pre;
        }
        while (--l >= 0) {
            int n = pars.get(l);
            this.textLen[n] = this.textLen[n] + this.textLen[pars.get(l + 1)];
        }
    }
}

