/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import org.basex.core.Text;
import org.basex.core.cmd.Add;
import org.basex.data.MetaData;
import org.basex.gui.GUIConstants;
import org.basex.gui.dialog.DialogImport;
import org.basex.gui.dialog.DialogParsing;
import org.basex.gui.dialog.DialogProgress;
import org.basex.gui.dialog.DialogProps;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXButton;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXTabs;
import org.basex.gui.layout.BaseXTextField;
import org.basex.gui.layout.TableLayout;
import org.basex.util.Util;

final class DialogAdd
extends BaseXBack {
    private final DialogProps dialog;
    final BaseXTextField target;
    private final DialogImport general;
    private final BaseXButton add;

    DialogAdd(DialogProps dialog) {
        this.dialog = dialog;
        this.setLayout(new BorderLayout());
        this.add((Component)new BaseXLabel(Text.ADD_RESOURCES).large().border(0, 0, 16, 0), "North");
        this.target = new BaseXTextField(dialog, "/");
        BaseXBack pnl = new BaseXBack(new TableLayout(2, 1));
        pnl.add(new BaseXLabel(String.valueOf(Text.TARGET_PATH) + ": ", true, true).border(8, 0, 6, 0));
        pnl.add(this.target);
        BaseXTabs tabs = new BaseXTabs(dialog);
        DialogParsing parsing = new DialogParsing(dialog, tabs);
        this.general = new DialogImport(dialog, pnl, parsing);
        tabs.addTab(Text.GENERAL, this.general);
        tabs.addTab(Text.PARSING, parsing);
        this.add((Component)tabs, "Center");
        this.add = new BaseXButton(dialog, String.valueOf(Text.ADD) + "...");
        this.add((Component)dialog.newButtons(this.add), "South");
        this.action(this.general.parsers);
    }

    void action(Object comp) {
        String src = this.general.input();
        String trg = this.target.getText().trim();
        if (comp == this.add) {
            this.general.setOptions();
            Runnable run = () -> this.dialog.resources.refreshNewFolder(trg);
            DialogProgress.execute((BaseXDialog)this.dialog, run, new Add(trg, src));
        } else {
            String inf;
            boolean ok = this.general.action(comp, false);
            if (comp == this.general.browse || comp == this.general.input) {
                this.target.setText(this.general.dbName);
            }
            if (ok) {
                ok = MetaData.normPath(trg) != null;
                inf = ok ? null : Util.info(Text.INVALID_X, Text.TARGET_PATH);
            } else {
                inf = Text.RES_NOT_FOUND;
            }
            this.general.info.setText(inf, GUIConstants.Msg.ERROR);
            this.add.setEnabled(ok);
        }
    }
}

