/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import org.basex.core.Context;
import org.basex.core.Databases;
import org.basex.core.StaticOptions;
import org.basex.core.Text;
import org.basex.core.cmd.ABackup;
import org.basex.core.cmd.DropDB;
import org.basex.core.cmd.Open;
import org.basex.io.IOFile;
import org.basex.io.Zip;
import org.basex.util.Util;
import org.basex.util.list.StringList;

public final class Restore
extends ABackup {
    private boolean closed;

    public Restore(String arg) {
        super(arg);
    }

    @Override
    protected boolean run() {
        String name = this.args[0];
        if (!Databases.validName(name)) {
            return this.error(Text.NAME_INVALID_X, name);
        }
        StringList backups = this.context.databases.backups(name);
        if (backups.isEmpty()) {
            return this.error(Text.BACKUP_NOT_FOUND_X, name);
        }
        String backup = (String)backups.get(0);
        String db = Databases.name(backup);
        if (!this.closed) {
            this.closed = Restore.close(this.context, db);
        }
        if (this.context.pinned(db)) {
            return this.error(Text.DB_PINNED_X, db);
        }
        try {
            Restore.restore(db, backup, this.soptions, this);
            return !this.closed || new Open(db).run(this.context) ? this.info(Text.DB_RESTORED_X, backup, this.jc().performance) : this.error(Text.DB_NOT_RESTORED_X, db);
        }
        catch (IOException ex) {
            Util.debug(ex);
            return this.error(Text.DB_NOT_RESTORED_X, db);
        }
    }

    @Override
    public void addLocks() {
        super.addLocks();
        String backup = this.args[0];
        this.jc().locks.writes.add(backup).add(Databases.name(backup));
    }

    public static void restore(String db, String backup, StaticOptions sopts, Restore cmd) throws IOException {
        DropDB.drop(db, sopts);
        IOFile dbpath = sopts.dbPath();
        Zip zip = new Zip(new IOFile(dbpath, String.valueOf(backup) + ".zip"));
        try {
            if (cmd != null) {
                cmd.pushJob(zip);
            }
            zip.unzip(dbpath);
        }
        finally {
            if (cmd != null) {
                cmd.popJob();
            }
        }
    }

    @Override
    public String shortInfo() {
        return Text.RESTORE;
    }

    @Override
    public boolean newData(Context ctx) {
        this.closed = Restore.close(ctx, this.args[0]);
        return this.closed;
    }

    @Override
    public boolean supportsProg() {
        return true;
    }
}

