/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import java.util.Map;
import org.basex.core.Command;
import org.basex.core.jobs.JobPool;
import org.basex.core.jobs.QueryJobResult;
import org.basex.core.parse.CmdBuilder;
import org.basex.core.parse.Commands;
import org.basex.core.users.Perm;
import org.basex.io.serial.Serializer;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.iter.BasicIter;
import org.basex.query.iter.Iter;
import org.basex.query.value.item.Item;
import org.basex.util.Util;

public final class JobsResult
extends Command {
    public JobsResult(String id) {
        super(Perm.ADMIN, id);
    }

    @Override
    protected boolean run() {
        String id = this.args[0];
        JobPool jobs = this.context.jobs;
        Map<String, QueryJobResult> results = jobs.results;
        QueryJobResult result = results.get(id);
        if (result == null) {
            return this.error(QueryError.JOBS_UNKNOWN_X.desc, id);
        }
        if (!result.cached()) {
            this.error(QueryError.JOBS_RUNNING_X.desc, id);
        }
        try {
            Item item;
            if (result.value == null) {
                throw result.exception;
            }
            Serializer ser = Serializer.get(this.out);
            BasicIter<Item> iter = result.value.iter();
            while ((item = ((Iter)iter).next()) != null) {
                ser.serialize(item);
                this.checkStop();
            }
            return true;
        }
        catch (IOException | QueryException ex) {
            this.exception = ex;
            boolean bl = this.error(Util.message(ex), new Object[0]);
            return bl;
        }
        finally {
            results.remove(id);
        }
    }

    @Override
    public void addLocks() {
    }

    @Override
    public void build(CmdBuilder cb) {
        cb.init((Object)((Object)Commands.Cmd.JOBS) + " " + (Object)((Object)Commands.CmdJobs.RESULT)).args();
    }
}

