/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core;

import java.io.IOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.util.ArrayList;
import org.basex.api.client.ClientSession;
import org.basex.api.client.LocalSession;
import org.basex.api.client.Session;
import org.basex.core.BaseXException;
import org.basex.core.Command;
import org.basex.core.Context;
import org.basex.core.StaticOptions;
import org.basex.core.Text;
import org.basex.core.cmd.Exit;
import org.basex.core.parse.CommandParser;
import org.basex.core.parse.PasswordReader;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.query.QueryException;
import org.basex.util.Main;
import org.basex.util.Pair;
import org.basex.util.Util;

public abstract class CLI
extends Main {
    public Context context;
    protected final ArrayList<Pair<String, String>> commands = new ArrayList();
    protected OutputStream out = System.out;
    protected boolean verbose;
    private static final PasswordReader PWREADER = () -> {
        Util.out(String.valueOf(Text.PASSWORD) + ": ", new Object[0]);
        return Util.password();
    };
    private Session session;

    protected CLI(Context ctx, String ... args) throws IOException {
        super(args);
        this.context = ctx;
        this.parseArgs();
        if (this.context != null) {
            Runtime.getRuntime().addShutdownHook(new Thread(this.context::close));
        }
    }

    protected final boolean execute(Pair<String, String> command) throws IOException {
        CommandParser cp = CommandParser.get(command.value(), this.context);
        return this.execute(cp.baseURI(command.name()).pwReader(PWREADER));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final boolean execute(CommandParser parser) throws IOException {
        try {
            Command[] commandArray = parser.parse();
            int n = commandArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return true;
                }
                Command cmd = commandArray[n2];
                if (cmd instanceof Exit) {
                    return false;
                }
                this.execute(cmd, this.verbose);
                ++n2;
            }
        }
        catch (QueryException ex) {
            throw new BaseXException(ex);
        }
    }

    protected final void execute(Command cmd, boolean info) throws IOException {
        Session ss = this.session();
        ss.execute(cmd);
        if (info) {
            Util.out(ss.info(), new Object[0]);
        }
    }

    protected final Session session() throws IOException {
        if (this.session == null) {
            this.session = this.init();
        }
        this.session.setOutputStream(this.out);
        return this.session;
    }

    private Session init() throws IOException {
        if (this.local()) {
            return new LocalSession(this.context, this.out);
        }
        String user = this.context.soptions.get(StaticOptions.USER);
        String pass = this.context.soptions.get(StaticOptions.PASSWORD);
        while (user.isEmpty()) {
            Util.out(String.valueOf(Text.USERNAME) + ": ", new Object[0]);
            user = Util.input();
        }
        while (pass.isEmpty()) {
            Util.out(String.valueOf(Text.PASSWORD) + ": ", new Object[0]);
            pass = Util.password();
        }
        String host = this.context.soptions.get(StaticOptions.HOST);
        int port = this.context.soptions.get(StaticOptions.PORT);
        try {
            return new ClientSession(host, port, user, pass, this.out);
        }
        catch (ConnectException ex) {
            Util.debug(ex);
            throw new BaseXException(Text.CONNECTION_ERROR_X, port);
        }
    }

    protected static Pair<String, String> input(String input) throws IOException {
        IO io = IO.get(input);
        boolean file = !(io instanceof IOContent) && io.exists() && !io.isDir();
        return new Pair<String, String>(file ? io.path() : "./", file ? io.string() : input);
    }

    protected boolean local() {
        return true;
    }
}

