/*
 * Decompiled with CFR 0.152.
 */
package org.basex.build.xml;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.sax.SAXSource;
import org.basex.build.SingleParser;
import org.basex.build.xml.CatalogWrapper;
import org.basex.build.xml.SAXHandler;
import org.basex.core.MainOptions;
import org.basex.core.Text;
import org.basex.core.jobs.JobException;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.io.IOFile;
import org.basex.io.IOUrl;
import org.basex.util.Util;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public final class SAXWrapper
extends SingleParser {
    private long counter;
    private int line = 1;
    private SAXHandler saxh;
    private final SAXSource saxs;
    private long length;

    public SAXWrapper(IO source, MainOptions opts) {
        super(source, opts);
        this.saxs = new SAXSource(source.inputSource());
    }

    @Override
    public void parse() throws IOException {
        InputSource is = this.wrap(this.saxs.getInputSource());
        try {
            try {
                XMLReader reader = this.saxs.getXMLReader();
                if (reader == null) {
                    boolean dtd = this.options.get(MainOptions.DTD);
                    SAXParserFactory f = SAXParserFactory.newInstance();
                    f.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", dtd);
                    f.setFeature("http://xml.org/sax/features/external-parameter-entities", dtd);
                    f.setFeature("http://xml.org/sax/features/use-entity-resolver2", false);
                    f.setNamespaceAware(true);
                    f.setValidating(false);
                    f.setXIncludeAware(this.options.get(MainOptions.XINCLUDE));
                    reader = f.newSAXParser().getXMLReader();
                }
                this.saxh = new SAXHandler(this.builder, this.options.get(MainOptions.CHOP), this.options.get(MainOptions.STRIPNS));
                String path = this.options.get(MainOptions.CATFILE);
                if (!path.isEmpty()) {
                    CatalogWrapper.set(reader, path);
                }
                reader.setDTDHandler(this.saxh);
                reader.setContentHandler(this.saxh);
                reader.setProperty("http://xml.org/sax/properties/lexical-handler", this.saxh);
                reader.setErrorHandler(this.saxh);
                if (is != null) {
                    reader.parse(is);
                } else {
                    reader.parse(this.saxs.getSystemId());
                }
            }
            catch (SAXParseException ex) {
                String msg = String.valueOf(Util.info(Text.SCANPOS_X_X, this.source.path(), ex.getLineNumber(), ex.getColumnNumber())) + ": " + Util.message(ex);
                throw new IOException(msg, ex);
            }
            catch (JobException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new IOException(String.valueOf('\"') + this.source.path() + '\"' + Util.message(ex), ex);
            }
        }
        finally {
            if (is != null) {
                Throwable throwable = null;
                Object var7_16 = null;
                try {
                    Reader r = is.getCharacterStream();
                    if (r != null) {
                        r.close();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                throwable = null;
                var7_16 = null;
                try {
                    InputStream ist = is.getByteStream();
                    if (ist != null) {
                        ist.close();
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
        }
    }

    private InputSource wrap(InputSource is) throws IOException {
        InputStream in;
        if (is == null) {
            return null;
        }
        if (is.getByteStream() != null) {
            in = is.getByteStream();
        } else {
            if (is.getSystemId() == null || is.getSystemId().isEmpty()) {
                return is;
            }
            if (this.source instanceof IOFile) {
                in = new FileInputStream(this.source.path());
            } else if (this.source instanceof IOContent || this.source instanceof IOUrl) {
                in = new ByteArrayInputStream(this.source.read());
            } else {
                return is;
            }
        }
        this.length = this.source.length();
        try {
            if (this.length <= 0L) {
                this.length = in.available();
            }
        }
        catch (IOException ex) {
            in.close();
            throw ex;
        }
        InputSource tmp = new InputSource(new InputStream(in){
            final InputStream buffer;
            {
                this.buffer = inputStream instanceof ByteArrayInputStream ? inputStream : new BufferedInputStream(inputStream);
            }

            @Override
            public int read() throws IOException {
                int i = this.buffer.read();
                if (i == 10) {
                    SAXWrapper sAXWrapper = SAXWrapper.this;
                    sAXWrapper.line = sAXWrapper.line + 1;
                }
                SAXWrapper sAXWrapper = SAXWrapper.this;
                sAXWrapper.counter = sAXWrapper.counter + 1L;
                return i;
            }

            @Override
            public void close() throws IOException {
                this.buffer.close();
            }
        });
        this.saxs.setInputSource(tmp);
        this.saxs.setSystemId(is.getSystemId());
        return tmp;
    }

    @Override
    public String detailedInfo() {
        return this.length == 0L ? super.detailedInfo() : Util.info(Text.SCANPOS_X_X, this.source.name(), this.line);
    }

    @Override
    public double progressInfo() {
        return this.length == 0L ? (this.saxh == null ? 0.0 : (double)this.saxh.nodes / 3000000.0 % 1.0) : (double)this.counter / (double)this.length;
    }
}

