--
-- Copyright (C) 2016  <fastrgv@gmail.com>
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You may read the full text of the GNU General Public License
-- at <http://www.gnu.org/licenses/>.
--


with snd4ada_hpp;

with gl, gl.binding, gl.pointers;
with glu, glu.binding, glu.pointers;
with glext, glext.binding, glext.pointers;

-------------------------------------------------------------
with System;
with Interfaces.C;
use  type interfaces.c.unsigned;
with Interfaces.C.Pointers;
with interfaces.c.strings;


----------------------------------------------------------------
with sdl;  use sdl;
----------------------------------------------------------------

with matutils;
with utex;

with ada.unchecked_conversion;
with Ada.Command_Line;
with Ada.Strings.Unbounded;
with Ada.Strings.Unbounded.Text_IO;
with ada.numerics.generic_elementary_functions;

----------------------------------------------------------------


with shader;  use shader;

with mroomobj;
with tunnelobj;
with rectobj;
with pictobj;
with rectxobj;
with rectsurfobj;
with cyl2obj;

with circsurfobj;
with usboxobj;


with text_io;
with pngloader;
with gametypes;
with gameutils;
with matutils;

with ada.calendar;



procedure adagate is

use text_io;
use pngloader;
use gametypes;
use gameutils;
use matutils;


	use gametypes.fmath;




	-- this assumes mm=ID [almost] always:
	procedure updateMVP( wid,hit : float) is
		xlk,ylk,zlk,
		xrt,yrt,zrt,
		xup,yup,zup : float;
	begin

		-- Look Vector
		xlk:=xme+xlook;
		ylk:=yme+ylook;
		zlk:=zme+zlook;

		-- Right unit-Direction
		xrt:= sin(horiang-halfpi);
		yrt:= 0.0;
		zrt:= cos(horiang-halfpi);


		-- calculate UP unit-Direction
		cross( xrt,yrt,zrt, xlook,ylook,zlook, xup,yup,zup );

		perspective(pm, 45.0, wid/hit,  0.1, 100.0);

		lookat(vm, xme,yme,zme, xlk,ylk,zlk, xup,yup,zup );


		--mv:=mm;
		--myMatMult(mv,vm); -- mv := mm*vm = id*vm = vm

		-- MV = mm*vm = id*vm = vm
		mv:=vm;

		mvp:=mv;
		myMatMult(mvp,pm); -- mvp := mv * pm


	end updateMVP;








	use interfaces.c;
	use interfaces.c.strings;
	use glext;
	use glext.pointers;
	use glext.binding;
	use gl;
	use gl.binding;
	use gl.pointers;



procedure InitSDL( width, height : glint;  flags:Uint32;  name: string ) is

use system;

  ires, jerror, error, cver : interfaces.c.int;
  bresult : SDL_bool;

  compiled, linked : aliased SDL_version;

begin

	-- Careful!  Only initialize what we use (otherwise exe won't run):
	error := SDL_Init(
		SDL_INIT_TIMER or
		SDL_INIT_EVENTS or 
		SDL_INIT_VIDEO);
	myassert( error = 0, 1000 );

	jerror := SDL_Init(
		SDL_INIT_GAMECONTROLLER or
		SDL_INIT_JOYSTICK );

	joystik:=false;
	gamepad:=false;
	if  jerror = 0  and then SDL_NumJoysticks>=1  then
		jsa := SDL_JoystickOpen(0);
		gamepad := (sdl_joysticknumaxes(jsa) >= 4);
		joystik := not gamepad;
		put_line("#axes="& glint'image(sdl_joysticknumaxes(jsa)) );
		put_line("#btns="& glint'image(sdl_joysticknumbuttons(jsa)) );
		ires := SDL_JoystickEventState(SDL_QUERY); -- ignore ires (?might this stop spinning?)
		SDL_JoystickUpdate;
		axis_lx := SDL_JoystickGetAxis(jsa, 0);
		axis_ly := SDL_JoystickGetAxis(jsa, 1);
	end if;

	if gamepad then
		put_line("...#axes>=4 so I'm guessing controller is a gamepad...initialized");
	elsif joystik then
		put_line("...#axes<=3 so I'm guessing controller is a joystick...initialized");
	else
		put_line("...no game controller detected...");
	end if;

---------- begin 14feb15 insert ------------------------------------------------
	SDL_SOURCEVERSION( compiled'access );
	put_line("We compiled against SDL version "
		&Uint8'image(compiled.major)&"."
		&Uint8'image(compiled.minor)&"."
		&Uint8'image(compiled.patch) );
	cver := SDL_COMPILEDVERSION;  
	put_line("SDL_compiledversion="&glint'image(cver));
	SDL_GetVersion( linked'access );
	put_line("We linked against SDL version "
		&Uint8'image(linked.major)&"."
		&Uint8'image(linked.minor)&"."
		&Uint8'image(linked.patch) );
---------- end 14feb15 insert --------------------------------------------------

	bresult := SDL_SetHint( SDL_HINT_RENDER_VSYNC, "1" );
	myassert( bresult = SDL_TRUE, 1001 );
	bresult := SDL_SetHint( SDL_HINT_RENDER_SCALE_QUALITY, "1" );
	myassert( bresult = SDL_TRUE, 1002 );




	--// Turn on double buffering.
	error := SDL_GL_SetAttribute(SDL_GL_DOUBLEBUFFER, 1);
	myassert( error = 0, 1003 );
	error := SDL_GL_SetAttribute(SDL_GL_DEPTH_SIZE, 24);
	myassert( error = 0, 1004 );
	error := SDL_GL_SetAttribute(SDL_GL_ALPHA_SIZE, 8);
	myassert( error = 0, 1005 );





	error := SDL_GL_SetAttribute(SDL_GL_CONTEXT_MAJOR_VERSION, 3);
	myassert( error = 0, 1006 );
	error := SDL_GL_SetAttribute(SDL_GL_CONTEXT_MINOR_VERSION, 3);
	myassert( error = 0, 1007 );




	error := SDL_GL_SetAttribute( SDL_GL_CONTEXT_PROFILE_MASK, 
											SDL_GL_CONTEXT_PROFILE_CORE );
	myassert( error = 0, 1008 );

	-- Note that OSX currently requires the forward_compatible flag!
	error := SDL_GL_SetAttribute( SDL_GL_CONTEXT_FLAGS, 
											SDL_GL_CONTEXT_FORWARD_COMPATIBLE_FLAG );
	myassert( error = 0, 1009 );



	error := SDL_GL_SetAttribute(SDL_GL_MULTISAMPLESAMPLES, 4);
	myassert( error = 0, 1010 );



	mainWindow := SDL_CreateWindow( To_C(name,true) , 
			SDL_WINDOWPOS_CENTERED, SDL_WINDOWPOS_CENTERED, 
			width, height, flags);


	mainGLContext := SDL_GL_CreateContext(mainWindow);

	error := SDL_GL_MakeCurrent( mainWindow, mainGLContext );
	myassert( error = 0, 1011 );


end InitSDL;





package myfloat_io is new text_io.float_io(float);

package mygint_io is new text_io.integer_io(glint);


--we skip blank lines and comments beginning with "#":
function is_blank( line : string; len:integer ) return boolean is
begin

	if( len < 1 ) then return true; end if;

	if line( line'first )='#' then return true;
	elsif line( line'first ) = ' ' then	return true; end if;

	return false;

end is_blank;






procedure GetInt( Rcd:string;
						Bgn:in out natural;
						Int: in out glint ) is
begin
mygint_io.get( From => Rcd(Bgn..Rcd'last),
					Item => Int,
					Last => Bgn);
Bgn:=Bgn+1;
end GetInt;



procedure getNbInt(tfile:file_type; rcd: in out string; k: in out glint) is
	len,bgn: natural:=1;
begin
	while not end_of_file(tfile) loop
		get_line(tfile, rcd, len);
		if not is_blank(rcd,len) then exit; end if;
	end loop;
	bgn:=rcd'first;

	GetInt(rcd,bgn,k);

end getNbInt;


procedure GetFlt( Rcd:string;
					  Bgn:in out natural;
					  Flt: in out float ) is
nd: positive;
begin
myfloat_io.get( From => Rcd(Bgn..Rcd'last),
					 Item => Flt,
					 Last => nd);
Bgn := nd+1;
end GetFlt;


procedure getNbFlt(tfile:file_type; rcd: in out string; t: in out float) is
	len,bgn: natural:=1;
begin
	while not end_of_file(tfile) loop
		get_line(tfile, rcd, len);
		if not is_blank(rcd,len) then exit; end if;
	end loop;
	bgn:=rcd'first;
	GetFlt(rcd,bgn,t);
end getNbFlt;












procedure first_prep is -- main program setup
	rcd : string(1..80);
	ret : glint; --interfaces.c.int;
begin

	ret := snd4ada_hpp.initSnds;
	if ret>0 then
		put_line("snd4ada_hpp.initSnds ERROR-return = "&glint'image(ret) );
		raise program_error;
	end if;


	-- 18oct14 We now assume level=0 => beach prologue...


	-- set default starting level, which will be overridden if
	-- there is a command line parm, or a non-empty restore file:
	level:= 0;

	playSecs := float( sdl_getticks ) / 1000.0;
	lastTime := playSecs;
	portalTime := lastTime-20.0;


	if FileExists(resfile) then -- takes precedence over defaults
		put_line("Resume file found");
		text_io.open(tfile, in_file, resfile);
		myint_io.get(tfile,dod); -- this overrides default
		myassert( dod>=1, 1012 );  myassert( dod<=5, 1013 );

		for i in 1..mxlev loop
			myint_io.get(tfile,good);
			myassert( (good=0) or (good=1), 1014 );
			if (good=1) then
				solved(i):=true;
			else
				solved(i):=false;
			end if;
		end loop;
		text_io.close(tfile);
	else
		put_line("No resume file found");
	end if;




	-- before we call readPuzzle we should set "dod" [DegreeOfDifficulty] 
	-- as 1(easy), 2(medium), 3(hard), 4(harder), 5(advanced)
	-- 0 => debug mode

	dbug:=false;

   if Ada.Command_Line.Argument_Count = 1 then --DOD [ or 0=> skip flyover ]
   
     declare
       lst: natural;
       dstr : string := Ada.Command_Line.Argument(1);--level
		 idod : integer;
     begin
       myint_io.get(dstr,idod,lst); -- overrides both previous, default
		if idod<1 then
		 	dbug:=true; --skip flyover
		elsif idod<=5 then
			dod:=idod;
		else
			put_line("invalid DOD value...ignoring");
		end if;
     end; --declare
   
   elsif Ada.Command_Line.Argument_Count > 1 then

     put_line("I expect at most 1 command line parm:");
	  put_line("1) Degree of Difficulty, 1=easy ... 5=extreme");
     raise program_error;

   end if;


put_line(" Puzzle Difficulty = " & integer'image(dod) );


------- begin SDL prep ---------------------------------------------------------

	ret := SDL_Init(SDL_INIT_VIDEO);
	should_be_zero := SDL_GetCurrentDisplayMode(0, current'access);
	myassert( should_be_zero = 0, 1015 );

	-- MacOSX:  HDPI is normally controlled in the "properties"
	-- box, but does not work for this app.  If there is jerkiness
	-- on your Retina display, use low dpi, which still looks 
	-- pretty good, albeit with some noticable aliasing.
	contextFlags := 
		SDL_WINDOW_SHOWN or SDL_WINDOW_OPENGL or 
		--SDL_WINDOW_FULLSCREEN_DESKTOP;
		SDL_WINDOW_FULLSCREEN_DESKTOP or SDL_WINDOW_ALLOW_HIGHDPI;

	InitSDL(current.w, current.h, contextFlags, "AdaGate");
	winwidth:=current.w;
	winheight:=current.h;



	-- this too runs fine...used for testing purposes...
	--contextFlags := SDL_WINDOW_SHOWN or SDL_WINDOW_OPENGL;
	--winwidth:=1000; --1400;
	--winheight:=600; --800;
	--InitSDL(winwidth,winheight, contextFlags, "AdaGate");


-- if joystik or gamepad, read settings here:
	if FileExists(cfgfile) then -- takes precedence over defaults
		put_line("game-controller settings file found");
		text_io.open(tfile, in_file, cfgfile);

		getNbInt(tfile,rcd,gshtl); 
		getNbInt(tfile,rcd,gshtr); 
		getNbInt(tfile,rcd,gjmp); 
		getNbFlt(tfile,rcd,Lsens); 
		getNbFlt(tfile,rcd,Rsens); 

------- end gamepad;  begin joystik --------------------

		getNbInt(tfile,rcd,jbak); 
		getNbInt(tfile,rcd,jfor); 
		getNbInt(tfile,rcd,jshtl); 
		getNbInt(tfile,rcd,jshtr); 
		getNbInt(tfile,rcd,jjmp); 
		getNbFlt(tfile,rcd,Jsens); 

		text_io.close(tfile);

	else
		put(cfgfile & " file not found...");
		put_line("Using default game controller settings");
		gshtl:=4; --shoot left
		gshtr:=5; --shoot right
		gjmp :=8; --jump

		jbak :=0; --moveback
		jfor :=1; --forward
		jshtl:=2; --shoot left
		jshtr:=3; --shoot right
		jjmp :=7; --jump
	end if;

	if joystik then --we actually use only Lsens or Rsens
		Lsens:=Jsens;
		Rsens:=Jsens; -- Jsens is not used
	end if;










	utex.inittext2d("data/rods3x.png", integer(winwidth),integer(winheight));
	put_line( "Window: wid-X-hit :" 
		& interfaces.c.int'image(winwidth)&" X "
		& interfaces.c.int'image(winheight) );

	cursor := SDL_CreateSystemCursor(SDL_SYSTEM_CURSOR_CROSSHAIR);
	SDL_SetCursor(cursor);
	error := SDL_SetRelativeMouseMode(SDL_TRUE);
	myassert( error = 0, 1016 );

	SDL_GL_GetDrawableSize( mainWindow, Fwid'access, Fhit'access );
	glViewport(0,0,Fwid,Fhit);

	put_line( "Drawable: Fwid-X-Fhit : "
		&interfaces.c.int'image(Fwid)&" X "
		& interfaces.c.int'image(Fhit) );

	key_map := sdl_getkeyboardstate(numkeys'access);
	--put_line("...numkeys=" & interfaces.c.int'image(numkeys) ); -- 512
	--myassert( sdl.keyrange'last <= numkeys, 1017 );




	glgenvertexarrays(1, vertexarrayid'address );
	glbindvertexarray(vertexarrayid);

	glactivetexture(gl_texture0); -- moved here 5nov14 (outside main loop)

	glgenbuffers(1, vertbuff'address);
	glgenbuffers(1, rgbbuff'address);
	glgenbuffers(1, uvbuff'address);
	glgenbuffers(1, elembuff'address);




	glenable(gl_depth_test);
	gldepthfunc( gl_lequal );
	glenable( gl_cull_face );

	glShadeModel(gl_smooth);



	-- 6nov14  theoretically reduces aliasing (can't tell for sure):
	glEnable(GL_MULTISAMPLE);
	glHint(GL_LINE_SMOOTH_HINT, GL_NICEST);
	glHint(GL_POLYGON_SMOOTH_HINT, GL_NICEST);


	level:=0;
	solved(0):=true;
	solved(5):=false;


end first_prep;




----------- 25feb15 addenda begin ----------------------------

-- size & placement of moving wall-pictures controlled by fancy frag shaders:

x1picX,x1picY,x2picX, x2picY, x3picX,x3picY, x4picX,x4picY 
	: constant float := 0.0;

x2picws : constant float := 3.0; --1.5;
x2pichs : constant float := 1.0; --0.5;

x2picwb : constant float := 3.0; --1.5;
x2pichb : constant float := 1.0; --0.5;


x4picw : constant float := 1.5; -- 2.5; --3.0; (too heavy 18dec15)
x4picH : constant float := 1.0; -- 1.5; --2.0; (too heavy 18dec15)

x1picW, x1picH : constant float := 1.0;

x3picws, x3pichs : constant float := 2.5;
x3picwb, x3pichb : constant float := 2.5;


-- note [original intent of] suffix "b" = big version;  "s" = small version;
-- ...where the small version is a response to extreme graphical burden




procedure release_textures is -- prepare to close down
begin

	glext.binding.glDeleteBuffers(1, vertbuff'address);
	glext.binding.glDeleteBuffers(1, rgbbuff'address);
	glext.binding.glDeleteBuffers(1, uvbuff'address);
	glext.binding.glDeleteBuffers(1, elembuff'address);

	--gldeletetextures(1, worm_texid'address);
	gldeletetextures(1, room_texid'address);
	gldeletetextures(1, pic_texid'address);

	gldeletetextures(1, xbox1_texid'address);
	gldeletetextures(1, xbox2_texid'address);
	gldeletetextures(1, lining_texid'address);
	gldeletetextures(1, barloc0_texid'address);
	gldeletetextures(1, barloc1_texid'address);
	gldeletetextures(1, granite_texid'address);
	gldeletetextures(1, port_texid'address);
	gldeletetextures(1, cubemap_texid'address);
	gldeletetextures(1, circubemap_texid'address);
	gldeletetextures(1, pfish_texid'address);

------- from beach -----------------------------------
	gldeletetextures(1, frek_texid'address);
	gldeletetextures(1, crab_texid'address);
	gldeletetextures(1, star_texid'address);
	gldeletetextures(1, cgrass_texid'address);
	gldeletetextures(1, tgrass_texid'address);
	gldeletetextures(1, bamb_texid'address);
	gldeletetextures(1, palm_texid'address);
	gldeletetextures(1, tpalm_texid'address);
	gldeletetextures(1, pillar1_texid'address);
	gldeletetextures(1, pillar2_texid'address);
	gldeletetextures(1, rock_texid'address);
	gldeletetextures(1, coco_texid'address);
	gldeletetextures(1, island_texid'address);
	gldeletetextures(1, gard_texid'address);
	gldeletetextures(1, nose_texid'address);
	gldeletetextures(1, cpit_texid'address);
	gldeletetextures(1, mfish_texid'address);
	gldeletetextures(1, bfish_texid'address);
	gldeletetextures(1, rfish_texid'address);
	gldeletetextures(1, sfish_texid'address);

	gldeletetextures(1, sos_texid'address);
	gldeletetextures(1, gate0_texid'address);
	gldeletetextures(1, gate_texid'address);
	gldeletetextures(1, pillar1_texid'address);
	gldeletetextures(1, pillar2_texid'address);
	gldeletetextures(1, dhd0_texid'address);
	gldeletetextures(1, dhd1_texid'address);
	gldeletetextures(1, dhd2_texid'address);
	gldeletetextures(1, dhd3_texid'address);
	gldeletetextures(1, dhd4_texid'address);
	gldeletetextures(1, adobe_texid'address);
	gldeletetextures(1, wood_texid'address);
	gldeletetextures(1, woodt_texid'address);
	gldeletetextures(1, woodw_texid'address);
	gldeletetextures(1, brick_texid'address);

	gldeletetextures(1, tropical_cubemap_texid'address);
	gldeletetextures(1, blue_cubemap_texid'address);
	gldeletetextures(1, moon_cubemap_texid'address);
	gldeletetextures(1, sunset_cubemap_texid'address);
	gldeletetextures(1, sargas_cubemap_texid'address);

	glext.binding.glDeleteProgram( mpidSkyB );
	glext.binding.glDeleteProgram( mpidSkyW );
	glext.binding.glDeleteProgram( fishTexShadID );
	glext.binding.glDeleteProgram( crabTexShadID );

	glext.binding.glDeleteProgram( mystnontexshadid );
	glext.binding.glDeleteProgram( mystpgmtexshadid );
	glext.binding.glDeleteProgram( gatetexshadid );
	glext.binding.glDeleteProgram( rocktexshadid );
	glext.binding.glDeleteProgram( palmtexshadid );
	glext.binding.glDeleteProgram( nosetexshadid );
	glext.binding.glDeleteProgram( cpittexshadid );
---------- end from beach --------------------------------

	glext.binding.glDeleteProgram( pidskyb );
	glext.binding.glDeleteProgram( pidskyw );
	glext.binding.glDeleteProgram( nontexshadid );
	glext.binding.glDeleteProgram( starshadid );
	glext.binding.glDeleteProgram( poolshadid );
	glext.binding.glDeleteProgram( dpoolshadid );
	glext.binding.glDeleteProgram( lpoolshadid );
	glext.binding.glDeleteProgram( rpoolshadid );
	glext.binding.glDeleteProgram( pgmtexshadid );

	glext.binding.glDeleteVertexArrays(1, vertexarrayid'address);

end release_textures;



procedure setup_textures is  -- prepare dungeon textures
begin 

	--cartoon palmTree
	x1picshadid := loadshaders("data/picZ.vs", "data/palmTreeWindmill.fs");
	x1pictimeid := glgetuniformlocation(x1picshadid, ptime);
	x1picresid  := glgetuniformlocation(x1picshadid, presol);
	x1picmatid  := glgetuniformlocation(x1picshadid, pmvp);
	x1picradid  := glgetuniformlocation(x1picshadid, pwRad);
	x1piccenid  := glgetuniformlocation(x1picshadid, pwPos);
	--------------------------------------------------------------


	--waterworld
	x2picshadid := loadshaders("data/picZ.vs", "data/waterworldCCNCSA3.fs");
	x2pictimeid := glgetuniformlocation(x2picshadid, ptime);
	x2picresid  := glgetuniformlocation(x2picshadid, presol);
	x2picmatid  := glgetuniformlocation(x2picshadid, pmvp);
	x2picradid  := glgetuniformlocation(x2picshadid, pwRad);
	x2piccenid  := glgetuniformlocation(x2picshadid, pwPos);
	--------------------------------------------------------------

	--CityNoise
	--x2pic2shadid := loadshaders("data/picZ.vs", "data/cityNoise.fs");

	--mountainscape
	x2pic2shadid := loadshaders("data/picZ.vs", "data/mountainscape.fs");

	x2pic2timeid := glgetuniformlocation(x2pic2shadid, ptime);
	x2pic2resid  := glgetuniformlocation(x2pic2shadid, presol);
	x2pic2matid  := glgetuniformlocation(x2pic2shadid, pmvp);
	x2pic2radid  := glgetuniformlocation(x2pic2shadid, pwRad);
	x2pic2cenid  := glgetuniformlocation(x2pic2shadid, pwPos);
	--------------------------------------------------------------


	--DaliClock
	x3picshadid := loadshaders("data/picZ.vs", "data/bwClock.fs");

	x3pictimeid := glgetuniformlocation(x3picshadid, ptime);
	x3picresid  := glgetuniformlocation(x3picshadid, presol);
	x3picmatid  := glgetuniformlocation(x3picshadid, pmvp);
	x3picradid  := glgetuniformlocation(x3picshadid, pwRad);
	x3piccenid  := glgetuniformlocation(x3picshadid, pwPos);
	--------------------------------------------------------------


	--MagmaPlanet
	x3pic2shadid := loadshaders("data/picZ.vs", "data/redPlanet.fs");
	x3pic2timeid := glgetuniformlocation(x3pic2shadid, ptime);
	x3pic2resid  := glgetuniformlocation(x3pic2shadid, presol);
	x3pic2matid  := glgetuniformlocation(x3pic2shadid, pmvp);
	x3pic2radid  := glgetuniformlocation(x3pic2shadid, pwRad);
	x3pic2cenid  := glgetuniformlocation(x3pic2shadid, pwPos);
	--------------------------------------------------------------

	--spinning Galaxy
	x4picshadid := loadshaders("data/picZ.vs", "data/blueSpiral.fs");
	x4pictimeid := glgetuniformlocation(x4picshadid, ptime);
	x4picresid  := glgetuniformlocation(x4picshadid, presol);
	x4picmatid  := glgetuniformlocation(x4picshadid, pmvp);
	x4picradid  := glgetuniformlocation(x4picshadid, pwRad);
	x4piccenid  := glgetuniformlocation(x4picshadid, pwPos);
	--------------------------------------------------------------


-------------------- 25feb15 addenda end ---------------------------


	nontexshadid := loadshaders("./data/nontex.vs", "./data/nontex.fs");
	ntmatrixid := glgetuniformlocation(nontexshadid, pmvp);


	--to Island:

	-- heavy
	--tunshadid3 := loadshaders("./data/tunnelstars.vs", "./data/cloudsInSpace.fs");
	-- awesome swirling space clouds

	-- back to Island:
	tunshadid3 := loadshaders("./data/tunnelstars.vs", "./data/tunnelstars.fs");
	-- great rotating star universe;  a lost-in-space feel (not a wormhole feel).

	-- dungeon local:
	--tunshadid2 := loadshaders("./data/tunnelstars.vs", "./data/myspiral.fs");
	-- very nice too;  great lightweight color spiral but no stars

	-- from Island:
	tunshadid1 := loadshaders("./data/tunnelstars.vs", "./data/mystartunnel.fs");
	-- forward thru a rotating colored star tunnel with wormhole feel.

	-- dungeon local:
	tunshadid2 := loadshaders("./data/tunnelstars.vs", "./data/myswiss2.fs");
	-- forward thru a rotating swiss cheese cavern
	-- awesome, but graphically heavier than myspiral.fs


	tuntimeid1 := glgetuniformlocation(tunshadid1, ptime); -- need glint
	tunresid1  := glgetuniformlocation(tunshadid1, presol);
	tunmatid1  := glgetuniformlocation(tunshadid1, pmvp);

	tuntimeid2 := glgetuniformlocation(tunshadid2, ptime);
	tunresid2  := glgetuniformlocation(tunshadid2, presol);
	tunmatid2  := glgetuniformlocation(tunshadid2, pmvp);

	tuntimeid3 := glgetuniformlocation(tunshadid3, ptime);
	tunresid3  := glgetuniformlocation(tunshadid3, presol);
	tunmatid3  := glgetuniformlocation(tunshadid3, pmvp);





	starshadid := loadshaders("./data/skyX.vs", "./data/starfield3.fs"); --gluint
	startimeid := glgetuniformlocation(starshadid, ptime); -- need glint
	starresid  := glgetuniformlocation(starshadid, presol);
	starmatid  := glgetuniformlocation(starshadid, pmvp);



	fishtexshadid := loadshaders("./data/fishw.vs","./data/fish.fs");
	fishmatrixid := glgetuniformlocation(fishtexshadid, pmvp);
	fishuniftex  := glgetuniformlocation(fishtexshadid, pmyts);
	fishuniftime := glgetuniformlocation(fishtexshadid, pmytime);
	fcenid       := glgetuniformlocation(fishtexshadid, pwPos);
	fishunifrad  := glGetUniformLocation( fishTexShadID, prad );     
	fishunifsvel := glGetUniformLocation( fishTexShadID, psvel );     
	fishunifwvel := glGetUniformLocation( fishTexShadID, pwvel );     
	fishunifwamp := glGetUniformLocation( fishTexShadID, pwamp );



	poolshadid := loadshaders("./data/poolobjFog.vs","./data/myBlueWaterFog.fs");
	poolmvid := glgetuniformlocation(poolshadid, pmv);
	poolmatid := glgetuniformlocation(poolshadid, pmvp);
	timeid    := glgetuniformlocation(poolshadid, pmytime);
	wlevid    := glgetuniformlocation(poolshadid, pwaterlevel);
	pradid    := glgetuniformlocation(poolshadid, pwRad);
	pcenid    := glgetuniformlocation(poolshadid, pwPos);

	dpoolshadid := loadshaders("./data/poolobjFog.vs","./data/darkwater3Fog.fs");
	dpoolmvid := glgetuniformlocation(dpoolshadid, pmv);
	dpoolmatid := glgetuniformlocation(dpoolshadid, pmvp);
	dtimeid    := glgetuniformlocation(dpoolshadid, pmytime);
	dwlevid    := glgetuniformlocation(dpoolshadid, pwaterlevel);
	dpradid    := glgetuniformlocation(dpoolshadid, pwRad);
	dpcenid    := glgetuniformlocation(dpoolshadid, pwPos);


	lpoolshadid := loadshaders("./data/lavaFog.vs", "./data/volcanoFog.fs");
	lpoolmvid := glgetuniformlocation(lpoolshadid, pmv);
	lpoolmatid := glgetuniformlocation(lpoolshadid, pmvp);
	lresid  := glgetuniformlocation(lpoolshadid, presol);
	ltimeid := glgetuniformlocation(lpoolshadid, pmytime);
	lwlevid := glgetuniformlocation(lpoolshadid, pwaterlevel);
	lpradid := glgetuniformlocation(lpoolshadid, pwRad);
	lpcenid := glgetuniformlocation(lpoolshadid, pwPos);



	wpgmtexshadid := loadshaders("./data/texobjFog.vs", "./data/texobjFog.fs");
	wmvid := glgetuniformlocation(wpgmtexshadid, pmv);
	wmatrixid := glgetuniformlocation(wpgmtexshadid, pmvp);
	wuniftex  := glgetuniformlocation(wpgmtexshadid, pmyts);



	pgmtexshadid := loadshaders("./data/texobjFog.vs", "./data/texobjFog.fs");
	mvid := glgetuniformlocation(pgmtexshadid, pmv);
	matrixid := glgetuniformlocation(pgmtexshadid, pmvp);
	uniftex  := glgetuniformlocation(pgmtexshadid, pmyts);
	uniflev  := glgetuniformlocation(pgmtexshadid, pmylev);
	unifopac := glgetuniformlocation(pgmtexshadid, popac); --gives capability to reduce opacity


	-- level 2 reflective pool:
	rpoolshadid := loadshaders("./data/lvwater2Fog.vs", "./data/lvwater2Fog.fs");
	envmapid   := glgetuniformlocation(rpoolshadid, penvmap);
	rpeyeid    := glgetuniformlocation(rpoolshadid, peyePos);
	rpoolmvid := glgetuniformlocation(rpoolshadid, pmv);
	rpoolmatid := glgetuniformlocation(rpoolshadid, pmvp);
	rtimeid    := glgetuniformlocation(rpoolshadid, pmytime);
	rwlevid    := glgetuniformlocation(rpoolshadid, pwaterlevel);
	rpradid    := glgetuniformlocation(rpoolshadid, pwRad);
	rpcenid    := glgetuniformlocation(rpoolshadid, pwPos);

	-- level 2 reflective pool;  
	-- Here, only used as reflective environment, but not drawn.
	-- ...in this case, a close match to actual environment...
	cubemap_texid := loadCubePng(
	"data/woodenceiling2.png",	"data/woodenceiling2.png",
	"data/grungeRGBA.png",	   "data/grungeRGBA.png",
	"data/woodenceiling2.png", "data/grungeRGBA.png");



------ begin level 5 epilog setup ----------------------------------------------

	-- pretty awesome:
	-- used as reflective environment, but also drawn
	circubemap_texid := loadCubePng(
	"data/skyBoxes/totality/ft.png",	"data/skyBoxes/totality/bk.png",
	"data/skyBoxes/totality/upmsg.png",	"data/skyBoxes/totality/dn.png",
	"data/skyBoxes/totality/rt.png",	"data/skyBoxes/totality/lf.png"	);


	pidskyb := loadshaders("./data/osky.vs", "./data/osky.fs");
	sbmvpuid := glgetuniformlocation(pidskyb, pmvp);
	sbmapuid := glgetuniformlocation(pidskyb, pcubemap);

	pidskyw := loadshaders("./data/sundown4.vs", "./data/sundown.fs");
	cmvpuid  := glgetuniformlocation(pidskyw, pmvp);
	cemuid   := glgetuniformlocation(pidskyw, penvMap);
	ctimeid  := glgetuniformlocation(pidskyw, pmytime);
	cwlevid  := glgetuniformlocation(pidskyw, pwaterlevel);
	cpradid  := glgetuniformlocation(pidskyw, pwRad);
	cpcenid  := glgetuniformlocation(pidskyw, pwPos);
	cpeyeid  := glgetuniformlocation(pidskyw, peyePos);

------ end level 5 epilog setup ------------------------------------------------



-- load textures used in all levels:

	-- comment this out for black:
	--worm_texid := loadPng(mirror,"data/bloodymaryRGBA.png"); --

	lining_texid := loadPng(mirror,"data/bricksr.png");

	sok_texid := loadPng(mirror,"data/granitergb.png");

	port_texid := loadPng(mirror,"data/stargate_half.png");
	offport_texid := loadPng(mirror,"data/stargate_half_off.png");
	xbox1_texid := loadPng(mirror,"data/illusion2.png");
	xbox2_texid := loadPng(mirror,"data/door.png");
	barloc0_texid:= loadPng(mirror,"data/stargate_off.png");
	barloc1_texid:= loadPng(mirror,"data/stargate_texture.png");

	granite_texid  := loadPng(mirror,"data/granitergb.png");
	grunge_texid := loadPng(mirror,"data/grungeRGBA.png");

	bricksw_texid  := loadPng(mirror,"data/bricksq.png");
	woodw_texid := loadPng(mirror,"data/woodenceilingW.png");
	woodt_texid := loadPng(mirror,"data/woodenceilingT.png");


	adobe_texid := loadPng(mirror,"data/wallT.png"); 
	--dark, contrasting adobe

	pfish_texid  := loadPng(mirror,"data/p1.png");

	-- ...and these 3 others are loaded dynamically (per level):
	-- room_texid,  pic_texid, ceil_texid


end setup_textures; ------------------------------------------------------------






	completed, details : boolean := false;
	dt : float;


---------------------------------- main program begin ==========================
begin --adagate

	new_line;
	new_line;
	put_line("Please be patient...AdaGate is slow to load...");
	new_line;
	new_line;



	first_prep;  -- main program setup

	SDL_PumpEvents; -- this precludes a Gnome "app-not-responding" dialog

	setup_textures; -- prep dungeon textures

	-- I hope this one is enough:
	SDL_PumpEvents; -- this precludes a Gnome "app-not-responding" dialog

	island_texture_setup; 

	updateMVP( float(winwidth), float(winheight) );

	SDL_PumpEvents; -- this precludes a Gnome "app-not-responding" dialog


	level:=0;
	solved(0):=true;
	solved(5):=false; -- false until epilog is visited


	-- main event loop begin: -----------------------------------------------
   while not userexit and not lavadead	loop



		if (level<5) and solved(level) then --prepare new level



			if level>0 then
				gldeletetextures(1, room_texid'address);
			end if;

			if level=1 then 
				gldeletetextures(1, ceil_texid'address); 
			end if;

			if (level=1) or (level=4) then 
				gldeletetextures(1, pic_texid'address);
			end if;

			snd4ada_hpp.stopSnd;



			portalenabled:=false;
			lport_located:=false;
			rport_located:=false;
			lport_stable:=false;
			rport_stable:=false;
			worm_defined:=false;
			worm_active:=false;
			first_worm_active:=false;
			xit:=false;
			exitwait:=false;


			nko:=0;
			pko:=0;



			--level:=0; 21mar16
			xme:=0.0; yme:=0.0; zme:=0.0;  
			-- beach uses alternate paradigm Yeye = sandHt + eyeht
			-- whereas dungeons default  Yeye = -ymax + aheight

			-- play Xport if returning from dungeon:
			if level > 0 then snd4ada_hpp.playSnd(8); end if; -- 21mar16

			level := island_ftn(dbug); -- island-nexus (returns 1..5)
			vertang:=0.0;
			horiang:=0.0;


			-- careful, these now used within island_ftn for rocks
			nko:=0;
			pko:=0;



			if( (level>=1) and (level<=mxlev) ) then 
			-- take care of sokwalls, barrels, receptacles here


				readPuzzle(level); --sokoban data


				-- setup sokoban arena:
				ib:=0;
				ir:=0;
				for row in 1..nrows loop
				for col in 1..ncols loop
					fcol:=float(col);
					frow:=float(row);
					
					xc:= xorigin(level)+1.0-2.0*(0.5+fcol)*rolldist*0.5; 
					ycb:=-ymax+barr;
					yrw:=barr;
					ycw:=-ymax+yrw;
					zc:= zorigin(level)+1.0-2.0*(0.5+frow)*rolldist*0.5;

					if( wall(row,col) = true ) then

						nko:=nko+1;
						rectobj.setrect( sokwall(row,col), xc,ycw,zc,
							rolldist*0.5, yrw, rolldist*0.5,      -- xrad,yrad,zrad
							koxlo(nko),koxhi(nko), koylo(nko),
							koyhi(nko), kozlo(nko),kozhi(nko) );
					end if;

					if( rcpt(row,col) = true ) then
						ir:=ir+1;
						recept(ir)(1):= xc;
						recept(ir)(2):= -ymax;
						recept(ir)(3):= zc;

						pictobj.setrect(sokrcpt(row,col),
							recept(ir)(1), recept(ir)(2), recept(ir)(3),
							barr,0.01,barr,
							xm,xp,ym,yp,zm,zp ); --discard
					end if;

					if( barl(row,col) = true ) then
						ib:=ib+1;
						posbar(ib)(1):= xc;
						posbar(ib)(2):= ycb;
						posbar(ib)(3):= zc;

						cyl2obj.setcyl2(barrel(ib), 
							posbar(ib)(1), posbar(ib)(2), posbar(ib)(3), barr);

					end if;

				end loop;
				end loop;


			end if; -- 1 <= level <= 4




			if (level=1) then  -- nonreflective blue water


				pzlo:=-16.0; pzhi:=0.0;

				--xpcen:=0.0;  zpcen:=0.5*(pzhi+pzlo);  ypcen:=-ymax-margin;
				xpcen:=0.0;  zpcen:=0.5*(pzhi+pzlo);  ypcen:=-ymax+margin;
				xprad:=xmax; zprad:=0.5*(pzhi-pzlo);  yprad:=margin;
				waterlevel:= ypcen + yprad/2.0;

				mroomobj.setroomwithfloorgap( rmo, 0.125, 0.125, 0.125,
					pzlo,pzhi,  0.0,0.0,0.0, xmax,ymax,zmax);--10,3,20
				room_texid := loadPng(mirror,"data/myadobeT.png"); 
				rectsurf.setrect(rso,
					xpcen, zpcen, xprad, zprad); --normal water in gap
				nko:=nko+1;
				koxlo(nko):=xpcen-xprad;
				koxhi(nko):=xpcen+xprad;
				koylo(nko):=-ymax;
				koyhi(nko):=+ymax;
				kozlo(nko):=zpcen-zprad;
				kozhi(nko):=zpcen+zprad;
				pko:=nko; -- identify pool KO...does NOT obstruct portal gun

		fishx:=0.0;             --center of swim circle
		fishy:=waterlevel-0.10; --lower due to big waves...cuts off bottom fish
		fishz:=0.5*(pzlo+pzhi);
		fishr:=0.40*(pzhi-pzlo); --radius of swim circle
		fishs:=1.0;  -- swim speed
		fdx:=0.00001;
		fdy:=0.06;  -- fish size
		fdz:=0.24;
		myfish.setrect(pdfish, fdx,fdy,fdz);


				-- begin brick lining of pool
				rectobj.setrect(pxp, 
					xmax,ypcen,zpcen, 
					2.0*margin, yprad+0.15, zprad, 
					xm,xp,ym,yp,zm,zp);

				rectobj.setrect(pxm,
					-xmax,ypcen,zpcen, 
					2.0*margin, yprad+0.15, zprad, 
					xm,xp,ym,yp,zm,zp);

				rectobj.setrect(pzp,  
					0.0,ypcen,  pzhi, 
					xprad, yprad+0.1, 2.0*margin, 
					xm,xp,ym,yp,zm,zp);

				rectobj.setrect(pzm,  
					0.0,ypcen,  pzlo, 
					xprad, yprad+0.1, 2.0*margin, 
					xm,xp,ym,yp,zm,zp);

				rectobj.setrect(pym,  
					0.0,ypcen-yprad,zpcen, 
					xprad, yprad/2.0, zprad, 
					xm,xp,ym,yp,zm,zp);



				snd4ada_hpp.playWater;
				snd4ada_hpp.playSnd(1); -- among-the-falls
				snd4ada_hpp.playSnd(8); --Xport



				-- ledge
				xc:=+0.75*xmax;
				yc:=-ymax/2.0;
				zc:=+0.50*zmax;
				xr:=+0.25*xmax;
				yr:=+ymax/2.0;
				zr:=+2.00;
				nko:=nko+1;
				rectobj.setrect(ledge,xc,yc,zc, xr,yr,zr, 
					koxlo(nko),	koxhi(nko),	koylo(nko),	
					koyhi(nko),	kozlo(nko),	kozhi(nko) );


-- begin define entry onto ledge ------------------------------------------------
				-- initial position:

			vertang := 0.0;
			horiang:=-halfpi; -- look toward puzzle
			xlook := fmath.cos(vertang)*fmath.sin(horiang);
			ylook := fmath.sin(vertang);
			zlook := fmath.cos(vertang)*fmath.cos(horiang);

				xme:= xc;
				yme := yc+yr+aheight;
				zme:= zc;

				-- entry by falling from roof [over ledge] after island stargate
				pyjump:=yme;
				vyjump:=0.0;
				jumptime:= float(sdl_getticks)/1000.0;
				jumping:=true;
				pauseatlevelchange:=true;

-- end define entry onto ledge ------------------------------------------------



				-- ceiling (thatched)
				xc:=0.0;
				yc:=ymax-0.01;
				zc:=0.0;
				xr:=xmax;
				yr:=0.01;
				zr:=zmax;
				nko:=nko+1;
				rectobj.setrect(ceil2, xc,yc,zc, xr,yr,zr, 
					koxlo(nko),	koxhi(nko),	koylo(nko),	
					koyhi(nko),	kozlo(nko),	kozhi(nko) );

				ceil_texid := loadPng(mirror,"data/roof1t.png"); 
				-- great thatched roof!


				-- wall picture (ZPM diagram)
				xc:=0.0;
				yc:=0.0;
				zc:=zmax-0.01;
				xr:=2.0;
				yr:=2.0;
				zr:=0.01;
				nko:=nko+1;
				pictobj.setrect(pic,  xc,yc,zc, xr,yr,zr, 
					koxlo(nko),	koxhi(nko),	koylo(nko),	
					koyhi(nko),	kozlo(nko),	kozhi(nko) );

				pic_texid := loadPng(mirror,"data/zpmtr.png");



				rectxobj.setrect(pox,x1picX,x1picY,-zmax+0.01, x1picw,x1pich,0.01); 
				--movingpic (cartoon palm tree)



				xc:=-xmax+2.0;
				yc:=-ymax+1.0;
				zc:=-zmax+2.0;
				xr:=1.0;
				yr:=1.0;
				zr:=1.0;
				xboxpos(1):=xc;
				xboxpos(2):=yc;
				xboxpos(3):=zc;
				nko:=nko+1;
				rectobj.setrect(xbox, xc,yc,zc, xr,yr,zr, 
					koxlo(nko),	koxhi(nko),	koylo(nko),	
					koyhi(nko),	kozlo(nko),	kozhi(nko) );
				-- use xbox1_texid, then xbox2_texid


				-- block wall partition
				xc:=-0.5*xmax;
				yc:=-1.0;
				zc:=0.0;
				xr:=0.5*xmax;
				yr:=ymax-1.0;
				zr:=0.1;
				nko:=nko+1;
				rectobj.setrect(bloc, xc,yc,zc, xr,yr,zr, 
					koxlo(nko),	koxhi(nko),	koylo(nko),	
					koyhi(nko),	kozlo(nko),	kozhi(nko) );

myassert( nko <= maxnko, 1018 );


			elsif (level=2) then  -- reflective clear water

				pzlo:= 3.0; pzhi:=zmax-4.0;

				xpcen:=0.0;  zpcen:=0.5*(pzhi+pzlo);  ypcen:=-ymax-margin;
				xprad:=xmax; zprad:=0.5*(pzhi-pzlo);  yprad:=margin;
				waterlevel:= ypcen + yprad/2.0;

				mroomobj.setroomwithfloorgap( rmo,  0.25, 0.25, 0.25,
					pzlo,pzhi,  0.0,0.0,0.0, xmax,ymax,zmax);--10,3,20
				room_texid := loadPng(mirror,"data/woodenceilingW.png");
				reflsurf.setrect(rfo,
					xpcen, zpcen, xprad, zprad); --reflective water in gap
				nko:=nko+1;
				koxlo(nko):=xpcen-xprad;
				koxhi(nko):=xpcen+xprad;
				koylo(nko):=-ymax;
				koyhi(nko):=+ymax;
				kozlo(nko):=zpcen-zprad;
				kozhi(nko):=zpcen+zprad;
				pko:=nko; -- identify pool KO...does NOT obstruct portal gun

		fishx:=0.0;
		fishy:=waterlevel-0.06; --center of swim circle
		fishz:=0.5*(pzlo+pzhi);
		fishr:=0.40*(pzhi-pzlo); --radius of swim circle
		fishs:=1.0;  -- swim speed
		fdx:=0.00001;
		fdy:=0.06;  -- fish size
		fdz:=0.24;
		myfish.setrect(pdfish, fdx,fdy,fdz);


				-- begin brick lining of pool
				rectobj.setrect(pxp, 
					xmax,ypcen,zpcen, 
					2.0*margin, yprad+0.15, zprad, 
					xm,xp,ym,yp,zm,zp);

				rectobj.setrect(pxm,
					-xmax,ypcen,zpcen, 
					2.0*margin, yprad+0.15, zprad, 
					xm,xp,ym,yp,zm,zp);

				rectobj.setrect(pzp,  
					0.0,ypcen,  pzhi, 
					xprad, yprad+0.1, 2.0*margin, 
					xm,xp,ym,yp,zm,zp);

				rectobj.setrect(pzm,  
					0.0,ypcen,  pzlo, 
					xprad, yprad+0.1, 2.0*margin, 
					xm,xp,ym,yp,zm,zp);

				rectobj.setrect(pym,  
					0.0,ypcen-yprad,zpcen, 
					xprad, yprad/2.0, zprad, 
					xm,xp,ym,yp,zm,zp);


				snd4ada_hpp.playWater;
				snd4ada_hpp.playSnd(2); --dark-metal
				snd4ada_hpp.playSnd(8); --Xport


				xc:=+0.5*xmax;
				yc:=-0.25;
				zc:= 0.0;
				xr:= 0.5*xmax;
				yr:= 0.25;
				zr:=+2.00;
				nko:=nko+1;
				rectobj.setrect(ledge,xc,yc,zc, xr,yr,zr, 
					koxlo(nko),	koxhi(nko),	koylo(nko),	
					koyhi(nko),	kozlo(nko),	kozhi(nko) );


-- begin define entry onto ledge -----------------------------------------------

			-- initial position:
			xme:= xc;
			yme := yc+yr+aheight;
			zme:= zc;

			horiang:=-halfpi; --twopi;
			vertang := 0.0;
			xlook := fmath.cos(vertang)*fmath.sin(horiang);
			ylook := fmath.sin(vertang);
			zlook := fmath.cos(vertang)*fmath.cos(horiang);


						-- entry by falling from roof [over ledge] after island stargate
			pyjump:=yme;
			vyjump:=0.0;
			jumptime:= float(sdl_getticks)/1000.0;
			jumping:=true;
			pauseatlevelchange:=true;

-- end define entry onto ledge ------------------------------------------------


				-- pool wall (+zmax):
				rectxobj.setrect(pox2,
					x2picX,x2picY,+zmax-0.01, x2picws,x2pichs,0.01); 
				--movingpic (pox2=>mountainscape)

				-- puzzle wall (-zmax):
				rectxobj.setrect(pox,
					x2picX,x2picY,-zmax+0.01, x2picwb,x2pichb,0.01); 
				--movingpic (pox=>waterworld)


				-- ceiling (bluish grunge to show off water)
				xc:=0.0;
				yc:=ymax-0.01;
				zc:=0.0;
				xr:=xmax;
				yr:=0.01;
				zr:=zmax;
				nko:=nko+1;
				pictobj.setrect(ceil, xc,yc,zc, xr,yr,zr, 
					koxlo(nko),	koxhi(nko),	koylo(nko),	
					koyhi(nko),	kozlo(nko),	kozhi(nko) );



				xc:=+xmax/2.0;
				yc:=-ymax+1.0;
				zc:=+zmax-2.0;
				xr:=1.0;
				yr:=1.0;
				zr:=1.0;
				xboxpos(1):=xc;
				xboxpos(2):=yc;
				xboxpos(3):=zc;
				nko:=nko+1;
				rectobj.setrect(xbox, xc,yc,zc, xr,yr,zr, 
					koxlo(nko),	koxhi(nko),	koylo(nko),	
					koyhi(nko),	kozlo(nko),	kozhi(nko) );
				-- use xbox1_texid, then xbox2_texid

				-- partition wall
				xc:=-0.0;
				yc:=-0.49*ymax;
				zc:=+2.0;
				xr:=xmax;
				yr:=0.51*ymax;
				zr:=0.1;
				nko:=nko+1;
				pictobj.setrect(bloc2, xc,yc,zc, xr,yr,zr, 
					koxlo(nko),	koxhi(nko),	koylo(nko),	
					koyhi(nko),	kozlo(nko),	kozhi(nko) );

myassert( nko <= maxnko, 1019 );





			elsif (level=3) then -- lavapool


				pzlo:= 3.0; pzhi:=zmax-4.0;

				xpcen:=0.0;  zpcen:=0.5*(pzhi+pzlo);  ypcen:=-ymax-margin;
				xprad:=xmax; zprad:=0.5*(pzhi-pzlo);  yprad:=margin;
				waterlevel:= ypcen + yprad/2.0;

				mroomobj.setroomwithfloorgap( rmo,  0.25, 0.25, 0.25,
					pzlo,pzhi,  0.0,0.0,0.0, xmax,ymax,zmax);--10,3,20

				room_texid := loadPng(mirror,"data/bricksr.png");

				--NOTE:  all 3 work here...a) reflsurfobj, 
				--			b)finesurfobj, c)rectsurfobj.
				--       which proves they all work.
				finesurf.setrect(fso,xpcen, zpcen, xprad, zprad); --lava in gap
				nko:=nko+1;
				koxlo(nko):=xpcen-xprad;
				koxhi(nko):=xpcen+xprad;
				koylo(nko):=-ymax;
				koyhi(nko):=+ymax;
				kozlo(nko):=zpcen-zprad;
				kozhi(nko):=zpcen+zprad;
				pko:=nko; -- identify pool KO...does NOT obstruct portal gun


				-- begin brick lining of pool
				rectobj.setrect(pxp, 
					xmax,ypcen,zpcen, 
					2.0*margin, yprad+0.15, zprad, 
					xm,xp,ym,yp,zm,zp);

				rectobj.setrect(pxm,
					-xmax,ypcen,zpcen, 
					2.0*margin, yprad+0.15, zprad, 
					xm,xp,ym,yp,zm,zp);

				rectobj.setrect(pzp,  
					0.0,ypcen,  pzhi, 
					xprad, yprad+0.1, 2.0*margin, 
					xm,xp,ym,yp,zm,zp);

				rectobj.setrect(pzm,  
					0.0,ypcen,  pzlo, 
					xprad, yprad+0.1, 2.0*margin, 
					xm,xp,ym,yp,zm,zp);

				rectobj.setrect(pym,  
					0.0,ypcen-yprad,zpcen, 
					xprad, yprad/2.0, zprad, 
					xm,xp,ym,yp,zm,zp);



				snd4ada_hpp.playLava;
				snd4ada_hpp.playSnd(3); --gothic-dutch
				snd4ada_hpp.playSnd(8); --Xport


				-- wooden ledge
				xc:=+0.5*xmax;
				yc:=-0.25;
				zc:= 0.0;
				xr:= 0.5*xmax;
				yr:= 0.25;
				zr:=+2.00;
				nko:=nko+1;
				rectobj.setrect(ledge,xc,yc,zc, xr,yr,zr, 
					koxlo(nko),	koxhi(nko),	koylo(nko),	
					koyhi(nko),	kozlo(nko),	kozhi(nko) );


-- begin define entry onto ledge -----------------------------------------------

			vertang := 0.0;
			horiang:= -halfpi; --onepi;
			xlook := fmath.cos(vertang)*fmath.sin(horiang);
			ylook := fmath.sin(vertang);
			zlook := fmath.cos(vertang)*fmath.cos(horiang);


				-- initial position:
				xme:= xc;
				yme := yc+yr+aheight;
				zme:= zc;

				-- entry by falling from roof [over ledge] after island stargate
				pyjump:=yme;
				vyjump:=0.0;
				jumptime:= float(sdl_getticks)/1000.0;
				jumping:=true;
				pauseatlevelchange:=true;

-- end define entry onto ledge ------------------------------------------------


				-- lava pool wall (+zmax):
				rectxobj.setrect(pox,
					x3picX,x3picY,+zmax-0.01, x3picws,x3pichs,0.01); 
				--movingpic (DaliClock)

				-- puzzle wall (-zmax):
				rectxobj.setrect(pox2,
					x3picX,x3picY,-zmax+0.01, x3picwb,x3pichb,0.01); 
				--movingpic (redPlanet)



				xc:=-xmax+2.0;
				yc:=-ymax+1.0;
				zc:=+zmax-2.0;
				xr:=1.0;
				yr:=1.0;
				zr:=1.0;
				xboxpos(1):=xc;
				xboxpos(2):=yc;
				xboxpos(3):=zc;
				nko:=nko+1;
				rectobj.setrect(xbox, xc,yc,zc, xr,yr,zr, 
					koxlo(nko),	koxhi(nko),	koylo(nko),	
					koyhi(nko),	kozlo(nko),	kozhi(nko) );
				-- use xbox1_texid, then xbox2_texid

				-- partition wall
				xc:=0.0;
				yc:=-0.666*ymax;
				zc:=-2.0;
				xr:=xmax;
				yr:=ymax/3.0;
				zr:=0.1;
				nko:=nko+1;
				pictobj.setrect(bloc2, 
					xc,yc,zc, xr,yr,zr, 
					koxlo(nko),	koxhi(nko),	koylo(nko),	
					koyhi(nko),	kozlo(nko),	kozhi(nko) );

myassert( nko <= maxnko, 1020 );




			elsif (level=4) then  -- eerie dark green water



				pzlo:=-16.0; pzhi:=0.0;

				xpcen:=0.0;  zpcen:=0.5*(pzhi+pzlo);  ypcen:=-ymax-margin;
				xprad:=xmax; zprad:=0.5*(pzhi-pzlo);  yprad:=margin;
				waterlevel:= ypcen + yprad/2.0;

				mroomobj.setroomwithfloorgap( rmo,  0.25, 0.25, 0.25,
					pzlo,pzhi, 0.0,0.0,0.0, 
					xmax,ymax,zmax);--10,3,20

				room_texid := loadPng(mirror,"data/granitergb.png");
				rectsurf.setrect(rso,xpcen, zpcen, xprad, zprad);
				nko:=nko+1;
				koxlo(nko):=xpcen-xprad;
				koxhi(nko):=xpcen+xprad;
				koylo(nko):=-ymax;
				koyhi(nko):=+ymax;
				kozlo(nko):=zpcen-zprad;
				kozhi(nko):=zpcen+zprad;
				pko:=nko; -- identify pool KO...does NOT obstruct portal gun

		fishx:=0.0;             --center of swim circle
		fishy:=waterlevel-0.10; --lower due to big waves...cuts off bottom fish
		fishz:=0.5*(pzlo+pzhi);
		fishr:=0.40*(pzhi-pzlo); --radius of swim circle
		fishs:=1.0;  -- swim speed
		fdx:=0.00001;
		fdy:=0.06;  -- fish size
		fdz:=0.24;
		myfish.setrect(pdfish, fdx,fdy,fdz);


				-- begin brick lining of pool
				rectobj.setrect(pxp, 
					xmax,ypcen,zpcen, 
					2.0*margin, yprad+0.15, zprad, 
					xm,xp,ym,yp,zm,zp);

				rectobj.setrect(pxm,
					-xmax,ypcen,zpcen, 
					2.0*margin, yprad+0.15, zprad, 
					xm,xp,ym,yp,zm,zp);

				rectobj.setrect(pzp,  
					0.0,ypcen,  pzhi, 
					xprad, yprad+0.1, 2.0*margin, 
					xm,xp,ym,yp,zm,zp);

				rectobj.setrect(pzm,  
					0.0,ypcen,  pzlo, 
					xprad, yprad+0.1, 2.0*margin, 
					xm,xp,ym,yp,zm,zp);

				rectobj.setrect(pym,  
					0.0,ypcen-yprad,zpcen, 
					xprad, yprad/2.0, zprad, 
					xm,xp,ym,yp,zm,zp);



				snd4ada_hpp.playWater;
				snd4ada_hpp.playSnd(4); --portals-to-neptune
				snd4ada_hpp.playSnd(8); --Xport


				-- ledge
				xc:=-xmax+1.0;
				yc:=-0.25;
				zc:=-zmax+1.0;
				xr:= 2.0;
				yr:= 0.25;
				zr:= 2.0;
				nko:=nko+1;
				rectobj.setrect(ledge,xc,yc,zc, xr,yr,zr, 
				koxlo(nko),	koxhi(nko),	
				koylo(nko),	koyhi(nko),	kozlo(nko),	kozhi(nko) );


			horiang:=onepi;
			vertang:=0.0;
			xlook := fmath.cos(vertang)*fmath.sin(horiang);
			ylook := fmath.sin(vertang);
			zlook := fmath.cos(vertang)*fmath.cos(horiang);

-- begin define entry 
				xme:= 1.0;
				yme := -ymax+aheight;
				zme:=18.0;
-- end define entry



				-- frag shader controls ceiling:
				xc:=0.0;
				yc:=ymax-0.01;
				zc:=0.0;
				xr:=xmax;
				yr:=0.01;
				zr:=zmax;
				rectxobj.setrect(rox,xc,yc,zc, xr,yr,zr); --starceilx
				-- no texture needed here;  fancy fragshader used instead
		

				rectxobj.setrect(pox,x4picX,x4picY,-zmax+0.01, x4picw,x4pich,0.01); 
				--movingpic



				-- uru picture
				xc:=0.0;
				yc:=0.0;
				zc:=zmax-0.01;
				xr:=2.0;
				yr:=2.0;
				zr:=0.01;
				nko:=nko+1;
				pictobj.setrect(pic,  xc,yc,zc, xr,yr,zr, 
				koxlo(nko),	koxhi(nko),	
				koylo(nko),	koyhi(nko),	kozlo(nko),	kozhi(nko) );

				pic_texid := loadPng(mirror,"data/eder.png");

				-- exit cube
				xc:=-xmax+2.0;
				yc:=-ymax+1.0;
				zc:=+zmax-2.0;
				xr:=1.0;
				yr:=1.0;
				zr:=1.0;
				xboxpos(1):=xc;
				xboxpos(2):=yc;
				xboxpos(3):=zc;
				nko:=nko+1;
				rectobj.setrect(xbox, xc,yc,zc, xr,yr,zr, 
				koxlo(nko),	koxhi(nko),	
				koylo(nko),	koyhi(nko),	kozlo(nko),	kozhi(nko) );
				-- use xbox1_texid, then xbox2_texid

				xc:=-3.0;
				yc:= 0.0;
				zc:= zmax/2.0;
				xr:=0.1;
				yr:=ymax;
				zr:=zmax/2.0;
				nko:=nko+1;
				rectobj.setrect(bloc, xc,yc,zc, xr,yr,zr, 
				koxlo(nko),	koxhi(nko),	
				koylo(nko),	koyhi(nko),	kozlo(nko),	kozhi(nko) );

myassert( nko <= maxnko, 1021 );



			elsif (level=5) then  -- epilog


			horiang:=+halfpi;
			vertang:=0.0;
			xlook := fmath.cos(vertang)*fmath.sin(horiang);
			ylook := fmath.sin(vertang);
			zlook := fmath.cos(vertang)*fmath.cos(horiang);


				xme:=0.0;
				yme:=0.0;
				zme:=0.0;

				usboxobj.setrect(usb5, rad5,1.0,rad5);

				circsurf.setround(cir,0.0,0.0,rad5);


				snd4ada_hpp.playWater;
				snd4ada_hpp.playSnd(5); --ChurchChoir
				snd4ada_hpp.playSnd(8); --Xport

			elsif (level>5) then
				myassert( mxlev=4, 1022 );
				put_line("only 4 levels");
				raise program_error;
			end if;




	-- New, narrower tunnel now makes this possible even in level 5, 
	-- however: as written, tunnel requires horiang be a multiple of halfpi
	fromIsland:=true;
	prepwormhole( currenttime, 
		xme-40.0*xlook, yme, zme-40.0*zlook, xme,yme,zme, xme,zme);





		end if; -- new level prep ###########################################




	-- main event loop middle: -----------------------------------------------

------- begin response to user inputs //////////////////////////////////////////

		currentTime := float(sdl_getticks)/1000.0;


		SDL_PumpEvents;


		-- these are only 2 keyboard responses needed in level=5 (epilogue)
		if( key_map( SDL_SCANCODE_ESCAPE ) /= 0 ) then userexit:=true; end if;
		if( key_map( SDL_SCANCODE_Q ) /= 0 ) then userexit:=true; end if;



if not worming then



		if( level < 5 ) then

			if(      key_map( SDL_SCANCODE_UP     )  /= 0 ) then 
				moveForward(currentTime);
			elsif( key_map( SDL_SCANCODE_DOWN   )  /= 0 ) then 
				moveBackward(currentTime);
         
			elsif( key_map( SDL_SCANCODE_W )  /= 0 ) then 
				portalEnabled:=true;

			elsif( key_map( SDL_SCANCODE_X )  /= 0 ) then 
				dt := currentTime - dBtnTime;
				if( dt > 0.8 ) then
					details:=not details;
					dBtnTime:=currentTime;
				end if;

			elsif( key_map( SDL_SCANCODE_L )  /= 0 ) then 
				shootLeft(currentTime);
			elsif( key_map( SDL_SCANCODE_R )  /= 0 ) then 
				shootRight(currentTime); 
			end if;

			if( key_map( SDL_SCANCODE_SPACE )  /= 0 ) then
						jumpTime := currentTime;
						pyjump:= yme;
						vyjump:=2.0;
						jumping:=true;
			end if;

-----	///////////////////// begin response to mouse buttons

			MouseState:=SDL_GetMouseState(mousex'access,mousey'access);
			state := integer( MouseState );
			ileft := integer( SDL_BUTTON(1) );
			iright:= integer( SDL_BUTTON(3) );
			if    bitmatch(state, ileft)   then 
				shootLeft(currentTime);
			elsif bitmatch(state, iright)  then 
				shootRight(currentTime);
			end if;


		end if; -- level<5




		deltaT := currentTime - oldTimeKb;

		if( key_map( SDL_SCANCODE_LEFT )  /= 0 ) then
			roty := +0.5*deltaT;
			horiang := horiang + roty;
			roty:=0.0;
			xlook := fmath.cos(vertang)*fmath.sin(horiang);
			ylook := fmath.sin(vertang);
			zlook := fmath.cos(vertang)*fmath.cos(horiang);

		elsif( key_map( SDL_SCANCODE_RIGHT )  /= 0 ) then
			roty := -0.5*deltaT;
			horiang := horiang + roty;
			roty:=0.0;
			xlook := fmath.cos(vertang)*fmath.sin(horiang);
			ylook := fmath.sin(vertang);
			zlook := fmath.cos(vertang)*fmath.cos(horiang);

		end if;


------ begin mouse drag -------------------------------------------
		handle_mouse_drag(currentTime);
------ end mouse drag -------------------------------------------


----------- begin game controller ---------------------------------
	if joystik or gamepad then

		-- axis values in [-32768...+32767]

		-- JS: 2nd Axis parm:  0..2
		-- GC: 2nd Axis parm:  0..3

		-- unresolved question:  how do I prevent spinning @ startup?

		axis_lx := SDL_JoystickGetAxis(jsa, 0);
		axis_ly := SDL_JoystickGetAxis(jsa, 1);
		handle_gc_left(axis_lx,axis_ly);

		if gamepad then -- these handle move forward/backward
			axis_rx := SDL_JoystickGetAxis(jsa, 2);
			axis_ry := SDL_JoystickGetAxis(jsa, 3);
			handle_gc_right(currentTime,axis_rx,axis_ry);
		end if;

		-- now for the buttons:

		-- 1 => pressed,  0 => not pressed
		-- JS: 2nd Btn parm:  0..7
		-- GC: 2nd Btn parm:  0..11

		zeroBtns; -- set btns 0..8 to zero
		if gamepad then
			btn_4 := SDL_JoystickGetButton(jsa,gshtl); -- shootLeft(LtShoulder)
			btn_5 := SDL_JoystickGetButton(jsa,gshtr); -- shootRight(RtShoulder)
			btn_8 := SDL_JoystickGetButton(jsa,gjmp); -- jump
		elsif joystik then
			btn_0 := SDL_JoystickGetButton(jsa,jbak); -- moveBackward(trigger)
			btn_1 := SDL_JoystickGetButton(jsa,jfor); -- moveForward(thumb)
			btn_2 := SDL_JoystickGetButton(jsa,jshtl); -- shootLeft(thumb)
			btn_3 := SDL_JoystickGetButton(jsa,jshtr); -- shootRight(thumb)
			btn_7 := SDL_JoystickGetButton(jsa,jjmp); -- jump
		end if;

		if btn_7>0 or btn_8>0 then
			jumpTime := currentTime;
			pyjump:= yme;
			vyjump:=2.0;
			jumping:=true;
		end if;

		if btn_4>0 or btn_2>0 then 
			shootLeft(currentTime); 
		end if;

		if btn_5>0 or btn_3>0 then 
			shootRight(currentTime); 
		end if;

		if joystik then
			if    btn_0>0 then -- JS.trigger
				moveBackward(currentTime);
			elsif btn_1>0 then -- JS.thumb
				moveForward(currentTime);
			end if;
		end if;

	end if; --joystik or gamepad
----------- end game controller ---------------------------------

----///////////////////// end response to user inputs //////////////////////////


else -- worming
	vertang:=0.0;
	worm(currenttime, xme,yme,zme, worming);
end if; -- not worming




		updateMVP( float(winwidth), float(winheight) );	-- use mvp(1,1)'address

		if level<5 then
			updategamestate( currentTime );
		end if;

		foldtime:=currenttime;
		boldtime:=currenttime;
		oldTimeKb := currentTime; --prepare for next time





--------- begin drawing ========================================================

	glClear(GL_COLOR_BUFFER_BIT or GL_DEPTH_BUFFER_BIT);


	-- 5pgs to end if:
	if level<5 then  -- in-a-dungeon with many textured objects in common


		--draw barrels
		glUseProgram(nontexshadid);

		for i in 1..nbarrels loop

			bmvp := mvp;

			if rolling(i) then
				barreltime := float(sdl_getticks)/1000.0;
				tt := float( barreltime - timeofroll ) / secperroll;
				barangle := onepi*tt*rad2deg;

				if( tt<1.0 ) then
					posbar(i)(1):=olbarrl(1)+tt*(nubarrl(1)-olbarrl(1));
					posbar(i)(2):=olbarrl(2)+tt*(nubarrl(2)-olbarrl(2));
					posbar(i)(3):=olbarrl(3)+tt*(nubarrl(3)-olbarrl(3));

					if    (rolldir=-1) then axis:=xaxis; barangle:=-barangle;
					elsif (rolldir=+1) then axis:=xaxis;
					elsif (rolldir=+3) then axis:=zaxis; barangle:=-barangle;
					elsif (rolldir=-3) then axis:=zaxis;
					end if;

					cyl2obj.updcyl2(barrel(i), 
						posbar(i)(1),posbar(i)(2),posbar(i)(3));

					bmm:=identity;
					translate(bmm, -posbar(i)(1), -posbar(i)(2), -posbar(i)(3) );
					myrotate(bmm, barangle, axis(1), axis(2), axis(3) );
					translate(bmm, posbar(i)(1), posbar(i)(2), posbar(i)(3) );

					bmvp := bmm;
					mymatmult( bmvp, vm );
					mymatmult( bmvp, pm );

				else
					rolling(i):=false;
					posbar(i):=nubarrl;

					cyl2obj.updcyl2(barrel(i), 
						posbar(i)(1),posbar(i)(2),posbar(i)(3));

				end if; -- tt

			end if; -- rolling

			-- we have to register bmvp for each i AFTER it is redefined:
			gluniformmatrix4fv( ntmatrixid, 1, gl_false, bmvp(1,1)'address );
			cyl2obj.draw(barrel(i),vertbuff,rgbbuff,elembuff, seated(i)); -- 2jul15


		end loop;



		-- begin draw common textured objects------------------------------------------------
		
		glUseProgram( pgmtexshadid );
		gluniformmatrix4fv( mvid, 1, gl_false, mv(1,1)'address );
		gluniformmatrix4fv( matrixid, 1, gl_false, mvp(1,1)'address );
		gluniform1i(uniftex,0);
		gluniform1i(uniflev, interfaces.c.int(level-1) );
		gluniform1i(unifopac, 1); -- 1=>normal opacity

		glbindtexture(gl_texture_2d, room_texid);
		mroomobj.draw(rmo,vertbuff,uvbuff,elembuff); --textured room with floor-gap

		if portalEnabled then
			glbindtexture(gl_texture_2d, barloc1_texid);
		else
			glbindtexture(gl_texture_2d, barloc0_texid);
		end if;
		-- draw receptacles (using pgmtexshadid)
		for row in 1..nrows loop
			for col in 1..ncols loop
				if( rcpt(row,col) = true ) then
					pictobj.draw( sokrcpt(row,col), vertbuff, uvbuff, elembuff );
				end if;
			end loop;
		end loop;









		if level=2 then
			glbindtexture(gl_texture_2d, grunge_texid);
			pictobj.draw(bloc2, vertbuff,uvbuff,elembuff); --block wall divider
		elsif level=3 then
			glbindtexture(gl_texture_2d, woodw_texid);
			pictobj.draw(bloc2, vertbuff,uvbuff,elembuff); --block wall divider
		elsif level=1 then
			glbindtexture(gl_texture_2d, adobe_texid); --  lev1, dark adobe wall
			rectobj.draw(bloc, vertbuff,uvbuff,elembuff); --block wall divider
		elsif level=4 then
			glbindtexture(gl_texture_2d, bricksw_texid); -- for lev 4
			rectobj.draw(bloc, vertbuff,uvbuff,elembuff); --block wall divider
		end if;

		if level=1 then
			glbindtexture(gl_texture_2d, adobe_texid); -- dark adobe for ledge
		else
			glbindtexture(gl_texture_2d, woodw_texid);
		end if;
		rectobj.draw(ledge,  vertbuff,uvbuff,elembuff); -- high ledge platform

		if level=1 then -- 3: ceil matches walls;   4: special fragshader
			glbindtexture(gl_texture_2d, ceil_texid);
			rectobj.draw(ceil2,  vertbuff,uvbuff,elembuff); -- ceiling
		elsif level=2 then
			glbindtexture(gl_texture_2d, grunge_texid); -- best 4 reflective water
			pictobj.draw(ceil,  vertbuff,uvbuff,elembuff); -- ceiling
		end if;


		if (level=1) or (level=4) then
			glbindtexture(gl_texture_2d, pic_texid);
			pictobj.draw(pic,  vertbuff,uvbuff,elembuff); -- wall picture
		end if;


		-- Brick Lining of Pool
		glbindtexture(gl_texture_2d, lining_texid);
		rectobj.draw(pxp, vertbuff,uvbuff,elembuff); --@+X
		rectobj.draw(pxm, vertbuff,uvbuff,elembuff); --@-X
		rectobj.draw(pzp, vertbuff,uvbuff,elembuff); --@+Z
		rectobj.draw(pzm, vertbuff,uvbuff,elembuff); --@-Z
		rectobj.draw(pym, vertbuff,uvbuff,elembuff); --@bottom




		-- draw exit box:
		if not xit then
			glbindtexture(gl_texture_2d, xbox1_texid);
			rectobj.draw(xbox,  vertbuff,uvbuff,elembuff); -- exit box
		else

			elapsed := currenttime - exittime;
			it := -100 + integer(elapsed*25.0); -- -100..+100 in 8 seconds
			dy := -0.02*float( 100 - abs(it) ); --  0 .. -2 .. 0

			if( it<=100 ) then -- Xform underway
				exitwait:=true;
				rectobj.setrect(xbox, 
					xboxpos(1), xboxpos(2)+dy, xboxpos(3), 
					1.0,1.0,1.0, xm,xp,ym,yp,zm,zp);
			else
				exitwait:=false;
			end if;

			if it<0 then --skull descending
				glbindtexture(gl_texture_2d, xbox1_texid);
				rectobj.draw(xbox,  vertbuff,uvbuff,elembuff); -- exit box
			else -- door ascending
				glbindtexture(gl_texture_2d, xbox2_texid);
				rectobj.draw(xbox,  vertbuff,uvbuff,elembuff); -- exit box
			end if;

		end if;






		--draw portals
		if not lport_defined and lport_located and lport_stable then
			xr:=wormradius;  yr:=xr; zr:=xr;
			if    pone=1 then xr:=0.01;
			elsif pone=2 then yr:=0.01;
			elsif pone=3 then zr:=0.01;
			end if;
			rectobj.setrect(lportal, xtgt1,ytgt1,ztgt1, xr,yr,zr,	
				xm,xp,ym,yp,zm,zp);
			lport_defined:=true;
		end if;

		if not rport_defined and rport_located and rport_stable then
			xr:=wormradius;  yr:=xr; zr:=xr;
			if    ptwo=1 then xr:=0.01;
			elsif ptwo=2 then yr:=0.01;
			elsif ptwo=3 then zr:=0.01;
			end if;
			rectobj.setrect(rportal, xtgt2,ytgt2,ztgt2, xr,yr,zr,	
				xm,xp,ym,yp,zm,zp);
			rport_defined:=true;
		end if;

		if worming or not portalEnabled then
			glbindtexture(gl_texture_2d, offport_texid);
		else
			glbindtexture(gl_texture_2d, port_texid);
		end if;
		if lport_located and lport_stable then
			rectobj.draw(lportal, vertbuff,uvbuff,elembuff);
		end if;
		if rport_located and rport_stable then
			rectobj.draw(rportal, vertbuff,uvbuff,elembuff);
		end if;




		-- draw sokoban walls here
		if level=1 then
			glbindtexture(gl_texture_2d, adobe_texid); --dark adobe
		elsif level=2 then
			glbindtexture(gl_texture_2d, woodt_texid);
		elsif level=3 then
			glbindtexture(gl_texture_2d, brick_texid);
		else
			glbindtexture(gl_texture_2d, sok_texid);
		end if;

		-- draw walls made up of short cubes (still using pgmtexshadid)
		for row in 1..nrows loop
			for col in 1..ncols loop
				-- if post exists here, draw short cube
				if( wall(row,col) = true ) then
					rectobj.draw( sokwall(row,col), vertbuff, uvbuff, elembuff );
				end if;
			end loop;
		end loop;



	end if; -- in-a-dungeon (level < 5) (5pgs up)


---------- end draw common textured objects--------------------------------------------



	if not userexit then -- 6pgs

	--draw pools and other objects with special shaders

		if (level=1) then

---------- begin piranha ------------------------------------------------

			gluseprogram(fishTexShadID);
			gluniformmatrix4fv(fishMatrixID, 1, gl_false, mvp(1,1)'address );
			gluniform1i(fishuniftex,0);
			glUniform3f(fcenID, glfloat(fishx),glfloat(fishy),glfloat(fishz) );
			glUniform1f(fishunifrad, glfloat(fishr) ); --swim circle radius
			glUniform1f(fishunifsvel, glfloat(fishs) ); --swim speed
			glUniform1f(fishunifwvel, 1.0 ); --wiggle speed
			glUniform1f(fishunifwamp, 1.0 ); --wiggle amplitude
			glbindtexture(gl_texture_2d, pfish_texid);

			glUniform1f(fishuniftime, glfloat(currentTime) ); 
			myfish.draw( pdfish, vertbuff,uvbuff,elembuff ); --piranha

			glUniform1f(fishuniftime, glfloat(currentTime+6.0) ); 
			myfish.draw( pdfish, vertbuff,uvbuff,elembuff ); --piranha

			glUniform1f(fishuniftime, glfloat(currentTime+12.0) ); 
			myfish.draw( pdfish, vertbuff,uvbuff,elembuff ); --piranha

			glUniform1f(fishuniftime, glfloat(currentTime+18.0) ); 
			myfish.draw( pdfish, vertbuff,uvbuff,elembuff ); --piranha

			glUniform1f(fishuniftime, glfloat(currentTime+24.0) ); 
			myfish.draw( pdfish, vertbuff,uvbuff,elembuff ); --piranha

			glUniform1f(fishuniftime, glfloat(currentTime+30.0) ); 
			myfish.draw( pdfish, vertbuff,uvbuff,elembuff ); --piranha

---------- end piranha ------------------------------------------------



			-- fancy frag shader draws normal water in level 1
			glUseProgram( poolshadid );
			gluniformmatrix4fv( poolmvid, 1, gl_false, mv(1,1)'address );
			gluniformmatrix4fv( poolmatid, 1, gl_false, mvp(1,1)'address );
			gluniform1f(timeid, glfloat(currentTime) );
			gluniform3f(pcenid, glfloat(xpcen), glfloat(ypcen), glfloat(zpcen) );
			gluniform3f(pradid, glfloat(xprad), glfloat(yprad), glfloat(zprad) );
			gluniform1f(wlevid, glfloat(waterlevel) );
			rectsurf.draw(rso,vertbuff);



			--PalmTreeWindmill
			glUseProgram( x1picshadid );
			gluniformmatrix4fv( x1picmatid, 1, gl_false, mvp(1,1)'address );
			gluniform1f(x1pictimeid, glfloat(currentTime) );
			gluniform2f(x1piccenid, glfloat(x1picx), glfloat(x1picy) );
			gluniform2f(x1picradid, glfloat(x1picw/2.0), glfloat(x1pich/2.0) );
			gluniform2f(x1picresid, glfloat(winwidth), glfloat(winheight) );
			rectxobj.draw(pox,vertbuff,elembuff);


		elsif (level=2) then -- reflective water



---------- begin piranha ------------------------------------------------

			gluseprogram(fishTexShadID);
			gluniformmatrix4fv(fishMatrixID, 1, gl_false, mvp(1,1)'address );
			gluniform1i(fishuniftex,0);
			glUniform3f(fcenID, glfloat(fishx),glfloat(fishy),glfloat(fishz) );
			glUniform1f(fishunifrad, glfloat(fishr) ); --swim circle radius
			glUniform1f(fishunifsvel, glfloat(fishs) ); --swim speed
			glUniform1f(fishunifwvel, 1.0 ); --wiggle speed
			glUniform1f(fishunifwamp, 1.0 ); --wiggle amplitude
			glbindtexture(gl_texture_2d, pfish_texid);

			glUniform1f(fishuniftime, glfloat(currentTime) ); 
			myfish.draw( pdfish, vertbuff,uvbuff,elembuff ); --piranha

			glUniform1f(fishuniftime, glfloat(currentTime+6.0) ); 
			myfish.draw( pdfish, vertbuff,uvbuff,elembuff ); --piranha

			glUniform1f(fishuniftime, glfloat(currentTime+12.0) ); 
			myfish.draw( pdfish, vertbuff,uvbuff,elembuff ); --piranha

			glUniform1f(fishuniftime, glfloat(currentTime+18.0) ); 
			myfish.draw( pdfish, vertbuff,uvbuff,elembuff ); --piranha

			glUniform1f(fishuniftime, glfloat(currentTime+24.0) ); 
			myfish.draw( pdfish, vertbuff,uvbuff,elembuff ); --piranha

			glUniform1f(fishuniftime, glfloat(currentTime+30.0) ); 
			myfish.draw( pdfish, vertbuff,uvbuff,elembuff ); --piranha

---------- end piranha ------------------------------------------------








			glUseProgram( rpoolshadid );

			-- define cubemapped textures to reflect:
			glenable(gl_texture_cube_map);
			glbindtexture(gl_texture_cube_map, cubemap_texid);
			-- note:  this is essentially a "cheat".  I really want
			--        to use the actual environment!
			gluniform1i(envmapid, 0); -- "envMap" in lvwater.fs
			gluniformmatrix4fv( rpoolmvid, 1, gl_false, mv(1,1)'address );
			gluniformmatrix4fv( rpoolmatid, 1, gl_false, mvp(1,1)'address );
			gluniform1f(rtimeid, glfloat(currentTime) );
			gluniform3f(rpeyeid, glfloat(xme), glfloat(yme), glfloat(zme) );
			gluniform3f(rpcenid, glfloat(xpcen), glfloat(ypcen), glfloat(zpcen) );
			gluniform3f(rpradid, glfloat(xprad), glfloat(yprad), glfloat(zprad) );
			gluniform1f(rwlevid, glfloat(waterlevel) );

			reflsurf.draw(rfo,vertbuff);





			--WaterWorld
			glUseProgram( x2picshadid );
			gluniformmatrix4fv( x2picmatid, 1, gl_false, mvp(1,1)'address );
			gluniform1f(x2pictimeid, glfloat(currentTime) );
			gluniform2f(x2piccenid, glfloat(x2picx), glfloat(x2picy) );
			gluniform2f(x2picradid, glfloat(x2picwb/2.0), glfloat(x2pichb/2.0) );
			gluniform2f(x2picresid, glfloat(winwidth), glfloat(winheight) );
			rectxobj.draw(pox,vertbuff,elembuff);

			--MountainScape
			glUseProgram( x2pic2shadid );
			gluniformmatrix4fv( x2pic2matid, 1, gl_false, mvp(1,1)'address );
			gluniform1f(x2pic2timeid, glfloat(currentTime) );
			gluniform2f(x2pic2cenid, glfloat(x2picx), glfloat(x2picy) );
			gluniform2f(x2pic2radid, glfloat(x2picws/2.0), glfloat(x2pichs/2.0) );
			gluniform2f(x2pic2resid, glfloat(winwidth), glfloat(winheight) );
			rectxobj.draw(pox2,vertbuff,elembuff);




		elsif (level=3) then  -- volcano

			-- fancy fragshader draws lava in level 3
			glUseProgram( lpoolshadid );
			gluniformmatrix4fv( lpoolmvid, 1, gl_false, mv(1,1)'address );
			gluniformmatrix4fv( lpoolmatid, 1, gl_false, mvp(1,1)'address );

			gluniform2f(lresid, glfloat(winwidth), glfloat(winheight) );
			gluniform1f(ltimeid, glfloat(currentTime) );

			gluniform3f(lpcenid, glfloat(xpcen), glfloat(ypcen), glfloat(zpcen) );
			gluniform3f(lpradid, glfloat(xprad), glfloat(yprad), glfloat(zprad) );
			gluniform1f(lwlevid, glfloat(waterlevel) );

			finesurf.draw(fso,vertbuff);

			--DaliClock
			glUseProgram( x3picshadid );
			gluniformmatrix4fv( x3picmatid, 1, gl_false, mvp(1,1)'address );
			gluniform1f(x3pictimeid, glfloat(-currentTime) );
			gluniform2f(x3piccenid, glfloat(x3picx), glfloat(x3picy) );
			gluniform2f(x3picradid, glfloat(x3picws/2.0), glfloat(x3pichs/2.0) );
			gluniform2f(x3picresid, glfloat(winwidth), glfloat(winheight) );
			rectxobj.draw(pox,vertbuff,elembuff);


			--redPlanet
			glUseProgram( x3pic2shadid );
			gluniformmatrix4fv( x3pic2matid, 1, gl_false, mvp(1,1)'address );
			gluniform1f(x3pic2timeid, glfloat(currentTime) );
			gluniform2f(x3pic2cenid, glfloat(x3picx), glfloat(x3picy) );
			gluniform2f(x3pic2radid, glfloat(x3picwb/2.0), glfloat(x3pichb/2.0) );
			gluniform2f(x3pic2resid, glfloat(winwidth), glfloat(winheight) );
			rectxobj.draw(pox2,vertbuff,elembuff);






		elsif (level=4) then



---------- begin piranha ------------------------------------------------

			gluseprogram(fishTexShadID);
			gluniformmatrix4fv(fishMatrixID, 1, gl_false, mvp(1,1)'address );
			gluniform1i(fishuniftex,0);
			glUniform3f(fcenID, glfloat(fishx),glfloat(fishy),glfloat(fishz) );
			glUniform1f(fishunifrad, glfloat(fishr) ); --swim circle radius
			glUniform1f(fishunifsvel, glfloat(fishs) ); --swim speed
			glUniform1f(fishunifwvel, 1.0 ); --wiggle speed
			glUniform1f(fishunifwamp, 1.0 ); --wiggle amplitude
			glbindtexture(gl_texture_2d, pfish_texid);

			glUniform1f(fishuniftime, glfloat(currentTime) ); 
			myfish.draw( pdfish, vertbuff,uvbuff,elembuff ); --piranha

			glUniform1f(fishuniftime, glfloat(currentTime+6.0) ); 
			myfish.draw( pdfish, vertbuff,uvbuff,elembuff ); --piranha

			glUniform1f(fishuniftime, glfloat(currentTime+12.0) ); 
			myfish.draw( pdfish, vertbuff,uvbuff,elembuff ); --piranha

			glUniform1f(fishuniftime, glfloat(currentTime+18.0) ); 
			myfish.draw( pdfish, vertbuff,uvbuff,elembuff ); --piranha

			glUniform1f(fishuniftime, glfloat(currentTime+24.0) ); 
			myfish.draw( pdfish, vertbuff,uvbuff,elembuff ); --piranha

			glUniform1f(fishuniftime, glfloat(currentTime+30.0) ); 
			myfish.draw( pdfish, vertbuff,uvbuff,elembuff ); --piranha

---------- end piranha ------------------------------------------------





			-- fancy fragshader draws dark green water in level 4
			glUseProgram( dpoolshadid );
			gluniformmatrix4fv( dpoolmvid, 1, gl_false, mv(1,1)'address );
			gluniformmatrix4fv( dpoolmatid, 1, gl_false, mvp(1,1)'address );
			gluniform1f(dtimeid, glfloat(currentTime) );
			gluniform3f(dpcenid, glfloat(xpcen), glfloat(ypcen), glfloat(zpcen) );
			gluniform3f(dpradid, glfloat(xprad), glfloat(yprad), glfloat(zprad) );
			gluniform1f(dwlevid, glfloat(waterlevel) );
			rectsurf.draw(rso,vertbuff);

			-- fancy fragshader draws star ceiling
			glUseProgram( starshadid );
			gluniformmatrix4fv( starmatid, 1, gl_false, mvp(1,1)'address );
			gluniform1f(startimeid, glfloat(currentTime) );
			gluniform2f(starresid, glfloat(winwidth), glfloat(winheight) );
			rectxobj.draw(rox,vertbuff,elembuff);


			--blueSpiralGalaxy
			glUseProgram( x4picshadid );
			gluniformmatrix4fv( x4picmatid, 1, gl_false, mvp(1,1)'address );
			gluniform1f(x4pictimeid, glfloat(currentTime) );
			gluniform2f(x4piccenid, glfloat(x4picx), glfloat(x4picy) );
			gluniform2f(x4picradid, glfloat(x4picw/2.0), glfloat(x4pich/2.0) );
			gluniform2f(x4picresid, glfloat(winwidth), glfloat(winheight) );
			rectxobj.draw(pox,vertbuff,elembuff);



		elsif (level=5) then

			-- draw cube-mapped skybox:
			gluseprogram(pidskyb);
			glenable(gl_texture_cube_map);
			glbindtexture(gl_texture_cube_map, circubemap_texid);
			gluniform1i(sbmapuid,0);
			gluniformmatrix4fv(sbmvpuid,1,gl_false,mvp(1,1)'address);

			usboxobj.draw(usb5,vertbuff,elembuff);


			-- draw skybox reflections in water:
			gluseprogram(pidskyw);
			gluniform1i(cemuid,0);
			gluniformmatrix4fv(cmvpuid,1,gl_false,mvp(1,1)'address);
			gluniform1f(ctimeid, glfloat(currenttime));
			gluniform3f(cpeyeid, 0.0,0.0,0.0);
			gluniform3f(cpcenid, 0.0,0.0,0.0);
			gluniform3f(cpradid, glfloat(rad5),1.0,glfloat(rad5) );
			gluniform1f(cwlevid, -0.12);

			circsurf.draw(cir, vertbuff); -- using n=200

			solved(5):=true;

		end if;




	end if; -- not userexit (6pgs)




	if worming then -- draw passage thru wormhole
			drawWormHole( currentTime, mvp );
	else
			drawbeams(currenttime);
			utex.print2d("+",0.5,0.5,50); -- crosshair gun sight
	end if; -- worming




		if details then

			-- intent is to show technical details here so that I can
			-- check the status under OS-X in case of a MacBundle
			-- rather than the command line version.

			--utex.print2d(" Ndim: " &
			--	interfaces.c.int'image(Nwid)&" X "
			--	& interfaces.c.int'image(Nhit), 0.02, 0.8, 15 );

			utex.print2d(" hdpi: " &
				interfaces.c.int'image(Fwid)&" X "
				& interfaces.c.int'image(Fhit), 0.02, 0.7, 15 );

--------- begin OGL queries -----------------------------------------

			glGetIntegerv(GL_CONTEXT_PROFILE_MASK, profile'address);
			if( profile = GL_CONTEXT_CORE_PROFILE_BIT ) then
				utex.print2d("ogl-query:  Core Profile", 0.02, 0.6, 10);
			end if;

			-- Note that OSX currently requires the forward_compatible flag!
			glGetIntegerv(GL_CONTEXT_FLAGS, flags'address);
			if( flags = GL_CONTEXT_FLAG_FORWARD_COMPATIBLE_BIT ) then
				utex.print2d("ogl-query:  Forward-Compatible bit is set", 0.02, 0.5, 10);
			end if;

			glgetintegerv(gl_major_version, major'address);
			glgetintegerv(gl_minor_version, minor'address);
			utex.print2d( "ogl-query: OGL-major: "&glint'image(major), 0.02, 0.4, 10);
			utex.print2d( "ogl-query: OGL-minor: "&glint'image(minor), 0.02, 0.3, 10);

--------- end OGL queries -----------------------------------------


		end if;




		sdl_gl_swapwindow( mainWindow );


--------------------------------------------------------------------------------
   end loop; --------------------------- main event loop end -------------------
--------------------------------------------------------------------------------



	if lavadead then
		snd4ada_hpp.playSnd(11); -- shriek
		utex.print2d("Sorry, Lava Killed You !", 0.25, 0.5, 50);
		sdl_gl_swapwindow( mainWindow );
		delay 4.0;
	end if;




	text_io.create(tfile, out_file, resfile);
	completed:=solved(1) and solved(2) and solved(3) and solved(4) and solved(5);
	if completed then

		put_line(tfile, integer'image( dod mod mxdeg + 1));
		put_line(tfile, integer'image(0) );
		put_line(tfile, integer'image(0) );
		put_line(tfile, integer'image(0) );
		put_line(tfile, integer'image(0) );

	else

		put_line(tfile, integer'image(dod));
		for i in 1..mxlev loop
		if solved(i) then
			put_line(tfile, integer'image(1) );
		else
			put_line(tfile, integer'image(0) );
		end if;
		end loop;

	end if;
	text_io.close(tfile);


	snd4ada_hpp.termSnds; -- stops any loops;  then deallocates

	release_textures;

	utex.cleanuptext;

	if joystik or gamepad then
		SDL_JoystickClose(jsa);
	end if;

	SDL_GL_DeleteContext(mainGLContext);
	SDL_DestroyWindow(mainWindow);

	SDL_Quit;


end adagate;

