#version 330 core

layout(location = 0) in vec3 vertexPosition_modelspace;
layout(location = 1) in vec2 vertexUV;
layout(location = 2) in vec3 vertexNormal; // lighting

smooth out vec2 UV;
smooth out vec3 vNormal; // lighting
smooth out vec4 aPos;
smooth out mat3 NormalMatrix;


// turtle is built @ (0,0,0) facing north...
uniform vec3 wPos;  // current turtle position  vs#5
uniform float angl; // current turtle horizontal look direction  vs#6

uniform mat4 MVP; // vs#2

uniform mat3 NM = mat3(1.0); // needed only for changing MM


uniform int lightFlag = 0; // 0=>no, 1=>yes   vs#4


void main(){

	// coordinates w.r.t. build-center @ origin
	vec3 origPos = vertexPosition_modelspace;

	vec3 pos; // rotated coords
	pos.x = +cos(angl)*origPos.x - sin(angl)*origPos.z;
	pos.z = +sin(angl)*origPos.x + cos(angl)*origPos.z;
	pos.y = origPos.y;

	// coords translated to desired center
	pos += wPos;



	// lighting addendum:
	if( lightFlag>0 )	
	{
		vNormal = normalize(vertexNormal);

		// used only if changing ModelMatrix,
		// i.e. moving/rotating objects
		NormalMatrix = NM;
	}
	else // do not require meaningful values
	{
		vNormal = vec3(0.0, 1.0, 0.0);
		NormalMatrix=mat3(1.0); //identity
	}



	aPos = vec4(pos,1.0);
	gl_Position =  MVP * aPos;
	UV = vertexUV; 
}


//--
//-- Copyright (C) 2018  <fastrgv@gmail.com>
//--
//-- This program is free software: you can redistribute it and/or modify
//-- it under the terms of the GNU General Public License as published by
//-- the Free Software Foundation, either version 3 of the License, or
//-- (at your option) any later version.
//--
//-- This program is distributed in the hope that it will be useful,
//-- but WITHOUT ANY WARRANTY; without even the implied warranty of
//-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//-- GNU General Public License for more details.
//--
//-- You may read the full text of the GNU General Public License
//-- at <http://www.gnu.org/licenses/>.
//--

