#!/bin/sh
#
# Mac OS-X compile script for AdaGate assuming the
# presence of GNAT2017, as well as
# Xcode and its g++ compiler.
#
# This script maximizes usage of static libs on OS-X
# using static SDL2-207,SFML-242, OpenAL libs
# which are included in the AdaGate bundle.
#
# with libopenal.a [v1.17.3] built from src from 
# https://github.com/kcat/openal-soft
#
# ...this script should work on any recent
# standard configuration of OS-X so long as
# the 2015 GNU Ada compiler, gnatmake, is installed.
#
# important note:
# on linux, gcc requires libstdc++ but here on OSX,
# gcc == clang++, which requires libc++
#
#====================================================================



# use this to ensure a complete recompilation:
if [ -d ./obj/ ]; then
	rm ./obj/*
else
	mkdir obj
fi

# This g++ is the Apple-intrinsic Xcode version:
# prepare snd4ada.o file prior to gnatmake
g++ adabindings/sfmlAudio/snd4ada.cpp -c -Werror -fPIC -IincSFML242

##################################################
# This gnatmake is AdaCore2017:

gnatmake  adagate -O3  \
-o adagate_osx_ss17 \
--subdirs=./obj \
-I$PWD/adautils \
-I$PWD/adabindings/gl \
-I$PWD/adabindings/sdl207ada \
-I$PWD/adabindings/AdaPngLib \
-I$PWD/adabindings/sfmlAudio \
-largs -lm -lz \
-lc++ \
$PWD/libs/osx/libSDL2-207x.a \
$PWD/libs/osx/libiconv.a \
$PWD/libs/osx/libopenal.a \
$PWD/libs/osx/libsfml-audio-s.a \
$PWD/libs/osx/libsfml-system-s.a \
$PWD/libs/osx/libvorbis.a \
$PWD/libs/osx/libvorbisenc.a \
$PWD/libs/osx/libvorbisfile.a \
$PWD/libs/osx/libogg.a \
$PWD/libs/osx/libFLAC-static.a \
\
$PWD/snd4ada.o \
\
-framework OpenGL \
-framework ForceFeedback \
-framework CoreFoundation \
-framework Carbon \
-framework Cocoa \
-framework QuartzCore \
-framework IOKit \
-framework CoreAudio \
-framework AudioUnit \
-framework AudioToolBox \
-pthread

mv ./obj/adagate_osx_ss17 .
cp adagate_osx_ss17 adagate_osx



# -- Copyright (C) 2018  <fastrgv@gmail.com>
# --
# -- This program is free software: you can redistribute it and/or modify
# -- it under the terms of the GNU General Public License as published by
# -- the Free Software Foundation, either version 3 of the License, or
# -- (at your option) any later version.
# --
# -- This program is distributed in the hope that it will be useful,
# -- but WITHOUT ANY WARRANTY; without even the implied warranty of
# -- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# -- GNU General Public License for more details.
# --
# -- You may read the full text of the GNU General Public License
# -- at <http://www.gnu.org/licenses/>.

