
--
-- Copyright (C) 2018  <fastrgv@gmail.com>
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You may read the full text of the GNU General Public License
-- at <http://www.gnu.org/licenses/>.
--

with gl;
with ada.finalization;
with unchecked_deallocation;


generic
	nang, nrad : integer; -- nang=#angularSegments, nrad=#radialSegments

package annusurfobj is 
-- for annular/circular body of reflective water
-- polar gridding


type annusurf is tagged private;


procedure setRound( cs: in out annusurf;  inner, outer : float );

procedure draw( cs: annusurf;  vertbuff : gl.gluint );


private

nsq : constant integer := nang*nrad;
nvert : constant integer := 18*nsq;

type varray is array(1..nvert) of float;
type vap is access varray;


type annusurf is new ada.finalization.controlled with record
vert: vap;
nv : integer;
end record;


procedure initialize( cs: in out annusurf );
procedure finalize( cs: in out annusurf );



end annusurfobj;
