/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.stigmata.birthmarks.wsp;

import java.util.ArrayList;
import java.util.List;
import jp.sourceforge.stigmata.birthmarks.wsp.LabelOpcode;
import jp.sourceforge.stigmata.birthmarks.wsp.Opcode;
import jp.sourceforge.stigmata.birthmarks.wsp.OpcodeExtractionFinishListener;
import jp.sourceforge.stigmata.birthmarks.wsp.OpcodeManager;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodAdapter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class OpcodeExtractionMethodVisitor
extends MethodAdapter {
    private List<Opcode> opcodes;
    private OpcodeManager manager = OpcodeManager.getInstance();
    private List<OpcodeExtractionFinishListener> listeners = new ArrayList<OpcodeExtractionFinishListener>();

    public OpcodeExtractionMethodVisitor(MethodVisitor visitor) {
        this(visitor, new ArrayList<Opcode>());
    }

    public OpcodeExtractionMethodVisitor(MethodVisitor visitor, List<Opcode> opcodes) {
        super(visitor);
        this.opcodes = opcodes;
    }

    public void addOpcodeExtractionFinishListener(OpcodeExtractionFinishListener listener) {
        this.listeners.add(listener);
    }

    public void removeOpcodeExtractionFinishListener(OpcodeExtractionFinishListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        Opcode field = this.manager.getOpcode(opcode);
        Opcode o = new Opcode(field);
        int size = Type.getType(desc).getSize();
        switch (opcode) {
            case 181: {
                size = -1 - size;
                break;
            }
            case 179: {
                size = 0 - size;
                break;
            }
            case 180: {
                size = -1 + size;
                break;
            }
            case 178: {
                size = 0 + size;
            }
        }
        o.setAct(size);
        this.opcodes.add(o);
        super.visitFieldInsn(opcode, owner, name, desc);
    }

    @Override
    public void visitIincInsn(int var, int increment) {
        this.opcodes.add(this.manager.getOpcode(132));
        super.visitIincInsn(var, increment);
    }

    @Override
    public void visitInsn(int opcode) {
        this.opcodes.add(this.manager.getOpcode(opcode));
        super.visitInsn(opcode);
    }

    @Override
    public void visitLabel(Label label) {
        this.opcodes.add(new LabelOpcode(label));
    }

    @Override
    public void visitIntInsn(int opcode, int operand) {
        this.opcodes.add(this.manager.getOpcode(opcode));
        super.visitIntInsn(opcode, operand);
    }

    @Override
    public void visitJumpInsn(int opcode, Label label) {
        Opcode o = this.manager.getOpcode(opcode);
        o.addLabel(label);
        this.opcodes.add(o);
        super.visitJumpInsn(opcode, label);
    }

    @Override
    public void visitLdcInsn(Object value) {
        this.opcodes.add(this.manager.getOpcode(18));
        super.visitLdcInsn(value);
    }

    @Override
    public void visitTableSwitchInsn(int min, int max, Label defaultLabel, Label[] labels) {
        Opcode tableSwitch = new Opcode(this.manager.getOpcode(170));
        tableSwitch.setLabels(labels);
        tableSwitch.addLabel(defaultLabel);
        this.opcodes.add(tableSwitch);
        super.visitTableSwitchInsn(min, max, defaultLabel, labels);
    }

    @Override
    public void visitLookupSwitchInsn(Label defaultHandle, int[] keys, Label[] labels) {
        Opcode lookupSwitch = new Opcode(this.manager.getOpcode(171));
        lookupSwitch.setLabels(labels);
        lookupSwitch.addLabel(defaultHandle);
        this.opcodes.add(lookupSwitch);
        super.visitLookupSwitchInsn(defaultHandle, keys, labels);
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        Opcode methodOpcode = new Opcode(this.manager.getOpcode(opcode));
        Type[] types = Type.getArgumentTypes(desc);
        int argumentSize = 0;
        for (Type type : types) {
            argumentSize = type.getSize();
        }
        int size = Type.getReturnType(desc).getSize();
        switch (opcode) {
            case 184: {
                size -= argumentSize;
                break;
            }
            case 182: 
            case 183: 
            case 185: {
                size = size - argumentSize - 1;
            }
        }
        methodOpcode.setAct(size);
        this.opcodes.add(methodOpcode);
        super.visitMethodInsn(opcode, owner, name, desc);
    }

    @Override
    public void visitMultiANewArrayInsn(String desc, int dims) {
        this.opcodes.add(this.manager.getOpcode(197));
        super.visitMultiANewArrayInsn(desc, dims);
    }

    @Override
    public void visitTypeInsn(int opcode, String desc) {
        this.opcodes.add(this.manager.getOpcode(opcode));
        super.visitTypeInsn(opcode, desc);
    }

    @Override
    public void visitVarInsn(int opcode, int var) {
        this.opcodes.add(this.manager.getOpcode(opcode));
        super.visitVarInsn(opcode, var);
    }

    @Override
    public void visitEnd() {
        for (OpcodeExtractionFinishListener listener : this.listeners) {
            listener.finishExtractionOpcodes(this.opcodes);
        }
    }
}

