package jp.sourceforge.stigmata.birthmarks.extractors;

/*
 * $Id: FrequencyMethodCallBirthmarkExtractorService.java 294 2008-07-11 08:51:37Z tama3 $
 */

import jp.sourceforge.stigmata.BirthmarkExtractor;
import jp.sourceforge.stigmata.birthmarks.fmc.FrequencyMethodCallBirthmarkExtractor;
import jp.sourceforge.stigmata.spi.BirthmarkSpi;

/**
 * Birthmark Service Provider Interface.
 *
 * @author Haruaki TAMADA
 * @version $Revision: 294 $ 
 */
public class FrequencyMethodCallBirthmarkExtractorService extends AbstractBirthmarkExtractorService{

    /**
     * returns a type of the birthmark this service provides.
     */
    public String getType(){
        return "fmc";
    }

    public String getExtractorClassName(){
        return FrequencyMethodCallBirthmarkExtractor.class.getName();
    }

    /**
     * returns a extractor for the birthmark of this service.
     */
    public BirthmarkExtractor getExtractor(BirthmarkSpi service){
        return new FrequencyMethodCallBirthmarkExtractor(service);
    }
}