package jp.sourceforge.stigmata.birthmarks.comparators;

/*
 * $Id: ExtendedEditDistanceBirthmarkComparator.java 294 2008-07-11 08:51:37Z tama3 $
 */

import jp.sourceforge.stigmata.Birthmark;
import jp.sourceforge.stigmata.BirthmarkElement;
import jp.sourceforge.stigmata.spi.BirthmarkSpi;

/**
 * calculate similarities between two birthmarks by edit distance
 * algorithm (levenshtein distance).
 *
 * @author Haruaki TAMADA
 * @version $Revision: 294 $ 
 */
public class ExtendedEditDistanceBirthmarkComparator extends EditDistanceBirthmarkComparator{
    public ExtendedEditDistanceBirthmarkComparator(BirthmarkSpi spi){
        super(spi);
    }

    public double compare(Birthmark b1, Birthmark b2) {
        if(!b1.getType().equals(b2.getType())){
            return Double.NaN;
        }

        BirthmarkElement[] element1 = b1.getElements();
        BirthmarkElement[] element2 = b2.getElements();
        int[][] distance = createDistanceMatrics(element1, element2);

        int length = element1.length;
        if(length > element2.length){
            length = element2.length;
        }
        int d = distance[element1.length][element2.length];

        return (double)(1 - (d + Math.abs(element1.length - element2.length))) / length;
    }
}
