package jp.sourceforge.stigmata;

/*
 * $Id: ComparisonResultSet.java 294 2008-07-11 08:51:37Z tama3 $
 */

import java.util.Iterator;

/**
 * result set of birthmark comparison.
 *
 * @author Haruaki TAMADA
 * @version $Revision: 294 $ 
 */
public interface ComparisonResultSet extends Iterable<ComparisonPair>{
    /**
     * the birthmark environment.
     */
    public BirthmarkEnvironment getEnvironment();

    /**
     * the birthmark context.
     */
    public BirthmarkContext getContext();

    /**
     * a iterator for {@link ComparisonPair <code>ComparisonPair</code>}.
     */
    public Iterator<ComparisonPair> iterator();

    /**
     * a comparison pair at given index.
     */
    public ComparisonPair getPairAt(int index);

    /**
     * all comparison pairs.
     */
    public ComparisonPair[] getPairs();

    /**
     * comparison pair count of this instance has.
     */
    public int getPairCount();

    /**
     * comparison source.
     */
    public BirthmarkSet[] getPairSources();

    /**
     * returns an array of comparison sources.
     */
    public Iterator<BirthmarkSet> pairSources();
}
