/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.stigmata.ui.swing.mds;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import jp.sourceforge.stigmata.BirthmarkContext;
import jp.sourceforge.stigmata.BirthmarkSet;
import jp.sourceforge.stigmata.ComparisonPair;
import jp.sourceforge.stigmata.ui.swing.ClippedLRListCellRenderer;
import jp.sourceforge.stigmata.ui.swing.GUIUtility;
import jp.sourceforge.stigmata.ui.swing.PopupButton;
import jp.sourceforge.stigmata.ui.swing.StigmataFrame;
import jp.sourceforge.stigmata.ui.swing.actions.SaveAction;
import jp.sourceforge.stigmata.ui.swing.mds.LabelMap;
import jp.sourceforge.stigmata.ui.swing.mds.MdsImageExporter;
import jp.sourceforge.stigmata.ui.swing.mds.MdsItemsLocationExporter;
import jp.sourceforge.stigmata.ui.swing.mds.OpenItemsAction;
import jp.sourceforge.talisman.i18n.MessageManager;
import jp.sourceforge.talisman.i18n.Messages;
import jp.sourceforge.talisman.i18n.ResourceNotFoundException;
import jp.sourceforge.talisman.mds.Item;
import jp.sourceforge.talisman.mds.MdsMethod;
import jp.sourceforge.talisman.mds.Table;
import jp.sourceforge.talisman.mds.ui.MdsGraphSetting;
import jp.sourceforge.talisman.mds.ui.mark.DrawerFactory;
import jp.sourceforge.talisman.mds.ui.swing.MdsPane;
import jp.sourceforge.talisman.mds.ui.swing.actions.AntiClockwiseRotateAction;
import jp.sourceforge.talisman.mds.ui.swing.actions.ClearAction;
import jp.sourceforge.talisman.mds.ui.swing.actions.ClockwiseRotateAction;
import jp.sourceforge.talisman.mds.ui.swing.actions.ClusteringAction;
import jp.sourceforge.talisman.mds.ui.swing.actions.HorizontalFlipAction;
import jp.sourceforge.talisman.mds.ui.swing.actions.VerticalFlipAction;
import jp.sourceforge.talisman.mds.ui.swing.actions.ZoomEnabler;
import jp.sourceforge.talisman.mds.ui.swing.actions.ZoomInAction;
import jp.sourceforge.talisman.mds.ui.swing.actions.ZoomOutAction;

public class MdsViewerPane
extends JPanel
implements ZoomEnabler,
MessageManager {
    private static final long serialVersionUID = -7256554014379112897L;
    private static final int[] ZOOM_PATTERN = new int[]{30, 40, 50, 75, 100, 125, 150, 200, 300, 400};
    private StigmataFrame stigmata;
    private BirthmarkSet[] set;
    private BirthmarkContext context;
    private MdsPane mdspane;
    private MdsGraphSetting setting;
    private LabelMap labels;
    private int currentZoomPattern = 4;
    private boolean userInputtedValue = false;
    private JTextField zoomRatio;
    private ZoomInAction zoomin;
    private ZoomOutAction zoomout;

    public MdsViewerPane(StigmataFrame stigmata, BirthmarkSet[] set, BirthmarkContext context) {
        this.stigmata = stigmata;
        this.context = context;
        this.set = set;
        try {
            this.initLayouts();
        }
        catch (ResourceNotFoundException e) {
            e.printStackTrace();
            throw new InternalError(e.getMessage());
        }
    }

    public void zoomIn() {
        ++this.currentZoomPattern;
        this.userInputtedValue = false;
        this.zoom(ZOOM_PATTERN[this.currentZoomPattern]);
    }

    public void zoomOut() {
        if (!this.userInputtedValue) {
            --this.currentZoomPattern;
        }
        this.userInputtedValue = false;
        this.zoom(ZOOM_PATTERN[this.currentZoomPattern]);
    }

    public void zoom(int ratio) {
        for (int i = 0; i < ZOOM_PATTERN.length; ++i) {
            if (ratio > ZOOM_PATTERN[i]) continue;
            this.currentZoomPattern = i;
            break;
        }
        if (this.userInputtedValue && ratio < ZOOM_PATTERN[0]) {
            this.currentZoomPattern = -1;
        }
        if (this.userInputtedValue && ratio > ZOOM_PATTERN[ZOOM_PATTERN.length - 1]) {
            this.currentZoomPattern = ZOOM_PATTERN.length - 1;
        }
        this.zoomin.setEnabled(this.currentZoomPattern < ZOOM_PATTERN.length - 1);
        this.zoomout.setEnabled(this.currentZoomPattern != 0);
        this.zoomRatio.setText(ratio + " %");
        this.mdspane.setZoomRatio(ratio);
    }

    public Messages getMessages() {
        return this.stigmata.getMessages();
    }

    private Table<String> initData(BirthmarkSet[] set, BirthmarkContext context) {
        Table table = new Table();
        for (int i = 0; i < set.length; ++i) {
            for (int j = 0; j <= i; ++j) {
                ComparisonPair pair = new ComparisonPair(set[i], set[j], context);
                table.addValue((Object)set[i].getName(), (Object)set[j].getName(), (Number)(1.0 - pair.calculateSimilarity()));
            }
        }
        return table;
    }

    private String getGroupName(URL location) {
        String url = location.toString();
        if (url.startsWith("jar:")) {
            url = url.substring("jar:".length(), url.lastIndexOf(33));
        }
        return url;
    }

    private void setGroups() {
        this.labels = new LabelMap();
        this.labels.setGroupEnabled(true);
        Item[] items = this.mdspane.getItems();
        HashMap<String, BirthmarkSet> map = new HashMap<String, BirthmarkSet>();
        for (BirthmarkSet birthmarkSet : this.set) {
            map.put(birthmarkSet.getName(), birthmarkSet);
        }
        for (BirthmarkSet birthmarkSet : items) {
            BirthmarkSet s = (BirthmarkSet)map.get(birthmarkSet.getName());
            if (s != null) {
                this.labels.addLabel(s.getName());
                this.labels.setGroup(s.getName(), this.getGroupName(s.getLocation()));
            }
            birthmarkSet.setGroupId(this.labels.getGroupIdFromElementName(birthmarkSet.getName()));
        }
    }

    private void initLayouts() throws ResourceNotFoundException {
        Table<String> table = this.initData(this.set, this.context);
        Messages messages = this.stigmata.getMessages();
        this.setting = new MdsGraphSetting();
        this.mdspane = new MdsPane(new MdsMethod(table), this.setting, messages);
        this.setting.setShowLabels(true);
        this.setGroups();
        JCheckBox check = new JCheckBox(this.stigmata.getMessages().get("showlabel.button.label"), true);
        check.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBox c = (JCheckBox)e.getSource();
                MdsViewerPane.this.setting.setShowLabels(c.isSelected());
            }
        });
        OpenItemsAction openSelection = new OpenItemsAction(this.mdspane, this);
        ClusteringAction clusteringAction = new ClusteringAction(this.mdspane);
        SaveAction exportMdsImageAction = new SaveAction(this.stigmata, new MdsImageExporter(this.mdspane));
        exportMdsImageAction.setExtensions(this.stigmata.getMessages().getArray("savemds.extensions"));
        exportMdsImageAction.setDescrpition(this.stigmata.getMessages().get("savemds.description"));
        SaveAction exportItemsAction = new SaveAction(this.stigmata, new MdsItemsLocationExporter(this.mdspane));
        exportItemsAction.setExtensions(this.stigmata.getMessages().getArray("savelocation.extensions"));
        exportItemsAction.setDescrpition(this.stigmata.getMessages().get("savelocation.description"));
        PopupButton saveButton = new PopupButton(GUIUtility.createButton(messages, "savemds", exportMdsImageAction));
        saveButton.addMenuItem(GUIUtility.createJMenuItem(messages, "savelocation", exportItemsAction));
        JLabel numberOfDotsLabel = new JLabel(String.valueOf(this.set.length));
        GUIUtility.decorateJComponent(messages, numberOfDotsLabel, "mdsgraph.count");
        this.zoomRatio = new JTextField("100%", 5);
        GUIUtility.decorateJComponent(messages, this.zoomRatio, "mdszoomratio");
        this.zoomRatio.setColumns(5);
        this.zoomRatio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String label = MdsViewerPane.this.zoomRatio.getText();
                    if (label.endsWith("%")) {
                        label = label.substring(0, label.lastIndexOf(37));
                    }
                    label = label.trim();
                    int ratio = Integer.parseInt(label);
                    MdsViewerPane.this.userInputtedValue = true;
                    MdsViewerPane.this.zoom(ratio);
                }
                catch (NumberFormatException exception) {
                    MdsViewerPane.this.zoomRatio.setText(MdsViewerPane.this.mdspane.getZoomRatio() + " %");
                }
            }
        });
        JComboBox<ClippedLRListCellRenderer.LRItem> combo = new JComboBox<ClippedLRListCellRenderer.LRItem>();
        combo.setRenderer(new ClippedLRListCellRenderer(new Dimension(100, combo.getPreferredSize().height), 50));
        DrawerFactory factory = DrawerFactory.getInstance();
        for (Map.Entry<String, Integer> entry : this.labels.getGroupElementCounts().entrySet()) {
            int groupId = this.labels.getGroupId(entry.getKey());
            ClippedLRListCellRenderer.LRItem item = new ClippedLRListCellRenderer.LRItem(entry.getKey(), entry.getValue());
            item.setIcon(factory.createIcon(groupId));
            combo.addItem(item);
        }
        GUIUtility.decorateJComponent(messages, combo, "mdsgraph.group");
        JToolBar toolbar = new JToolBar();
        toolbar.add((Action)new ClockwiseRotateAction(this.mdspane));
        toolbar.add((Action)new AntiClockwiseRotateAction(this.mdspane));
        toolbar.add((Action)new HorizontalFlipAction(this.mdspane));
        toolbar.add((Action)new VerticalFlipAction(this.mdspane));
        this.zoomin = new ZoomInAction((ZoomEnabler)this, (MessageManager)this);
        toolbar.add((Action)this.zoomin);
        this.zoomout = new ZoomOutAction((ZoomEnabler)this, (MessageManager)this);
        toolbar.add((Action)this.zoomout);
        toolbar.add((Action)new ClearAction(this.mdspane));
        JPanel south1 = new JPanel(new GridLayout(1, 3));
        south1.add(numberOfDotsLabel);
        south1.add(this.zoomRatio);
        south1.add(combo);
        Box south2 = Box.createHorizontalBox();
        south2.add(Box.createHorizontalGlue());
        south2.add(saveButton);
        south2.add(Box.createHorizontalGlue());
        south2.add(new JButton(openSelection));
        south2.add(Box.createHorizontalGlue());
        south2.add(new JButton((Action)clusteringAction));
        south2.add(Box.createHorizontalGlue());
        south2.add(check);
        south2.add(Box.createHorizontalGlue());
        JPanel south = new JPanel(new GridLayout(2, 1));
        south.add(south1);
        south.add(south2);
        JPanel center = new JPanel(new FlowLayout(1));
        center.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Dimension d = e.getComponent().getSize();
                MdsViewerPane.this.mdspane.setSize(d.width - 10, d.height - 10);
            }
        });
        this.setLayout(new BorderLayout());
        center.add((Component)this.mdspane);
        JScrollPane scroll = new JScrollPane(center);
        scroll.setHorizontalScrollBarPolicy(32);
        scroll.setVerticalScrollBarPolicy(22);
        this.add((Component)toolbar, "North");
        this.add((Component)scroll, "Center");
        this.add((Component)south, "South");
    }
}

