/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.stigmata.ui.swing.filter;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.ArrayList;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import jp.sourceforge.stigmata.ComparisonPairFilter;
import jp.sourceforge.stigmata.filter.BirthmarkElementCountComparisonPairFilter;
import jp.sourceforge.stigmata.filter.BirthmarkElementCountComparisonPairFilterService;
import jp.sourceforge.stigmata.filter.FilterTarget;
import jp.sourceforge.stigmata.spi.BirthmarkSpi;
import jp.sourceforge.stigmata.spi.ComparisonPairFilterSpi;
import jp.sourceforge.stigmata.ui.swing.BirthmarkServiceListCellRenderer;
import jp.sourceforge.stigmata.ui.swing.BirthmarkServiceListener;
import jp.sourceforge.stigmata.ui.swing.StigmataFrame;
import jp.sourceforge.stigmata.ui.swing.filter.AbstractComparisonPairFilterComponentService;
import jp.sourceforge.stigmata.ui.swing.filter.ComparisonPairFilterPane;

public class BirthmarkElementCountComparisonPairFilterComponentService
extends AbstractComparisonPairFilterComponentService
implements BirthmarkServiceListener {
    private Pane pane;

    @Override
    public ComparisonPairFilterPane createComponent(StigmataFrame frame, ComparisonPairFilterSpi service) {
        this.pane = new Pane(frame, service);
        return this.pane;
    }

    @Override
    public String getFilterName() {
        return "elementcount";
    }

    @Override
    public void serviceAdded(BirthmarkSpi service) {
        this.pane.serviceAdded(service);
    }

    @Override
    public void serviceRemoved(BirthmarkSpi service) {
        this.pane.serviceRemoved(service);
    }

    @Override
    public ComparisonPairFilterSpi getComparisonPairFilterService() {
        return new BirthmarkElementCountComparisonPairFilterService();
    }

    private static class Pane
    extends ComparisonPairFilterPane
    implements BirthmarkServiceListener {
        private static final long serialVersionUID = -6398073942592186671L;
        private ComparisonPairFilterSpi service;
        private JComboBox criterionType;
        private JTextField threshold;
        private JComboBox targetType;
        private JComboBox birthmarks;

        public Pane(StigmataFrame frame, ComparisonPairFilterSpi service) {
            super(frame);
            this.service = service;
            this.initLayouts();
        }

        @Override
        public void serviceAdded(BirthmarkSpi service) {
            this.birthmarks.addItem(service);
        }

        @Override
        public void serviceRemoved(BirthmarkSpi service) {
            this.birthmarks.removeItem(service);
        }

        @Override
        public String[] getErrors() {
            ArrayList<String> errors = new ArrayList<String>();
            if (this.threshold.getText().trim().equals("")) {
                errors.add(this.getMessages().get("error.empty.threshold"));
            }
            try {
                int v = Integer.parseInt(this.threshold.getText());
                if (v < 0) {
                    errors.add(this.getMessages().format("error.negative.value", new Object[]{v}));
                }
            }
            catch (NumberFormatException e) {
                errors.add(this.getMessages().format("error.invalid.format.integer", new Object[]{this.threshold.getText()}));
            }
            return errors.toArray(new String[errors.size()]);
        }

        @Override
        public ComparisonPairFilter getFilter() {
            try {
                BirthmarkElementCountComparisonPairFilter filter = new BirthmarkElementCountComparisonPairFilter(this.service);
                filter.setBirthmarkType(this.getBirthmarkType());
                filter.setCriterion(this.getCriterion((String)this.criterionType.getSelectedItem()));
                filter.setThreshold(Integer.parseInt(this.threshold.getText()));
                filter.setTarget(this.getTarget((String)this.targetType.getSelectedItem()));
                return filter;
            }
            catch (Exception exception) {
                return null;
            }
        }

        @Override
        public void resetComponents() {
            this.threshold.setText("");
            this.criterionType.setSelectedIndex(0);
            this.targetType.setSelectedItem(this.getDisplayTarget(FilterTarget.BOTH_TARGETS));
        }

        @Override
        public void setFilter(ComparisonPairFilter cpf) {
            BirthmarkElementCountComparisonPairFilter filter = (BirthmarkElementCountComparisonPairFilter)cpf;
            this.criterionType.setSelectedItem(this.getDisplayCriterion(filter.getCriterion()));
            this.threshold.setText(String.valueOf(filter.getThreshold()));
            this.targetType.setSelectedItem(this.getDisplayTarget(filter.getTarget()));
        }

        private void initLayouts() {
            JLabel label = new JLabel(this.getMessages().get("filter.elementcount.label"));
            this.threshold = new JTextField();
            this.criterionType = this.createCriteriaBox(BirthmarkElementCountComparisonPairFilter.getValidCriteria());
            this.birthmarks = new JComboBox();
            this.birthmarks.setRenderer(new BirthmarkServiceListCellRenderer(new Dimension(200, 20), 60));
            JLabel label2 = new JLabel(this.getMessages().get("filter.elementcount.label.next"));
            this.targetType = this.createTargetBox();
            this.setLayout(new GridLayout(6, 1));
            this.add(label);
            this.add(this.birthmarks);
            this.add(label2);
            this.add(this.targetType);
            this.add(this.criterionType);
            this.add(this.threshold);
        }

        private String getBirthmarkType() {
            BirthmarkSpi service = (BirthmarkSpi)this.birthmarks.getSelectedItem();
            if (service != null) {
                return service.getType();
            }
            throw new IllegalStateException("invalid birthmarks");
        }
    }
}

