/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.stigmata.ui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import jp.sourceforge.stigmata.Stigmata;
import jp.sourceforge.stigmata.digger.ClasspathContext;
import jp.sourceforge.stigmata.ui.swing.DataChangeListener;
import jp.sourceforge.stigmata.ui.swing.GUIUtility;
import jp.sourceforge.stigmata.ui.swing.StigmataFrame;
import jp.sourceforge.stigmata.ui.swing.TargetSelectionPane;
import jp.sourceforge.talisman.i18n.Messages;

public class ClasspathSettingsPane
extends JPanel {
    private static final long serialVersionUID = 320973463423634L;
    private StigmataFrame stigmata;
    private TargetSelectionPane classpath;
    private TargetSelectionPane bootClasspath;

    public ClasspathSettingsPane(StigmataFrame frame) {
        this.stigmata = frame;
        this.initLayouts();
    }

    public void updateClasspathContext(ClasspathContext context) {
        String[] cplist = this.classpath.getValues();
        if (cplist != null && cplist.length >= 0) {
            for (int i = 0; i < cplist.length; ++i) {
                try {
                    URL url = null;
                    try {
                        url = new URL(cplist[i]);
                    }
                    catch (MalformedURLException e) {
                        url = new File(cplist[i]).toURI().toURL();
                    }
                    context.addClasspath(url);
                    continue;
                }
                catch (IOException ee) {
                    // empty catch block
                }
            }
        }
    }

    public void reset() {
        this.classpath.removeAllElements();
        this.bootClasspath.removeAllElements();
        try {
            ClasspathContext context = this.stigmata.getEnvironment().getClasspathContext();
            for (URL url : context) {
                this.classpath.addValue(url.toString());
            }
            this.addClasspath(this.bootClasspath, System.getProperty("java.class.path"));
            this.addClasspath(this.bootClasspath, System.getProperty("sun.boot.class.path"));
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
    }

    private void addClasspath(TargetSelectionPane target, String classpath) {
        if (classpath != null) {
            target.addValues(classpath.split(System.getProperty("path.separator")));
            this.stigmata.setNeedToSaveSettings(true);
        }
    }

    private boolean findClass(String className) {
        try {
            String[] path;
            ClasspathContext b = Stigmata.getInstance().createEnvironment().getClasspathContext();
            ClasspathContext bytecode = new ClasspathContext(b);
            for (String cp : path = this.classpath.getValues()) {
                bytecode.addClasspath(new File(cp).toURI().toURL());
            }
            return bytecode.findClass(className) != null;
        }
        catch (ClassNotFoundException e) {
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return false;
    }

    private void initLayouts() {
        final Messages messages = this.stigmata.getMessages();
        JPanel panel = new JPanel(new GridLayout(1, 2));
        this.classpath = new TargetSelectionPane(this.stigmata);
        this.bootClasspath = new TargetSelectionPane(this.stigmata);
        Box south = Box.createHorizontalBox();
        final JButton findButton = GUIUtility.createButton(messages, "findclass");
        final JTextField text = new JTextField();
        final JLabel label = new JLabel();
        this.classpath.setBorder(new TitledBorder(this.stigmata.getMessages().get("userclasspath.border")));
        this.classpath.addTargetExtensions(this.stigmata.getMessages().getArray("userclasspath.extensions"));
        this.classpath.setDescription(this.stigmata.getMessages().get("userclasspath.description"));
        this.classpath.setDirectorySelectable(true);
        this.bootClasspath.setBorder(new TitledBorder(this.stigmata.getMessages().get("bootclasspath.border")));
        this.bootClasspath.setEnabled(false);
        findButton.setEnabled(false);
        south.setBorder(new TitledBorder(this.stigmata.getMessages().get("classpathchecker.border")));
        label.setIcon(GUIUtility.getIcon(messages, "classpathchecker.default.icon"));
        label.setToolTipText(this.stigmata.getMessages().get("classpathchecker.default.tooltip"));
        this.setLayout(new BorderLayout());
        this.add((Component)panel, "Center");
        this.add((Component)south, "South");
        panel.add(this.classpath);
        panel.add(this.bootClasspath);
        south.add(Box.createHorizontalGlue());
        south.add(text);
        south.add(Box.createHorizontalGlue());
        south.add(findButton);
        south.add(Box.createHorizontalGlue());
        south.add(label);
        south.add(Box.createHorizontalGlue());
        text.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent arg0) {
                String t = text.getText();
                findButton.setEnabled(t.trim().length() > 0);
            }

            @Override
            public void insertUpdate(DocumentEvent arg0) {
                String t = text.getText();
                findButton.setEnabled(t.trim().length() > 0);
            }

            @Override
            public void removeUpdate(DocumentEvent arg0) {
                String t = text.getText();
                findButton.setEnabled(t.trim().length() > 0);
            }
        });
        ActionListener action = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String t = text.getText().trim();
                boolean flag = ClasspathSettingsPane.this.findClass(t);
                String message = ClasspathSettingsPane.this.stigmata.getMessages().get("classpathchecker.found.tooltip");
                if (flag) {
                    label.setIcon(GUIUtility.getIcon(messages, "classpathchecker.found.icon"));
                } else {
                    label.setIcon(GUIUtility.getIcon(messages, "classpathchecker.notfound.icon"));
                    message = ClasspathSettingsPane.this.stigmata.getMessages().get("classpathchecker.notfound.tooltip");
                }
                label.setToolTipText(message);
                String dm = String.format("<html><body><dl><dt>%s</dt><dd>%s</dd></body></html>", t, message);
                JOptionPane.showMessageDialog(ClasspathSettingsPane.this.stigmata, dm, ClasspathSettingsPane.this.stigmata.getMessages().get("classpathchecker.dialog.title"), 1);
            }
        };
        this.classpath.addDataChangeListener(new DataChangeListener(){

            @Override
            public void valueChanged(Object source) {
                ClasspathSettingsPane.this.stigmata.setNeedToSaveSettings(true);
            }
        });
        findButton.addActionListener(action);
        text.addActionListener(action);
    }
}

