/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.stigmata.result;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Iterator;
import jp.sourceforge.stigmata.BirthmarkContext;
import jp.sourceforge.stigmata.BirthmarkEnvironment;
import jp.sourceforge.stigmata.BirthmarkSet;
import jp.sourceforge.stigmata.BirthmarkStoreException;
import jp.sourceforge.stigmata.ExtractionResultSet;
import jp.sourceforge.stigmata.ExtractionTarget;
import jp.sourceforge.stigmata.ExtractionUnit;
import jp.sourceforge.stigmata.result.AbstractComparisonResultSet;

public abstract class AbstractExtractionResultSet
implements ExtractionResultSet {
    private BirthmarkContext context;
    private boolean tableType = true;
    private String id;

    public AbstractExtractionResultSet(BirthmarkContext context) {
        this(context, true);
    }

    public AbstractExtractionResultSet(BirthmarkContext context, boolean tableType) {
        this.context = context;
        this.id = AbstractExtractionResultSet.generateId();
    }

    void setId(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public BirthmarkEnvironment getEnvironment() {
        return this.context.getEnvironment();
    }

    @Override
    public BirthmarkContext getContext() {
        return this.context;
    }

    @Override
    public abstract void addBirthmarkSet(ExtractionTarget var1, BirthmarkSet var2) throws BirthmarkStoreException;

    @Override
    public abstract void removeBirthmarkSet(ExtractionTarget var1, BirthmarkSet var2);

    @Override
    public abstract void removeAllBirthmarkSets(ExtractionTarget var1);

    @Override
    public abstract int getBirthmarkSetSize(ExtractionTarget var1);

    @Override
    public abstract Iterator<BirthmarkSet> birthmarkSets(ExtractionTarget var1);

    @Override
    public int getBirthmarkSetSize() {
        return this.getBirthmarkSetSize(ExtractionTarget.TARGET_BOTH);
    }

    @Override
    public Iterator<BirthmarkSet> iterator() {
        return this.birthmarkSets(ExtractionTarget.TARGET_BOTH);
    }

    @Override
    public BirthmarkSet getBirthmarkSet(int index) {
        return this.getBirthmarkSet(ExtractionTarget.TARGET_BOTH, index);
    }

    @Override
    public BirthmarkSet getBirthmarkSet(String name) {
        return this.getBirthmarkSet(ExtractionTarget.TARGET_BOTH, name);
    }

    @Override
    public BirthmarkSet[] getBirthmarkSets() {
        return this.getBirthmarkSets(ExtractionTarget.TARGET_BOTH);
    }

    @Override
    public void removeBirthmarkSet(BirthmarkSet bs) {
        this.removeBirthmarkSet(ExtractionTarget.TARGET_BOTH, bs);
    }

    @Override
    public void removeAllBirthmarkSets() {
        this.removeAllBirthmarkSets(ExtractionTarget.TARGET_BOTH);
    }

    @Override
    public String[] getBirthmarkTypes() {
        return this.context.getBirthmarkTypes();
    }

    @Override
    public ExtractionUnit getExtractionUnit() {
        return this.context.getExtractionUnit();
    }

    @Override
    public BirthmarkSet getBirthmarkSet(ExtractionTarget target, int index) {
        int currentIndex = 0;
        Iterator<BirthmarkSet> i = this.birthmarkSets(target);
        while (i.hasNext()) {
            if (currentIndex == index) {
                return i.next();
            }
            i.next();
            ++currentIndex;
        }
        return null;
    }

    @Override
    public BirthmarkSet getBirthmarkSet(ExtractionTarget target, String setname) {
        Iterator<BirthmarkSet> i = this.birthmarkSets(target);
        while (i.hasNext()) {
            BirthmarkSet bs = i.next();
            if (!bs.getName().equals(setname)) continue;
            return bs;
        }
        return null;
    }

    @Override
    public synchronized BirthmarkSet[] getBirthmarkSets(ExtractionTarget target) {
        return AbstractComparisonResultSet.getArrays(this.birthmarkSets(target), new BirthmarkSet[0]);
    }

    @Override
    public void setBirthmarkSets(ExtractionTarget target, BirthmarkSet[] sets) throws BirthmarkStoreException {
        this.removeAllBirthmarkSets(target);
        for (int i = 0; i < sets.length; ++i) {
            this.addBirthmarkSet(target, sets[i]);
        }
    }

    @Override
    public boolean isTableType() {
        return this.tableType;
    }

    @Override
    public void setTableType(boolean flag) {
        this.tableType = flag;
    }

    protected static String generateId() {
        SimpleDateFormat cdf = new SimpleDateFormat("yyyyMMdd-HHmmss.SSS");
        return cdf.format(Calendar.getInstance().getTime());
    }
}

