/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.stigmata.printer.xml;

import java.io.PrintWriter;
import java.util.Iterator;
import jp.sourceforge.stigmata.Birthmark;
import jp.sourceforge.stigmata.BirthmarkElement;
import jp.sourceforge.stigmata.BirthmarkSet;
import jp.sourceforge.stigmata.ExtractionResultSet;
import jp.sourceforge.stigmata.ExtractionTarget;
import jp.sourceforge.stigmata.printer.AbstractExtractionResultSetPrinter;

public class ExtractionResultSetXmlPrinter
extends AbstractExtractionResultSetPrinter {
    @Override
    public void printResult(PrintWriter out, ExtractionResultSet ers) {
        this.printHeader(out);
        out.printf("    <unit>%s</unit>%n", new Object[]{ers.getExtractionUnit()});
        out.printf("    <birthmark-types>%n", new Object[0]);
        for (String type : ers.getBirthmarkTypes()) {
            out.printf("      <birthmark-type>%s</birthmark-type>%n", type);
        }
        out.printf("    </birthmark-types>%n", new Object[0]);
        Iterator<BirthmarkSet> i = ers.birthmarkSets(ExtractionTarget.TARGET_BOTH);
        while (i.hasNext()) {
            this.printBirthmarkSet(out, i.next());
        }
        this.printFooter(out);
    }

    @Override
    public void printHeader(PrintWriter out) {
        out.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        out.println("<birthmark-result-set>");
        out.println("  <extracted-birthmarks>");
    }

    @Override
    public void printFooter(PrintWriter out) {
        out.println("  </extracted-birthmarks>");
        out.println("</birthmark-result-set>");
        out.flush();
    }

    public void printBirthmarkSet(PrintWriter out, BirthmarkSet set) {
        out.println("    <extracted-birthmark>");
        out.printf("      <name>%s</name>%n", this.escapeToXmlString(set.getName()));
        out.printf("      <location>%s</location>%n", this.escapeToXmlString(set.getLocation()));
        Iterator<String> i = set.birthmarkTypes();
        while (i.hasNext()) {
            String type = i.next();
            Birthmark birthmark = set.getBirthmark(type);
            out.printf("      <birthmark type=\"%s\" count=\"%d\">%n", birthmark.getType(), birthmark.getElementCount());
            Iterator<BirthmarkElement> elements = birthmark.iterator();
            while (elements.hasNext()) {
                out.printf("        <element>%s</element>%n", this.escapeToXmlString(String.valueOf(elements.next())));
            }
            out.println("      </birthmark>");
        }
        out.println("    </extracted-birthmark>");
    }

    public String escapeToXmlString(Object o) {
        if (o != null) {
            return this.escapeToXmlString(o.toString());
        }
        return null;
    }

    public String escapeToXmlString(String string) {
        string = string.replaceAll("&", "&amp;");
        string = string.replaceAll("\"", "&quot;");
        string = string.replaceAll("<", "&lt;");
        string = string.replaceAll(">", "&gt;");
        return string;
    }
}

