/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.stigmata.birthmarks.cvfv;

import jp.sourceforge.stigmata.BirthmarkComparator;
import jp.sourceforge.stigmata.BirthmarkElement;
import jp.sourceforge.stigmata.BirthmarkExtractor;
import jp.sourceforge.stigmata.birthmarks.AbstractBirthmarkService;
import jp.sourceforge.stigmata.birthmarks.comparators.PlainBirthmarkComparator;
import jp.sourceforge.stigmata.birthmarks.cvfv.ConstantValueOfFieldVariableBirthmarkExtractor;
import jp.sourceforge.stigmata.birthmarks.cvfv.TypeAndValueBirthmarkElement;
import jp.sourceforge.stigmata.spi.BirthmarkSpi;

public class ConstantValueOfFieldVariableBirthmarkService
extends AbstractBirthmarkService
implements BirthmarkSpi {
    private BirthmarkComparator comparator = new PlainBirthmarkComparator(this);
    private BirthmarkExtractor extractor = new ConstantValueOfFieldVariableBirthmarkExtractor(this);

    @Override
    public String getType() {
        return "cvfv";
    }

    @Override
    public String getDefaultDescription() {
        return "Field type and its initial value.";
    }

    @Override
    public BirthmarkExtractor getExtractor() {
        return this.extractor;
    }

    @Override
    public BirthmarkComparator getComparator() {
        return this.comparator;
    }

    @Override
    public boolean isExpert() {
        return false;
    }

    @Override
    public boolean isUserDefined() {
        return false;
    }

    @Override
    public BirthmarkElement buildBirthmarkElement(String value) {
        String signature = value.substring(0, value.indexOf(61));
        String subValue = value.substring(value.indexOf(61) + 1);
        Object elementValue = subValue;
        if (subValue.equals("null")) {
            elementValue = null;
        } else {
            switch (signature.charAt(0)) {
                case 'Z': {
                    if (value.equals("true")) {
                        elementValue = Boolean.TRUE;
                        break;
                    }
                    elementValue = Boolean.FALSE;
                    break;
                }
                case 'C': {
                    elementValue = new Character(subValue.charAt(0));
                    break;
                }
                case 'D': {
                    elementValue = new Double(subValue);
                    break;
                }
                case 'F': {
                    elementValue = new Float(subValue);
                    break;
                }
                case 'S': {
                    elementValue = new Short(subValue);
                    break;
                }
                case 'B': {
                    elementValue = new Byte(subValue);
                    break;
                }
                case 'I': {
                    elementValue = new Integer(subValue);
                    break;
                }
                default: {
                    elementValue = value;
                }
            }
        }
        return new TypeAndValueBirthmarkElement(signature, elementValue);
    }
}

