/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.stigmata.birthmarks.comparators;

import jp.sourceforge.stigmata.Birthmark;
import jp.sourceforge.stigmata.BirthmarkContext;
import jp.sourceforge.stigmata.BirthmarkElement;
import jp.sourceforge.stigmata.birthmarks.comparators.AbstractBirthmarkComparator;
import jp.sourceforge.stigmata.spi.BirthmarkSpi;

public class EditDistanceBirthmarkComparator
extends AbstractBirthmarkComparator {
    public EditDistanceBirthmarkComparator(BirthmarkSpi spi) {
        super(spi);
    }

    @Override
    public double compare(Birthmark b1, Birthmark b2, BirthmarkContext context) {
        if (!b1.getType().equals(b2.getType())) {
            return Double.NaN;
        }
        BirthmarkElement[] element1 = b1.getElements();
        BirthmarkElement[] element2 = b2.getElements();
        int[][] distance = this.createDistanceMatrics(element1, element2);
        int length = element1.length;
        if (length < element2.length) {
            length = element2.length;
        }
        int d = distance[element1.length][element2.length];
        if (element1.length == 0 && element2.length == 0) {
            return 1.0;
        }
        return (double)(length - d) / (double)length;
    }

    protected int[][] createDistanceMatrics(BirthmarkElement[] element1, BirthmarkElement[] element2) {
        int i;
        int[][] distance = new int[element1.length + 1][element2.length + 1];
        for (i = 0; i <= element1.length; ++i) {
            distance[i][0] = i;
        }
        for (i = 0; i <= element2.length; ++i) {
            distance[0][i] = i;
        }
        for (i = 1; i <= element1.length; ++i) {
            for (int j = 1; j <= element2.length; ++j) {
                int cost = 1;
                cost = element1[i - 1] == null ? (element2[j - 1] == null ? 0 : 1) : (element1[i - 1].equals(element2[j - 1]) ? 0 : 1);
                int insertion = distance[i - 1][j] + 1;
                int deletion = distance[i][j - 1] + 1;
                int replace = distance[i - 1][j - 1] + cost;
                distance[i][j] = insertion <= deletion && insertion <= replace ? insertion : (deletion <= replace ? deletion : replace);
            }
        }
        return distance;
    }
}

