/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.mds.cluster;

import jp.sourceforge.talisman.mds.Item;
import jp.sourceforge.talisman.mds.cluster.ClusteringParameter;
import jp.sourceforge.talisman.mds.distance.ClusterDistanceAlgorithm;
import jp.sourceforge.talisman.mds.distance.ClusterDistanceCalculator;
import jp.sourceforge.talisman.mds.distance.DistanceCalculatorFactory;
import jp.sourceforge.talisman.mds.distance.DistanceCalculatorNotFoundException;
import jp.sourceforge.talisman.mds.distance.ItemDistanceAlgorithm;
import jp.sourceforge.talisman.mds.distance.ItemDistanceCalculator;

public class HierarchicalClusteringParameter
extends ClusteringParameter {
    private ClusterDistanceCalculator clusterDistanceCalculator;

    public HierarchicalClusteringParameter(int numberOfCluster) {
        this.setNumberOfCluster(numberOfCluster);
    }

    public HierarchicalClusteringParameter(int numberOfCluster, ItemDistanceCalculator id, ClusterDistanceCalculator cdc) {
        this.setNumberOfCluster(numberOfCluster);
        this.setDistanceCalculator(id);
        this.setClusterDistanceCalculator(cdc);
        cdc.setItemDistanceCalculator(id);
    }

    public HierarchicalClusteringParameter(int numberOfCluster, ItemDistanceAlgorithm ida, ClusterDistanceAlgorithm cda) {
        this.setNumberOfCluster(numberOfCluster);
        this.setDistanceCalculator(ida);
        this.setClusterDistanceCalculator(cda);
        this.getClusterDistanceCalculator().setItemDistanceCalculator(ida);
    }

    public void setClusterDistanceCalculator(ClusterDistanceAlgorithm algorithm) {
        if (algorithm == null) {
            throw new NullPointerException();
        }
        if (this.getDistanceCalculator() == null) {
            throw new NullPointerException("distance calculator is required");
        }
        try {
            assert (this.getDistanceCalculator() != null);
            this.setClusterDistanceCalculator(DistanceCalculatorFactory.getInstance().getClusterDistanceCalculator(algorithm, this.getDistanceCalculator().getAlgorithm()));
        }
        catch (DistanceCalculatorNotFoundException e) {
            throw new InternalError();
        }
    }

    public void setClusterDistanceCalculator(ClusterDistanceCalculator cdc) {
        if (cdc == null) {
            throw new NullPointerException();
        }
        this.clusterDistanceCalculator = cdc;
    }

    public ClusterDistanceCalculator getClusterDistanceCalculator() {
        return this.clusterDistanceCalculator;
    }

    public void setDistanceCalculator(ItemDistanceCalculator idc) {
        super.setDistanceCalculator(idc);
        if (this.clusterDistanceCalculator != null) {
            this.clusterDistanceCalculator.setItemDistanceCalculator(idc);
        }
    }

    public boolean isValid(Item[] items) {
        return items.length >= this.getNumberOfCluster() && this.getClusterDistanceCalculator() != null && this.getDistanceCalculator() != null;
    }
}

