package jp.naist.se.stigmata.spi;

/*
 * $Id: AbstractServiceProvider.java 140 2007-06-28 10:48:47Z tama3 $
 */

import java.util.Locale;

/**
 * Base abstract class for birthmark SPI.
 *
 * @author Haruaki TAMADA
 * @version $Revision: 140 $ $Date: 2007-06-28 19:48:47 +0900 (Thu, 28 Jun 2007) $
 */
public abstract class AbstractServiceProvider implements ServiceProvider{

    /**
     * returning implementation vendor name of this SPI.
     */
    public String getDescription(){
        return getDescription(Locale.getDefault());
    }

    /**
     * returning implementation vendor name of this SPI.
     */
    public String getVendorName(){
        return getClass().getPackage().getImplementationVendor();
    }

    /**
     * returning version of this SPI.
     */
    public String getVersion(){
        return getClass().getPackage().getImplementationVersion();
    }

}
