package jp.naist.se.stigmata.result;

/*
 * $Id: XmlFileExtractedBirthmarkService.java 254 2007-10-26 01:31:44Z tama3 $
 */

import java.io.File;

import jp.naist.se.stigmata.BirthmarkContext;
import jp.naist.se.stigmata.BirthmarkEnvironment;
import jp.naist.se.stigmata.BirthmarkStoreTarget;
import jp.naist.se.stigmata.ExtractionResultSet;
import jp.naist.se.stigmata.result.history.ExtractedBirthmarkHistory;
import jp.naist.se.stigmata.result.history.XmlFileExtractedBirthmarkHistory;
import jp.naist.se.stigmata.spi.ExtractedBirthmarkSpi;

/**
 * 
 * @author Haruaki Tamada
 * @version $Revision: 254 $ $Date: 2007-10-26 10:31:44 +0900 (Fri, 26 Oct 2007) $
 */
public class XmlFileExtractedBirthmarkService implements ExtractedBirthmarkSpi{
    private File defaultBaseDirectory;

    public XmlFileExtractedBirthmarkService(){
        defaultBaseDirectory = new File(
            BirthmarkEnvironment.getStigmataHome(),
            "extracted_birthmarks"
        );
    }

    public ExtractionResultSet createResultSet(BirthmarkContext context){
        return createResultSet(context, defaultBaseDirectory);
    }

    public ExtractionResultSet createResultSet(BirthmarkContext context, File base){
        return new XmlFileExtractionResultSet(
            context, new File(base, AbstractExtractionResultSet.generateId())
        );
    }

    public ExtractedBirthmarkHistory getHistory(String parameter){
        File file = defaultBaseDirectory;
        if(parameter != null){
            file = new File(parameter);
        }
        return new XmlFileExtractedBirthmarkHistory(file);
    }

    public ExtractionResultSet getResultSet(String id){
        return new XmlFileExtractionResultSet(new File(id));
    }

    public BirthmarkStoreTarget getTarget(){
        return BirthmarkStoreTarget.XMLFILE;
    }
}
