package jp.naist.se.stigmata.result;

/*
 * $Id: MemoryExtractedBirthmarkService.java 254 2007-10-26 01:31:44Z tama3 $
 */

import jp.naist.se.stigmata.BirthmarkContext;
import jp.naist.se.stigmata.BirthmarkStoreTarget;
import jp.naist.se.stigmata.ExtractionResultSet;
import jp.naist.se.stigmata.result.history.ExtractedBirthmarkHistory;
import jp.naist.se.stigmata.result.history.MemoryExtractedBirthmarkHistory;
import jp.naist.se.stigmata.spi.ExtractedBirthmarkSpi;

/**
 * 
 * @author Haruaki Tamada
 * @version $Revision: 254 $ $Date: 2007-10-26 10:31:44 +0900 (Fri, 26 Oct 2007) $
 */
public class MemoryExtractedBirthmarkService implements ExtractedBirthmarkSpi{
    private MemoryExtractedBirthmarkHistory history = new MemoryExtractedBirthmarkHistory();

    public ExtractionResultSet createResultSet(BirthmarkContext context){
        MemoryExtractionResultSet mers = new MemoryExtractionResultSet(context);
        history.addResultSet(mers);
        return mers;
    }

    public ExtractedBirthmarkHistory getHistory(String parameter){
        return history;
    }

    public ExtractionResultSet getResultSet(String id){
        return history.getResultSet(id);
    }

    public BirthmarkStoreTarget getTarget(){
        return BirthmarkStoreTarget.MEMORY;
    }

}
