package jp.naist.se.stigmata.printer;

/*
 * $Id: AbstractComparisonResultSetPrinter.java 243 2007-10-08 01:27:30Z tama3 $
 */

import java.io.PrintWriter;
import java.io.StringWriter;

import jp.naist.se.stigmata.ComparisonResultSet;

/**
 * 
 * 
 *
 * @author Haruaki TAMADA
 * @version $Revision: 243 $ $Date: 2007-10-08 10:27:30 +0900 (Mon, 08 Oct 2007) $
 */
public abstract class AbstractComparisonResultSetPrinter implements ComparisonResultSetPrinter, Printer{
    public abstract void printResult(PrintWriter out, ComparisonResultSet resultset);

    public void printHeader(PrintWriter out){
    }

    public void printFooter(PrintWriter out){
        out.flush();
    }

    public String getResult(ComparisonResultSet resultset){
        StringWriter writer = new StringWriter();
        PrintWriter out = new PrintWriter(writer);

        printResult(out, resultset);

        out.close();
        return writer.toString();
    }
}
