package jp.naist.se.stigmata.birthmarks.kgram;

/*
 * $Id: KGramBasedBirthmarkService.java 233 2007-10-04 06:17:52Z tama3 $
 */

import jp.naist.se.stigmata.BirthmarkComparator;
import jp.naist.se.stigmata.BirthmarkElement;
import jp.naist.se.stigmata.BirthmarkExtractor;
import jp.naist.se.stigmata.birthmarks.AbstractBirthmarkService;
import jp.naist.se.stigmata.birthmarks.comparators.LogicalAndBirthmarkComparator;
import jp.naist.se.stigmata.spi.BirthmarkSpi;

/**
 * 
 * 
 *
 * @author Haruaki TAMADA
 * @version $Revision: 233 $ $Date: 2007-10-04 15:17:52 +0900 (Thu, 04 Oct 2007) $
 */
public class KGramBasedBirthmarkService extends AbstractBirthmarkService implements BirthmarkSpi{
    private BirthmarkComparator comparator = new LogicalAndBirthmarkComparator(this);
    private BirthmarkExtractor extractor = new KGramBasedBirthmarkExtractor(this);

    public String getType(){
        return "kgram";
    }

    public String getDefaultDescription(){
        return "k-gram based birthmark.";
    }

    public BirthmarkExtractor getExtractor(){
        return extractor;
    }

    public BirthmarkComparator getComparator(){
        return comparator;
    }

    public boolean isExpert(){
        return false;
    }

    public boolean isUserDefined(){
        return false;
    }

	@Override
	public BirthmarkElement buildBirthmarkElement(String value) {
		value = value.trim();
		if(value.startsWith("{") && value.endsWith("}")){
			String[] param = value.substring(1, value.length() - 1).split(", *");
			KGram<Integer> kgram = new KGram<Integer>(param.length);
			for(int i = 0; i < param.length; i++){
				kgram.set(i, new Integer(param[i].trim()));
			}
			return new KGramBasedBirthmarkElement<Integer>(kgram);
		}
		return null;
	}
}
