package jp.naist.se.stigmata;

/*
 * $Id: BirthmarkElementClassNotFoundException.java 215 2007-09-25 09:04:12Z tama3 $
 */

import java.util.ArrayList;
import java.util.List;

/**
 * Thrown if extracting birthmark is failed to find a class definition.
 * 
 * @author Haruaki TAMADA
 * @version $Revision: 215 $ $Date: 2007-09-25 18:04:12 +0900 (Tue, 25 Sep 2007) $
 */
public class BirthmarkElementClassNotFoundException extends
               BirthmarkExtractionFailedException {
    private static final long serialVersionUID = 3256723476854L;

    /**
     * class name list, which names are failed to load.
     */
    private List<String> classnames = new ArrayList<String>();

    /**
     * 
     */
    public void addClassName(String name){
       classnames.add(name);
    }

    @Override
    public boolean isFailed(){
       return super.isFailed() || classnames.size() > 0;
    }

    /**
     * returns an array of class names which are failed loading.
     */
    public synchronized String[] getClassNames(){
       return classnames.toArray(new String[classnames.size()]);
    }

    @Override
    public String getMessage(){
       StringBuffer sb = new StringBuffer();
       boolean first = true;
       for(String value: classnames){
           if(!first){
               sb.append(", ");
           }
           sb.append(value);
       }
       return new String(sb);
    }
}