/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.ui.swing.filter;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jp.naist.se.stigmata.ComparisonPairFilter;
import jp.naist.se.stigmata.ComparisonPairFilterSet;
import jp.naist.se.stigmata.ui.swing.GUIUtility;
import jp.naist.se.stigmata.ui.swing.Messages;
import jp.naist.se.stigmata.ui.swing.filter.ComparisonPairFilterListener;
import jp.naist.se.stigmata.ui.swing.filter.ComparisonPairFilterRetainable;

public class FilterSetDefinitionPane
extends JPanel
implements ComparisonPairFilterListener {
    private static final long serialVersionUID = 7519306603672717119L;
    private ComparisonPairFilterRetainable manager;
    private JTextField name;
    private JRadioButton matchall;
    private JRadioButton matchany;
    private JList list;
    private DefaultListModel model;
    private ComparisonPairFilterSet filterset;
    private boolean buttonShown = true;
    private JButton addfilter;
    private JButton updatefilter;
    private JButton removefilter;
    private JButton upButton;
    private JButton downButton;

    public FilterSetDefinitionPane(ComparisonPairFilterRetainable manager) {
        this(manager, true);
    }

    public FilterSetDefinitionPane(ComparisonPairFilterRetainable manager, boolean showButtons) {
        this.manager = manager;
        this.initLayouts(showButtons);
    }

    public void reset() {
    }

    public void setFilterSet(ComparisonPairFilterSet filterset) {
        this.filterset = filterset;
        if (filterset != null) {
            this.model.removeAllElements();
            this.name.setText(filterset.getName());
            this.matchall.setSelected(filterset.isMatchAll());
            this.matchany.setSelected(filterset.isMatchAny());
            for (ComparisonPairFilter filter : filterset) {
                this.model.addElement(filter);
            }
        }
    }

    public void filterAdded(ComparisonPairFilter filter) {
        this.model.addElement(filter);
        this.list.setSelectedIndex(this.model.getSize() - 1);
        this.updateButtonEnabled();
    }

    public void filterRemoved(ComparisonPairFilter filter) {
        this.model.removeElement(filter);
        this.list.clearSelection();
        this.updateButtonEnabled();
    }

    public void filterUpdated(ComparisonPairFilter oldfilter, ComparisonPairFilter newfilter) {
        int index = this.model.indexOf(oldfilter);
        if (index >= 0) {
            this.model.setElementAt(newfilter, index);
        }
        this.updateButtonEnabled();
    }

    public void setEnabled(boolean flag) {
        super.setEnabled(flag);
        this.matchall.setEnabled(flag);
        this.matchany.setEnabled(flag);
        this.name.setEnabled(flag);
        this.list.setEnabled(flag);
    }

    private void initLayouts(boolean showButtons) {
        this.buttonShown = showButtons;
        ButtonGroup group = new ButtonGroup();
        this.matchall = new JRadioButton(Messages.getString("matchall.button.label"), true);
        this.matchall.setToolTipText(Messages.getString("matchall.button.tooltip"));
        group.add(this.matchall);
        this.matchany = new JRadioButton(Messages.getString("matchany.button.label"), false);
        this.matchany.setToolTipText(Messages.getString("matchany.button.tooltip"));
        group.add(this.matchany);
        JPanel north = new JPanel(new GridLayout(3, 1));
        this.name = new JTextField();
        north.add(this.name);
        north.add(this.matchall);
        north.add(this.matchany);
        this.addfilter = GUIUtility.createButton("newfilterset");
        this.updatefilter = GUIUtility.createButton("updatefilterset");
        this.removefilter = GUIUtility.createButton("removefilterset");
        this.upButton = GUIUtility.createButton("moveup");
        this.downButton = GUIUtility.createButton("movedown");
        Box south = Box.createHorizontalBox();
        south.add(Box.createHorizontalGlue());
        south.add(this.addfilter);
        south.add(Box.createHorizontalGlue());
        south.add(this.updatefilter);
        south.add(Box.createHorizontalGlue());
        south.add(this.removefilter);
        south.add(Box.createHorizontalGlue());
        south.add(this.upButton);
        south.add(Box.createHorizontalGlue());
        south.add(this.downButton);
        south.add(Box.createHorizontalGlue());
        this.model = new DefaultListModel();
        this.list = new JList(this.model);
        this.list.setSelectionMode(0);
        this.list.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                FilterSetDefinitionPane.this.manager.filterSelected((ComparisonPairFilter)FilterSetDefinitionPane.this.list.getSelectedValue());
                FilterSetDefinitionPane.this.updateButtonEnabled();
            }
        });
        this.addfilter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ComparisonPairFilterSet current = FilterSetDefinitionPane.this.createCurrentFilterSet();
                FilterSetDefinitionPane.this.filterset = current;
                FilterSetDefinitionPane.this.manager.addFilterSet(FilterSetDefinitionPane.this.filterset);
                FilterSetDefinitionPane.this.list.clearSelection();
                FilterSetDefinitionPane.this.manager.filterSelected(null);
                FilterSetDefinitionPane.this.updateButtonEnabled();
            }
        });
        this.removefilter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FilterSetDefinitionPane.this.manager.removeFilterSet(FilterSetDefinitionPane.this.filterset.getName());
                FilterSetDefinitionPane.this.filterset = null;
                FilterSetDefinitionPane.this.name.setText("");
                FilterSetDefinitionPane.this.matchall.setSelected(true);
                FilterSetDefinitionPane.this.matchany.setSelected(false);
                FilterSetDefinitionPane.this.model.removeAllElements();
                FilterSetDefinitionPane.this.manager.filterSelected(null);
                FilterSetDefinitionPane.this.updateButtonEnabled();
            }
        });
        this.updatefilter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ComparisonPairFilterSet current = FilterSetDefinitionPane.this.createCurrentFilterSet();
                FilterSetDefinitionPane.this.manager.updateFilterSet(FilterSetDefinitionPane.this.filterset.getName(), current);
                FilterSetDefinitionPane.this.filterset = current;
                FilterSetDefinitionPane.this.list.clearSelection();
                FilterSetDefinitionPane.this.manager.filterSelected(null);
                FilterSetDefinitionPane.this.updateButtonEnabled();
            }
        });
        ActionListener listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int index = FilterSetDefinitionPane.this.list.getSelectedIndex();
                int step = 1;
                if (e.getActionCommand().equals("moveup")) {
                    step = -1;
                }
                Object element1 = FilterSetDefinitionPane.this.model.get(index);
                Object element2 = FilterSetDefinitionPane.this.model.get(index + step);
                FilterSetDefinitionPane.this.model.setElementAt(element1, index + step);
                FilterSetDefinitionPane.this.model.setElementAt(element2, index);
                FilterSetDefinitionPane.this.list.setSelectedIndex(index + step);
            }
        };
        this.name.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                FilterSetDefinitionPane.this.updateButtonEnabled();
            }

            public void insertUpdate(DocumentEvent e) {
                FilterSetDefinitionPane.this.updateButtonEnabled();
            }

            public void removeUpdate(DocumentEvent e) {
                FilterSetDefinitionPane.this.updateButtonEnabled();
            }
        });
        this.upButton.addActionListener(listener);
        this.downButton.addActionListener(listener);
        JScrollPane listpane = new JScrollPane(this.list);
        this.setLayout(new BorderLayout());
        this.add((Component)north, "North");
        this.add((Component)listpane, "Center");
        if (showButtons) {
            this.add((Component)south, "South");
        }
        GUIUtility.decorateJComponent(this.name, "filtername");
        GUIUtility.decorateJComponent(listpane, "filterorder");
        this.setEnabled(this.buttonShown);
        this.updateButtonEnabled();
    }

    private void updateButtonEnabled() {
        if (this.buttonShown) {
            int index = this.list.getSelectedIndex();
            int size = this.model.getSize();
            this.upButton.setEnabled(size > 1 && index > 0);
            this.downButton.setEnabled(size > 1 && index < size - 1);
            this.updatefilter.setEnabled(this.filterset != null);
            this.addfilter.setEnabled(size > 0 && this.name.getText().length() > 0 && this.manager.getFilterSet(this.name.getText()) == null);
            this.removefilter.setEnabled(this.filterset != null);
        }
    }

    private ComparisonPairFilterSet createCurrentFilterSet() {
        ComparisonPairFilterSet current = new ComparisonPairFilterSet();
        current.setName(this.name.getText());
        if (this.matchall.isSelected()) {
            current.setMatchAll();
        } else if (this.matchany.isSelected()) {
            current.setMatchAny();
        }
        current.removeAllFilters();
        int i = 0;
        while (i < this.model.getSize()) {
            current.addFilter((ComparisonPairFilter)this.model.get(i));
            ++i;
        }
        return current;
    }
}

