/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.ui.swing.actions;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import jp.naist.se.stigmata.BirthmarkEnvironment;
import jp.naist.se.stigmata.ui.swing.CompareTableCellRenderer;
import jp.naist.se.stigmata.ui.swing.GUIUtility;
import jp.naist.se.stigmata.ui.swing.Messages;

public class UpdateBirthmarkCellColorAction
extends AbstractAction {
    private static final long serialVersionUID = 2390797591047570440L;
    private Component parent;
    private BirthmarkEnvironment environment;
    private JColorChooser chooser;

    public UpdateBirthmarkCellColorAction(Component parent, BirthmarkEnvironment environment) {
        this.parent = parent;
        this.environment = environment;
    }

    public UpdateBirthmarkCellColorAction(Component parent) {
        this(parent, BirthmarkEnvironment.getDefaultEnvironment());
    }

    public void actionPerformed(ActionEvent e) {
        JComponent c = this.createPanel();
        JOptionPane.showMessageDialog(this.parent, c, Messages.getString("updatecellcolor.dialog.title"), 1);
    }

    private JComponent createPanel() {
        Box panel = Box.createVerticalBox();
        int i = 0;
        while (i <= 5) {
            Color fore = CompareTableCellRenderer.getForegroundColor(i, this.environment);
            Color back = CompareTableCellRenderer.getBackgroundColor(i, this.environment);
            UpdateColorPane pane = new UpdateColorPane(i, fore, back);
            panel.add(pane);
            ++i;
        }
        return panel;
    }

    private Color updateColor(Color c, int rank, boolean foreground) {
        if (this.chooser == null) {
            this.chooser = new JColorChooser();
        }
        this.chooser.setColor(c);
        String l = Messages.getString(String.valueOf(foreground ? "forecolor_" : "backcolor_") + rank + ".label");
        int returnValue = JOptionPane.showConfirmDialog(this.parent, this.chooser, Messages.getString("updatecell.title", l), 1);
        if (returnValue == 0) {
            c = this.chooser.getColor();
        }
        return c;
    }

    private class UpdateColorPane
    extends JPanel {
        private static final long serialVersionUID = 8271684478406307685L;
        private int rank;
        private JLabel label;

        public UpdateColorPane(int rank, Color fore, Color back) {
            this.rank = rank;
            this.initLayouts();
            this.label.setForeground(fore);
            this.label.setBackground(back);
        }

        public int getRank() {
            return this.rank;
        }

        private void initLayouts() {
            this.label = new JLabel(Messages.getString("rank_" + this.rank + ".label"));
            this.label.setOpaque(true);
            JButton fore = GUIUtility.createButton("updatecellfore");
            JButton back = GUIUtility.createButton("updatecellback");
            ActionListener listener = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String command = e.getActionCommand();
                    boolean foreground = command.equals("updatecellfore");
                    Color c = UpdateColorPane.this.label.getBackground();
                    if (foreground) {
                        c = UpdateColorPane.this.label.getForeground();
                    }
                    c = UpdateBirthmarkCellColorAction.this.updateColor(c, UpdateColorPane.this.getRank(), foreground);
                    if (foreground) {
                        UpdateColorPane.this.label.setForeground(c);
                        UpdateBirthmarkCellColorAction.this.environment.addProperty("forecolor_" + UpdateColorPane.this.getRank(), String.format("%06x", c.getRGB() & 0xFFFFFF));
                    } else {
                        UpdateColorPane.this.label.setBackground(c);
                        UpdateBirthmarkCellColorAction.this.environment.addProperty("backcolor_" + UpdateColorPane.this.getRank(), String.format("%06x", c.getRGB() & 0xFFFFFF));
                    }
                }
            };
            fore.addActionListener(listener);
            back.addActionListener(listener);
            this.setLayout(new GridLayout(1, 3));
            this.add(this.label);
            this.add(fore);
            this.add(back);
        }
    }
}

